/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.ic2.machines;

import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.mods.ic2.IC2RecipeInput;
import minetweaker.mods.ic2.MachineAddRecipeAction;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.NotNull;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.ic2.BlockCutter")
@ModOnly(value={"IC2"})
public class BlockCutter {
    @ZenMethod
    public static void addRecipe(@NotNull IItemStack output, @NotNull IIngredient ingredient) {
        if (ingredient.getAmount() < 0) {
            MineTweakerAPI.logWarning("invalid ingredient: " + ingredient + " - stack size not known");
        } else {
            MineTweakerAPI.apply(new MachineAddRecipeAction("block cutter", Recipes.blockcutter, MineTweakerMC.getItemStacks(output), null, new IC2RecipeInput(ingredient)));
        }
    }

    @ZenMethod
    public static IItemStack getOutput(@NotNull IItemStack input) {
        RecipeOutput output = Recipes.blockcutter.getOutputFor(MineTweakerMC.getItemStack(input), false);
        if (output == null || output.items.isEmpty()) {
            return null;
        }
        return MineTweakerMC.getIItemStack((ItemStack)output.items.get(0));
    }
}

