/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.api.item;

import minetweaker.api.data.IData;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemCondition;
import minetweaker.api.item.IItemStack;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenExpansion(value="minetweaker.item.IIngredient")
public class IngredientCondition {
    @ZenMethod
    public static IIngredient onlyDamaged(IIngredient ingredient) {
        return ingredient.only(new IItemCondition(){

            @Override
            public boolean matches(IItemStack stack) {
                return stack.getDamage() > 0;
            }
        });
    }

    @ZenMethod
    public static IIngredient onlyDamageAtLeast(IIngredient ingredient, final int minDamage) {
        return ingredient.only(new IItemCondition(){

            @Override
            public boolean matches(IItemStack stack) {
                return stack.getDamage() >= minDamage;
            }
        });
    }

    @ZenMethod
    public static IIngredient onlyDamageAtMost(IIngredient ingredient, final int maxDamage) {
        return ingredient.only(new IItemCondition(){

            @Override
            public boolean matches(IItemStack stack) {
                return stack.getDamage() <= maxDamage;
            }
        });
    }

    @ZenMethod
    public static IIngredient onlyDamageBetween(IIngredient ingredient, final int minDamage, final int maxDamage) {
        return ingredient.only(new IItemCondition(){

            @Override
            public boolean matches(IItemStack stack) {
                return stack.getDamage() >= minDamage && stack.getDamage() <= maxDamage;
            }
        });
    }

    @ZenMethod
    public static IIngredient onlyWithTag(IIngredient ingredient, final IData data) {
        return ingredient.only(new IItemCondition(){

            @Override
            public boolean matches(IItemStack stack) {
                return stack.getTag() != null && stack.getTag().contains(data);
            }
        });
    }

    @ZenMethod
    public static IIngredient onlyStack(IIngredient ingredient, final int amount) {
        return ingredient.only(new IItemCondition(){

            @Override
            public boolean matches(IItemStack stack) {
                return stack.getAmount() >= amount;
            }
        });
    }
}

