/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1710.recipes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.MineTweakerImplementationAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.player.IPlayer;
import minetweaker.api.recipes.ICraftingInventory;
import minetweaker.api.recipes.ICraftingRecipe;
import minetweaker.api.recipes.IRecipeAction;
import minetweaker.api.recipes.IRecipeFunction;
import minetweaker.api.recipes.IRecipeManager;
import minetweaker.api.recipes.ShapedRecipe;
import minetweaker.api.recipes.ShapelessRecipe;
import minetweaker.mc1710.item.MCItemStack;
import minetweaker.mc1710.recipes.RecipeConverter;
import minetweaker.mc1710.util.MineTweakerHacks;
import minetweaker.util.IEventHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.lang3.tuple.Pair;
import stanhebben.zenscript.annotations.Optional;

public final class MCRecipeManager
implements IRecipeManager {
    public static final List<ActionBaseAddRecipe> recipesToAdd = new ArrayList<ActionBaseAddRecipe>();
    public static final List<ActionBaseRemoveRecipes> recipesToRemove = new ArrayList<ActionBaseRemoveRecipes>();
    public static final ActionRemoveRecipesNoIngredients actionRemoveRecipesNoIngredients = new ActionRemoveRecipesNoIngredients();
    public static final List<IRecipe> recipesToUndo = new ArrayList<IRecipe>();
    public static List<IRecipe> recipes;
    public static final List<ICraftingRecipe> transformerRecipes;

    public MCRecipeManager() {
        MineTweakerImplementationAPI.onPostReload(new HandleLateAdditionsAndRemovals());
        MineTweakerImplementationAPI.onRollbackEvent(new HandleLateAdditionsAndRemovals());
    }

    public static boolean hasTransformerRecipes() {
        return transformerRecipes.size() > 0;
    }

    public static void applyTransformations(ICraftingInventory inventory, IPlayer byPlayer) {
        for (ICraftingRecipe recipe : transformerRecipes) {
            if (!recipe.matches(inventory)) continue;
            recipe.applyTransformers(inventory, byPlayer);
            return;
        }
    }

    private static boolean matches(Object input, IIngredient ingredient) {
        if (input == null != (ingredient == null)) {
            return false;
        }
        if (ingredient != null) {
            if (input instanceof ItemStack) {
                return ingredient.matches(MineTweakerMC.getIItemStack((ItemStack)input));
            }
            if (input instanceof String) {
                return ingredient.contains(MineTweakerMC.getOreDict((String)input));
            }
        }
        return true;
    }

    @Override
    public List<ICraftingRecipe> getAll() {
        ArrayList<ICraftingRecipe> results = new ArrayList<ICraftingRecipe>();
        for (IRecipe recipe : recipes) {
            ICraftingRecipe converted = RecipeConverter.toCraftingRecipe(recipe);
            results.add(converted);
        }
        return results;
    }

    @Override
    public List<ICraftingRecipe> getRecipesFor(IIngredient ingredient) {
        ArrayList<ICraftingRecipe> results = new ArrayList<ICraftingRecipe>();
        for (IRecipe recipe : recipes) {
            if (!ingredient.matches(MineTweakerMC.getIItemStack(recipe.func_77571_b()))) continue;
            ICraftingRecipe converted = RecipeConverter.toCraftingRecipe(recipe);
            results.add(converted);
        }
        return results;
    }

    @Override
    public int remove(IIngredient output) {
        return this.remove(output, false);
    }

    @Override
    public int remove(IIngredient output, @Optional boolean nbtMatch) {
        if (output == null) {
            MineTweakerAPI.logError("Cannot remove recipes for a null item!");
            return 0;
        }
        actionRemoveRecipesNoIngredients.addOutput(output, nbtMatch);
        return 1;
    }

    @Override
    public void addShaped(IItemStack output, IIngredient[][] ingredients, IRecipeFunction function) {
        recipesToAdd.add(new ActionAddShapedRecipe(output, ingredients, function, null, false));
    }

    @Override
    public void addShaped(IItemStack output, IIngredient[][] ingredients, IRecipeAction action) {
        recipesToAdd.add(new ActionAddShapedRecipe(output, ingredients, null, action, false));
    }

    @Override
    public void addShaped(IItemStack output, IIngredient[][] ingredients) {
        recipesToAdd.add(new ActionAddShapedRecipe(output, ingredients, null, null, false));
    }

    @Override
    public void addShaped(IItemStack output, IIngredient[][] ingredients, IRecipeFunction function, IRecipeAction action) {
        recipesToAdd.add(new ActionAddShapedRecipe(output, ingredients, function, action, false));
    }

    @Override
    public void addShapedMirrored(IItemStack output, IIngredient[][] ingredients, IRecipeFunction function) {
        recipesToAdd.add(new ActionAddShapedRecipe(output, ingredients, function, null, true));
    }

    @Override
    public void addShapedMirrored(IItemStack output, IIngredient[][] ingredients) {
        recipesToAdd.add(new ActionAddShapedRecipe(output, ingredients, null, null, true));
    }

    @Override
    public void addShapedMirrored(IItemStack output, IIngredient[][] ingredients, IRecipeAction action) {
        recipesToAdd.add(new ActionAddShapedRecipe(output, ingredients, null, action, true));
    }

    @Override
    public void addShapedMirrored(IItemStack output, IIngredient[][] ingredients, IRecipeFunction function, IRecipeAction action) {
        recipesToAdd.add(new ActionAddShapedRecipe(output, ingredients, function, action, true));
    }

    @Override
    public void addShapeless(IItemStack output, IIngredient[] ingredients, IRecipeFunction function, IRecipeAction action) {
        if (this.checkShapelessNulls(output, ingredients)) {
            return;
        }
        recipesToAdd.add(new ActionAddShapelessRecipe(output, ingredients, function, action));
    }

    @Override
    public void addShapeless(IItemStack output, IIngredient[] ingredients, IRecipeFunction function) {
        this.addShapeless(output, ingredients, function, null);
    }

    @Override
    public void addShapeless(IItemStack output, IIngredient[] ingredients, IRecipeAction action) {
        this.addShapeless(output, ingredients, null, action);
    }

    @Override
    public void addShapeless(IItemStack output, IIngredient[] ingredients) {
        this.addShapeless(output, ingredients, null, null);
    }

    private boolean checkShapelessNulls(IItemStack output, IIngredient[] ingredients) {
        if (output != null && Arrays.stream(ingredients).allMatch(Objects::isNull)) {
            MineTweakerAPI.logError("Null not allowed in shapeless recipes! Recipe for: " + output + " not created!");
            return true;
        }
        return false;
    }

    @Override
    public int removeShaped(IIngredient output, IIngredient[][] ingredients) {
        if (output == null) {
            MineTweakerAPI.logError("Cannot remove recipes for a null item!");
            return 0;
        }
        recipesToRemove.add(new ActionRemoveShapedRecipes(output, ingredients));
        return 1;
    }

    @Override
    public int removeShaped(IIngredient output) {
        return this.removeShaped(output, null);
    }

    @Override
    public int removeShapeless(IIngredient output, IIngredient[] ingredients, boolean wildcard) {
        if (output == null) {
            MineTweakerAPI.logError("Cannot remove recipes for a null item!");
            return 0;
        }
        recipesToRemove.add(new ActionRemoveShapelessRecipes(output, ingredients, wildcard));
        return 1;
    }

    @Override
    public int removeShapeless(IIngredient output, IIngredient[] ingredients) {
        return this.removeShapeless(output, ingredients, false);
    }

    @Override
    public int removeShapeless(IIngredient output, boolean wildcard) {
        return this.removeShapeless(output, null, wildcard);
    }

    @Override
    public int removeShapeless(IIngredient output) {
        return this.removeShapeless(output, null, true);
    }

    @Override
    public IItemStack craft(IItemStack[][] contents) {
        ContainerVirtual container = new ContainerVirtual();
        int width = 0;
        int height = contents.length;
        for (IItemStack[] row : contents) {
            width = Math.max(width, row.length);
        }
        ItemStack[] iContents = new ItemStack[width * height];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < contents[i].length; ++j) {
                if (contents[i][j] == null) continue;
                iContents[i * width + j] = MineTweakerMC.getItemStack(contents[i][j]);
            }
        }
        InventoryCrafting inventory = new InventoryCrafting((Container)container, width, height);
        for (int i = 0; i < iContents.length; ++i) {
            inventory.func_70299_a(i, iContents[i]);
        }
        ItemStack result = CraftingManager.func_77594_a().func_82787_a(inventory, null);
        if (result == null) {
            return null;
        }
        return MineTweakerMC.getIItemStack(result);
    }

    public static void applyAdditionsAndRemovals() {
        System.out.println("MineTweaker: Applying additions and removals");
        MineTweakerAPI.apply(actionRemoveRecipesNoIngredients);
        if (recipesToUndo.size() > 0) {
            recipes.removeIf(recipesToUndo::contains);
        }
        recipesToRemove.forEach(MineTweakerAPI::apply);
        recipesToAdd.forEach(MineTweakerAPI::apply);
        actionRemoveRecipesNoIngredients.clearOutputs();
        recipesToRemove.clear();
        recipesToAdd.clear();
        recipesToUndo.clear();
    }

    static {
        transformerRecipes = new ArrayList<ICraftingRecipe>();
    }

    private class ContainerVirtual
    extends Container {
        private ContainerVirtual() {
        }

        public boolean func_75145_c(EntityPlayer var1) {
            return false;
        }
    }

    public static class HandleLateAdditionsAndRemovals
    implements IEventHandler<MineTweakerImplementationAPI.ReloadEvent> {
        @Override
        public void handle(MineTweakerImplementationAPI.ReloadEvent event) {
            MCRecipeManager.applyAdditionsAndRemovals();
        }
    }

    private static class ActionAddShapelessRecipe
    extends ActionBaseAddRecipe {
        public ActionAddShapelessRecipe(IItemStack output, IIngredient[] ingredients, IRecipeFunction function, IRecipeAction action) {
            super(new ShapelessRecipe(output, ingredients, function, action), output, false);
        }
    }

    private static class ActionAddShapedRecipe
    extends ActionBaseAddRecipe {
        public ActionAddShapedRecipe(IItemStack output, IIngredient[][] ingredients, IRecipeFunction function, IRecipeAction action, boolean mirrored) {
            super(new ShapedRecipe(output, ingredients, function, action, mirrored), output, true);
        }
    }

    public static class ActionBaseAddRecipe
    implements IUndoableAction {
        private final IRecipe iRecipe;
        private final ICraftingRecipe craftingRecipe;
        protected final IItemStack output;
        protected final boolean isShaped;
        protected final boolean isRestoring;

        private ActionBaseAddRecipe(IRecipe iRecipe) {
            this.iRecipe = iRecipe;
            this.craftingRecipe = null;
            this.isRestoring = true;
            this.isShaped = iRecipe instanceof ShapedRecipes;
            this.output = new MCItemStack(iRecipe.func_77571_b());
        }

        private ActionBaseAddRecipe(ICraftingRecipe craftingRecipe, IItemStack output, boolean isShaped) {
            this.iRecipe = RecipeConverter.convert(craftingRecipe);
            this.craftingRecipe = craftingRecipe;
            this.isRestoring = false;
            this.output = output;
            this.isShaped = isShaped;
        }

        @Override
        public void apply() {
            recipes.add(this.iRecipe);
            if (this.craftingRecipe != null && this.craftingRecipe.hasTransformers()) {
                transformerRecipes.add(this.craftingRecipe);
            }
        }

        @Override
        public boolean canUndo() {
            return this.iRecipe != null;
        }

        @Override
        public void undo() {
            recipesToUndo.add(this.iRecipe);
        }

        @Override
        public String describe() {
            if (this.output != null) {
                return "" + (this.isRestoring ? "Restoring" : "Adding ") + (this.isShaped ? "shaped" : "shapeless") + " recipe for " + this.output.getDisplayName();
            }
            return "Trying to add " + (this.isShaped ? "shaped" : "shapeless") + "recipe without correct output";
        }

        @Override
        public String describeUndo() {
            return "Undoing addition of " + this.output.getDisplayName();
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    public static class ActionRemoveShapedRecipes
    extends ActionBaseRemoveRecipes
    implements IUndoableAction {
        final IIngredient output;
        final IIngredient[][] ingredients;
        final Set<IRecipe> toRemove = new HashSet<IRecipe>();

        public ActionRemoveShapedRecipes(IIngredient output, IIngredient[][] ingredients) {
            this.output = output;
            this.ingredients = ingredients;
        }

        @Override
        public void apply() {
            int ingredientsWidth = 0;
            int ingredientsHeight = 0;
            this.toRemove.clear();
            if (this.ingredients != null) {
                ingredientsHeight = this.ingredients.length;
                for (IIngredient[] ingredient : this.ingredients) {
                    ingredientsWidth = Math.max(ingredientsWidth, ingredient.length);
                }
            }
            block1: for (IRecipe recipe : recipes) {
                ItemStack output = recipe.func_77571_b();
                if (output == null || !this.output.matches(new MCItemStack(output)) || !(recipe instanceof ShapedRecipes) && !(recipe instanceof ShapedOreRecipe)) continue;
                if (this.ingredients != null) {
                    int recipeHeight;
                    boolean ore = recipe instanceof ShapedOreRecipe;
                    ShapedRecipes shapedRecipe = !ore ? (ShapedRecipes)recipe : null;
                    ShapedOreRecipe shapedOreRecipe = ore ? (ShapedOreRecipe)recipe : null;
                    int recipeWidth = ore ? MineTweakerHacks.getShapedOreRecipeWidth(shapedOreRecipe) : shapedRecipe.field_77576_b;
                    int n = recipeHeight = ore ? shapedOreRecipe.func_77570_a() / recipeWidth : shapedRecipe.field_77577_c;
                    if (ingredientsWidth != recipeWidth || ingredientsHeight != recipeHeight) continue;
                    for (int j = 0; j < ingredientsHeight; ++j) {
                        IIngredient[] row = this.ingredients[j];
                        for (int k = 0; k < ingredientsWidth; ++k) {
                            IIngredient ingredient;
                            Object input = (ore ? shapedOreRecipe.getInput() : shapedRecipe.field_77574_d)[j * recipeWidth + k];
                            if (!MCRecipeManager.matches(input, ingredient = k > row.length ? null : row[k])) continue block1;
                        }
                    }
                }
                this.toRemove.add(recipe);
            }
            MineTweakerAPI.logInfo(this.toRemove.size() + " removed");
            super.removeRecipes(this.toRemove);
        }

        @Override
        public boolean canUndo() {
            return !this.toRemove.isEmpty();
        }

        @Override
        public void undo() {
            for (IRecipe recipe : this.toRemove) {
                recipesToAdd.add(new ActionBaseAddRecipe(recipe));
            }
        }

        @Override
        public String describe() {
            if (this.output != null) {
                return "Removing Shaped recipes for " + this.output.toString();
            }
            return "Trying to remove recipes for invalid output";
        }

        @Override
        public String describeUndo() {
            return "Trying to restore " + this.toRemove.size() + " shaped recipes.";
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    public static class ActionRemoveShapelessRecipes
    extends ActionBaseRemoveRecipes
    implements IUndoableAction {
        final IIngredient output;
        final IIngredient[] ingredients;
        final boolean wildcard;
        Set<IRecipe> toRemove = new HashSet<IRecipe>();

        public ActionRemoveShapelessRecipes(IIngredient output, IIngredient[] ingredients, boolean wildcard) {
            this.output = output;
            this.ingredients = ingredients;
            this.wildcard = wildcard;
        }

        @Override
        public void apply() {
            this.toRemove.clear();
            block0: for (IRecipe recipe : recipes) {
                if (recipe.func_77571_b() == null || !this.output.matches(new MCItemStack(recipe.func_77571_b())) || recipe instanceof ShapedRecipes || !(recipe instanceof ShapelessRecipes) && !(recipe instanceof ShapelessOreRecipe)) continue;
                if (this.ingredients != null) {
                    ShapelessRecipes srecipe;
                    if (recipe instanceof ShapelessRecipes) {
                        srecipe = (ShapelessRecipes)recipe;
                        if (this.ingredients.length > srecipe.func_77570_a() || !this.wildcard && this.ingredients.length < srecipe.func_77570_a()) continue;
                        block1: for (IIngredient ingredient : this.ingredients) {
                            for (int k = 0; k < srecipe.func_77570_a(); ++k) {
                                if (MCRecipeManager.matches(srecipe.field_77579_b.get(k), ingredient)) continue block1;
                            }
                            continue block0;
                        }
                    } else if (recipe instanceof ShapelessOreRecipe) {
                        srecipe = (ShapelessOreRecipe)recipe;
                        ArrayList inputs = srecipe.getInput();
                        if (inputs.size() < this.ingredients.length || !this.wildcard && inputs.size() > this.ingredients.length) continue;
                        block3: for (IIngredient ingredient : this.ingredients) {
                            for (int k = 0; k < srecipe.func_77570_a(); ++k) {
                                if (MCRecipeManager.matches(inputs.get(k), ingredient)) continue block3;
                            }
                            continue block0;
                        }
                    }
                }
                this.toRemove.add(recipe);
            }
            MineTweakerAPI.logInfo("Removing " + this.toRemove.size() + " Shapeless recipes.");
            super.removeRecipes(this.toRemove);
        }

        @Override
        public boolean canUndo() {
            return !this.toRemove.isEmpty();
        }

        @Override
        public void undo() {
            for (IRecipe recipe : this.toRemove) {
                recipesToAdd.add(new ActionBaseAddRecipe(recipe));
            }
        }

        @Override
        public String describe() {
            if (this.output != null) {
                return "Removing Shapeless recipes for " + this.output.toString();
            }
            return "Trying to remove recipes for invalid output";
        }

        @Override
        public String describeUndo() {
            return "Trying to restore " + this.toRemove.size() + " shapeless recipes.";
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    public static class ActionRemoveRecipesNoIngredients
    extends ActionBaseRemoveRecipes
    implements IUndoableAction {
        private final List<Pair<IIngredient, Boolean>> outputs = new ArrayList<Pair<IIngredient, Boolean>>();
        private final Set<IRecipe> toRemove = new HashSet<IRecipe>();

        public void addOutput(IIngredient output, @Optional boolean nbtMatch) {
            this.outputs.add((Pair<IIngredient, Boolean>)Pair.of((Object)output, (Object)nbtMatch));
        }

        public void clearOutputs() {
            this.outputs.clear();
        }

        @Override
        public void apply() {
            this.toRemove.clear();
            for (IRecipe recipe : recipes) {
                IItemStack stack;
                ItemStack recipeOutput = recipe.func_77571_b();
                if (recipeOutput == null || !this.matches(stack = MineTweakerMC.getIItemStack(recipeOutput))) continue;
                this.toRemove.add(recipe);
            }
            super.removeRecipes(this.toRemove);
        }

        @Override
        public boolean canUndo() {
            return !this.toRemove.isEmpty();
        }

        @Override
        public void undo() {
            for (IRecipe recipe : this.toRemove) {
                recipesToAdd.add(new ActionBaseAddRecipe(recipe));
            }
        }

        @Override
        public String describe() {
            return "Removing recipes for various outputs";
        }

        @Override
        public String describeUndo() {
            return "Trying to restore " + this.toRemove.size() + " recipes.";
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }

        private boolean matches(IItemStack stack) {
            for (Pair<IIngredient, Boolean> entry : this.outputs) {
                IIngredient output = (IIngredient)entry.getKey();
                Boolean nbtMatch = (Boolean)entry.getValue();
                if (!(nbtMatch != false ? output.matchesExact(stack) : output.matches(stack))) continue;
                return true;
            }
            return false;
        }
    }

    public static abstract class ActionBaseRemoveRecipes
    implements IUndoableAction {
        public void removeRecipes(Set<IRecipe> toRemove) {
            recipes.removeIf(toRemove::contains);
        }
    }
}

