/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core.integrations.pack.multimc;

import com.gitlab.cdagaming.craftpresence.core.integrations.pack.Pack;
import io.github.cdagaming.unicore.utils.OSUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

public class MultiMCUtils
extends Pack {
    public MultiMCUtils(Supplier<Boolean> isEnabled) {
        super(isEnabled);
    }

    public MultiMCUtils(boolean isEnabled) {
        super(isEnabled);
    }

    public MultiMCUtils() {
    }

    @Override
    public boolean load() {
        return this.findWithSystem() || this.findWithLegacy();
    }

    @Override
    public void setPackIcon(String packIcon) {
        super.setPackIcon(this.parseIcon(packIcon));
    }

    private String parseIcon(String original) {
        String defaultIcon = this.getDefaultIcon();
        if (StringUtils.isNullOrEmpty((String)original)) {
            return defaultIcon;
        }
        return !original.equals("default") ? original : defaultIcon;
    }

    private String getDefaultIcon() {
        if (Objects.equals(this.getPackType(), "prism")) {
            return "prismlauncher";
        }
        return "infinity";
    }

    private boolean findWithSystem() {
        try {
            Properties props = MultiMCUtils.jvmdg$inlined$getProperties();
            if (props.containsKey("org.prismlauncher.instance.name")) {
                this.setPackData(MultiMCUtils.jvmdg$inlined$getProperty("org.prismlauncher.instance.name"), MultiMCUtils.jvmdg$inlined$getProperty("org.prismlauncher.instance.icon.id"));
                this.setPackType("prism");
            } else {
                this.setPackData(MultiMCUtils.jvmdg$inlined$getProperty("multimc.instance.title"), MultiMCUtils.jvmdg$inlined$getProperty("multimc.instance.icon"));
                this.setPackType("multimc");
            }
        }
        catch (Exception ex) {
            this.printException(ex);
        }
        return this.hasPackName() && this.hasPackIcon();
    }

    private boolean findWithLegacy() {
        Path instanceFile = Paths.get(MultiMCUtils.jvmdowngrader$concat$findWithLegacy$1(new File(OSUtils.USER_DIR).getParent(), File.separator), new String[0]);
        if (Files.exists(instanceFile, new LinkOption[0])) {
            try (InputStream inputStream = Files.newInputStream(instanceFile, new OpenOption[0]);){
                Properties configFile = new Properties();
                configFile.load(inputStream);
                this.setPackData(configFile.getProperty("name"), configFile.getProperty("iconKey"));
                this.setPackType(this.getLauncherType());
            }
            catch (Exception ex) {
                this.printException(ex);
            }
        }
        return this.hasPackName() && this.hasPackIcon();
    }

    private String getLauncherType() {
        try {
            File prismLocation = new File(MultiMCUtils.jvmdowngrader$concat$getLauncherType$1(String.valueOf(new File(OSUtils.USER_DIR).getParentFile().getParentFile().getParentFile()), File.separator));
            if (prismLocation.exists()) {
                return "prism";
            }
        }
        catch (Exception ex) {
            this.printException(ex);
        }
        return "multimc";
    }

    private static String jvmdowngrader$concat$findWithLegacy$1(String string, String string2) {
        return string + string2 + "instance.cfg";
    }

    private static String jvmdowngrader$concat$getLauncherType$1(String string, String string2) {
        return string + string2 + "prismlauncher.cfg";
    }

    @Stub(ref=@Ref(value="java/lang/System"))
    private static Properties jvmdg$inlined$getProperties() {
        Properties props = System.getProperties();
        if (!props.containsKey("native.encoding")) {
            props.put("native.encoding", props.getProperty("file.encoding"));
        }
        return props;
    }

    @Stub(ref=@Ref(value="java/lang/System"))
    private static String jvmdg$inlined$getProperty(String key) {
        if (key.equals("native.encoding")) {
            String prop = System.getProperty(key);
            if (prop != null) {
                return prop;
            }
            return System.getProperty("file.encoding");
        }
        return System.getProperty(key);
    }
}

