/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.world;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.core.config.Config;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.impl.ExtendedModule;
import io.github.cdagaming.unicore.utils.FileUtils;
import io.github.cdagaming.unicore.utils.MappingUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.biome.BiomeGenBase;
import unilib.external.io.github.classgraph.ClassInfo;

public class BiomeUtils
implements ExtendedModule {
    public List<String> BIOME_NAMES = StringUtils.newArrayList();
    public List<String> DEFAULT_NAMES = StringUtils.newArrayList();
    private boolean enabled = false;
    private boolean isInUse = false;
    private boolean hasScannedConfig = false;
    private boolean hasScannedInternals = false;
    private boolean hasInitialized = false;
    private String RAW_BIOME_NAME;
    private String CURRENT_BIOME_NAME;
    private String RAW_BIOME_IDENTIFIER;
    private String CURRENT_BIOME_IDENTIFIER;
    private BiomeGenBase CURRENT_BIOME;

    @Override
    public void clearFieldData() {
        this.DEFAULT_NAMES.clear();
        this.BIOME_NAMES.clear();
    }

    @Override
    public void clearAttributes() {
        this.CURRENT_BIOME = null;
        this.RAW_BIOME_NAME = null;
        this.RAW_BIOME_IDENTIFIER = null;
        this.CURRENT_BIOME_NAME = null;
        this.CURRENT_BIOME_IDENTIFIER = null;
        CraftPresence.CLIENT.removeArguments("biome", "data.biome");
        CraftPresence.CLIENT.clearForcedData("biome");
        this.hasInitialized = false;
    }

    @Override
    public void updateData() {
        BiomeGenBase newBiome = CraftPresence.world.func_72807_a((int)CraftPresence.player.field_70165_t, (int)CraftPresence.player.field_70161_v);
        String newBiomeName = newBiome.field_76791_y;
        String newBiomeIdentifier = StringUtils.getOrDefault((String)newBiomeName, (String)MappingUtils.getClassName((Object)newBiome));
        if (!(newBiome.equals(this.CURRENT_BIOME) && newBiomeName.equals(this.RAW_BIOME_NAME) && newBiomeIdentifier.equals(this.RAW_BIOME_IDENTIFIER))) {
            this.CURRENT_BIOME = newBiome;
            this.RAW_BIOME_NAME = StringUtils.getOrDefault((String)newBiomeName, (String)newBiomeIdentifier);
            this.RAW_BIOME_IDENTIFIER = newBiomeIdentifier;
            this.CURRENT_BIOME_NAME = StringUtils.formatIdentifier((String)this.RAW_BIOME_NAME, (boolean)false, (!CraftPresence.CONFIG.advancedSettings.formatWords ? 1 : 0) != 0);
            this.CURRENT_BIOME_IDENTIFIER = StringUtils.formatIdentifier((String)this.RAW_BIOME_IDENTIFIER, (boolean)true, (!CraftPresence.CONFIG.advancedSettings.formatWords ? 1 : 0) != 0);
            if (!this.DEFAULT_NAMES.contains(this.CURRENT_BIOME_IDENTIFIER)) {
                this.DEFAULT_NAMES.add(this.CURRENT_BIOME_IDENTIFIER);
            }
            if (!this.BIOME_NAMES.contains(this.CURRENT_BIOME_IDENTIFIER)) {
                this.BIOME_NAMES.add(this.CURRENT_BIOME_IDENTIFIER);
            }
            if (!this.hasInitialized) {
                this.initPresence();
                this.hasInitialized = true;
            }
            this.updatePresence();
        }
    }

    @Override
    public void initPresence() {
        this.syncArgument("biome.default.icon", () -> CraftPresence.CONFIG.biomeSettings.fallbackBiomeIcon);
        this.syncArgument("data.biome.instance", () -> this.CURRENT_BIOME, true);
        this.syncArgument("data.biome.class", () -> this.CURRENT_BIOME.getClass(), true);
        this.syncArgument("data.biome.name", () -> this.RAW_BIOME_NAME, true);
        this.syncArgument("data.biome.identifier", () -> this.RAW_BIOME_IDENTIFIER, true);
        this.syncArgument("biome.identifier", () -> this.CURRENT_BIOME_IDENTIFIER, true);
        this.syncArgument("biome.name", () -> this.CURRENT_BIOME_NAME, true);
        this.syncArgument("biome.message", () -> {
            ModuleData defaultData = this.getDefaultData();
            ModuleData currentData = this.getData(this.CURRENT_BIOME_IDENTIFIER);
            String defaultMessage = Config.isValidProperty(defaultData, "textOverride") ? defaultData.getTextOverride() : "";
            return this.getResult(Config.isValidProperty(currentData, "textOverride") ? currentData.getTextOverride() : defaultMessage, this.CURRENT_BIOME_IDENTIFIER);
        });
        this.syncArgument("biome.icon", () -> {
            ModuleData defaultData = this.getDefaultData();
            ModuleData currentData = this.getData(this.CURRENT_BIOME_IDENTIFIER);
            String defaultIcon = Config.isValidProperty(defaultData, "iconOverride") ? defaultData.getIconOverride() : this.CURRENT_BIOME_IDENTIFIER;
            String currentIcon = Config.isValidProperty(currentData, "iconOverride") ? currentData.getIconOverride() : defaultIcon;
            return this.getResult(CraftPresence.CLIENT.imageOf(true, currentIcon, CraftPresence.CONFIG.biomeSettings.fallbackBiomeIcon, this.CURRENT_BIOME_IDENTIFIER), new String[0]);
        });
        CraftPresence.CLIENT.addForcedData("biome", () -> this.isInUse() ? this.getPresenceData(this.CURRENT_BIOME_IDENTIFIER) : null);
        CraftPresence.CLIENT.syncTimestamp("data.biome.time");
    }

    @Override
    public void updatePresence() {
    }

    private List<BiomeGenBase> getBiomeTypes() {
        List biomeTypes = StringUtils.newArrayList();
        if (BiomeGenBase.func_150565_n() != null) {
            for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
                if (biome == null || biomeTypes.contains(biome)) continue;
                biomeTypes.add(biome);
            }
        }
        if (biomeTypes.isEmpty() && FileUtils.isClassGraphEnabled()) {
            for (ClassInfo classInfo : FileUtils.getClassNamesMatchingSuperType(BiomeGenBase.class, (String[])new String[0]).values()) {
                if (classInfo == null) continue;
                try {
                    BiomeGenBase biomeObj;
                    Class classObj = FileUtils.loadClass((String[])new String[]{classInfo.getName()});
                    if (classObj == null || biomeTypes.contains(biomeObj = (BiomeGenBase)classObj.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]))) continue;
                    biomeTypes.add(biomeObj);
                }
                catch (Throwable ex) {
                    this.printException(ex);
                }
            }
        }
        return biomeTypes;
    }

    @Override
    public void getInternalData() {
        for (BiomeGenBase biome : this.getBiomeTypes()) {
            if (biome == null) continue;
            String biomeName = StringUtils.getOrDefault((String)biome.field_76791_y, (String)MappingUtils.getClassName((Object)biome));
            String name = StringUtils.formatIdentifier((String)biomeName, (boolean)true, (!CraftPresence.CONFIG.advancedSettings.formatWords ? 1 : 0) != 0);
            if (!this.DEFAULT_NAMES.contains(name)) {
                this.DEFAULT_NAMES.add(name);
            }
            if (this.BIOME_NAMES.contains(name)) continue;
            this.BIOME_NAMES.add(name);
        }
    }

    @Override
    public void getConfigData() {
        for (String biomeEntry : CraftPresence.CONFIG.biomeSettings.biomeData.keySet()) {
            String name;
            if (StringUtils.isNullOrEmpty((String)biomeEntry) || this.BIOME_NAMES.contains(name = StringUtils.formatIdentifier((String)biomeEntry, (boolean)true, (!CraftPresence.CONFIG.advancedSettings.formatWords ? 1 : 0) != 0))) continue;
            this.BIOME_NAMES.add(name);
        }
    }

    @Override
    public void syncArgument(String argumentName, Supplier<Boolean> condition, Supplier<Object> event, boolean plain) {
        CraftPresence.CLIENT.syncArgument(argumentName, this.getModuleFunction(condition, event), plain);
    }

    @Override
    public ModuleData getData(String key) {
        return CraftPresence.CONFIG.biomeSettings.biomeData.get(key);
    }

    @Override
    public String getOverrideText(ModuleData data) {
        return CraftPresence.CLIENT.getOverrideText(this.getPresenceData(data));
    }

    @Override
    public boolean canFetchInternals() {
        return MappingUtils.areMappingsLoaded() && (!FileUtils.isClassGraphEnabled() || FileUtils.canScanClasses());
    }

    @Override
    public boolean hasScannedInternals() {
        return this.hasScannedInternals;
    }

    @Override
    public void setScannedInternals(boolean state) {
        this.hasScannedInternals = state;
    }

    @Override
    public boolean canFetchConfig() {
        return CraftPresence.CONFIG != null;
    }

    @Override
    public boolean hasScannedConfig() {
        return this.hasScannedConfig;
    }

    @Override
    public void setScannedConfig(boolean state) {
        this.hasScannedConfig = state;
    }

    @Override
    public boolean canBeEnabled() {
        return !CraftPresence.CONFIG.hasChanged() ? CraftPresence.CONFIG.generalSettings.detectBiomeData : this.isEnabled();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean canBeUsed() {
        return CraftPresence.player != null;
    }

    @Override
    public boolean isInUse() {
        return this.isInUse;
    }

    @Override
    public void setInUse(boolean state) {
        this.isInUse = state;
    }
}

