/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.utils.ModUpdaterUtils;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ScrollPane;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.TextDisplayWidget;
import io.github.cdagaming.unicore.utils.StringUtils;
import io.github.cdagaming.unicore.utils.UrlUtils;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;

public class UpdateInfoGui
extends ExtendedScreen {
    private final ModUpdaterUtils modUpdater;
    private TextDisplayWidget infoPane;
    private ExtendedButtonControl downloadButton;
    private ExtendedButtonControl checkButton;

    public UpdateInfoGui(GuiScreen parentScreen, ModUpdaterUtils modUpdater) {
        super(parentScreen);
        this.modUpdater = modUpdater;
    }

    @Override
    public void initializeUi() {
        this.checkButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getScreenHeight() - 26, 180, 20, "gui.config.message.button.check_for_updates", () -> {
            this.resetNotes();
            this.modUpdater.checkForUpdates(this::updateNotes);
        }, new String[0]));
        this.addControl(new ExtendedButtonControl(6, 6, 20, 20, "?", null, () -> {
            String mainLine = Constants.TRANSLATOR.translate("gui.config.comment.title", "v2.3.9", CraftPresence.CONFIG._schemaVersion);
            String subLine = Constants.TRANSLATOR.translate("gui.config.comment.title.changes", ModUtils.MCVersion);
            this.drawMultiLineString(StringUtils.splitTextByNewLine(mainLine + '\n' + subLine));
        }, new String[0]));
        this.addControl(new ExtendedButtonControl(6, this.getScreenHeight() - 26, 95, 20, "gui.config.message.button.back", () -> this.openScreen(this.parentScreen), new String[0]));
        this.downloadButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() - 101, this.getScreenHeight() - 26, 95, 20, "gui.config.message.button.download", () -> UrlUtils.openUrl(this.modUpdater.downloadUrl), new String[0]));
        ScrollPane childFrame = this.addControl(new ScrollPane(0, 32, this.getScreenWidth(), this.getScreenHeight() - 32));
        this.infoPane = childFrame.addWidget(new TextDisplayWidget((ExtendedScreen)childFrame, 0, 0, this.getScreenWidth()));
        this.updateNotes();
        super.initializeUi();
    }

    @Override
    public void preRender() {
        this.downloadButton.setControlEnabled(this.modUpdater.currentState == ModUpdaterUtils.UpdateState.OUTDATED || this.modUpdater.currentState == ModUpdaterUtils.UpdateState.BETA_OUTDATED);
        this.checkButton.setControlEnabled(this.modUpdater.currentState != ModUpdaterUtils.UpdateState.PENDING);
        super.preRender();
    }

    @Override
    public void renderExtra() {
        String mainTitle = Constants.TRANSLATOR.translate("gui.config.title", new Object[0]);
        String subTitle = Constants.TRANSLATOR.translate("gui.config.title.changes", this.modUpdater.currentState.getDisplayName());
        this.renderScrollingString(mainTitle, 30, 2, this.getScreenWidth() - 30, 16, 0xFFFFFF);
        this.renderScrollingString(subTitle, 30, 16, this.getScreenWidth() - 30, 30, 0xFFFFFF);
        super.renderExtra();
    }

    private void resetNotes() {
        String notice = Constants.TRANSLATOR.translate("gui.config.message.changelog", new Object[0]) + '\n' + "  N/A";
        this.infoPane.setMessage(notice);
    }

    private void updateNotes() {
        if (!this.modUpdater.changelogData.isEmpty()) {
            StringBuilder notice = new StringBuilder();
            notice.append(Constants.TRANSLATOR.translate("gui.config.message.changelog", new Object[0]));
            for (Map.Entry<String, String> entry : this.modUpdater.changelogData.entrySet()) {
                notice.append('\n').append("  ").append(entry.getKey()).append(":").append('\n').append(entry.getValue()).append('\n').append(' ');
            }
            this.infoPane.setMessage(notice.toString());
        } else {
            this.resetNotes();
        }
    }
}

