/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.config.Config;
import forge.com.gitlab.cdagaming.craftpresence.config.category.Status;
import forge.com.gitlab.cdagaming.craftpresence.config.gui.PresenceEditorGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui;
import io.github.cdagaming.unicore.impl.HashMapBuilder;
import io.github.cdagaming.unicore.impl.Pair;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;

public class StatusMessagesGui
extends ConfigurationGui<Status> {
    private final Status INSTANCE;
    private final Status DEFAULTS;
    private final Map<String, Pair<String, Runnable>> eventMappings = new HashMapBuilder<String, Pair<String, Runnable>>().put("gui.config.name.status_messages.main_menu_message", new Pair<String, Runnable>("mainMenuData", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.status_messages.main_menu_message", CraftPresence.CLIENT.generateArgumentMessage("general.")))))).put("gui.config.name.status_messages.loading_message", new Pair<String, Runnable>("loadingData", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.status_messages.loading_message", CraftPresence.CLIENT.generateArgumentMessage("general.")))))).put("gui.config.name.status_messages.lan_message", new Pair<String, Runnable>("lanData", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.status_messages.lan_message", CraftPresence.CLIENT.generateArgumentMessage("server.", "world.", "player.")))))).put("gui.config.name.status_messages.single_player_message", new Pair<String, Runnable>("singleplayerData", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.status_messages.single_player_message", CraftPresence.CLIENT.generateArgumentMessage("server.", "world.", "player.")))))).build();

    StatusMessagesGui(GuiScreen parentScreen) {
        super(parentScreen, "gui.config.title", "gui.config.title.status_messages");
        this.DEFAULTS = this.getCurrentData().getDefaults();
        this.INSTANCE = this.getCurrentData().copy();
    }

    @Override
    protected void appendControls() {
        super.appendControls();
        int calc1 = this.getScreenWidth() / 2 - 183;
        int calc2 = this.getScreenWidth() / 2 + 3;
        int midCalc = this.getScreenWidth() / 2 - 90;
        int buttonRow = 0;
        int index = 1;
        for (Map.Entry<String, Pair<String, Runnable>> entry : this.eventMappings.entrySet()) {
            int startX;
            boolean isEven = index % 2 == 0;
            int n = startX = isEven ? calc2 : calc1;
            if (index >= this.eventMappings.size() && startX == calc1) {
                startX = midCalc;
            }
            this.childFrame.addControl(new ExtendedButtonControl(startX, this.getButtonY(buttonRow), 180, 20, entry.getKey(), () -> this.openScreen(new DynamicEditorGui(this.currentScreen, (String)((Pair)entry.getValue()).getFirst(), (attributeName, screenInstance) -> {
                screenInstance.defaultData = (ModuleData)this.getInstanceData().getDefaults().getProperty((String)attributeName);
                screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
                screenInstance.primaryMessage = screenInstance.originalPrimaryMessage;
                screenInstance.resetText = "gui.config.message.button.reset_to_default";
            }, (attributeName, screenInstance) -> {
                screenInstance.defaultData = (ModuleData)this.getInstanceData().getDefaults().getProperty((String)attributeName);
                screenInstance.currentData = (ModuleData)this.getInstanceData().getProperty((String)attributeName);
                screenInstance.isPreliminaryData = screenInstance.currentData == null;
                screenInstance.mainTitle = Constants.TRANSLATOR.translate("gui.config.title.status.edit_specific_status", attributeName);
                screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
                screenInstance.primaryMessage = Config.getProperty(screenInstance.currentData, "textOverride") != null ? screenInstance.currentData.getTextOverride() : screenInstance.originalPrimaryMessage;
                screenInstance.resetText = "gui.config.message.button.reset_to_default";
            }, (screenInstance, attributeName, inputText) -> {
                screenInstance.currentData.setTextOverride((String)inputText);
                this.getInstanceData().setProperty((String)attributeName, screenInstance.currentData);
            }, (screenInstance, attributeName, inputText) -> this.getInstanceData().resetProperty((String)attributeName), (attributeName, screenInstance, isPresenceButton) -> {
                if (isPresenceButton.booleanValue()) {
                    PresenceData defaultPresenceData = Config.getProperty(screenInstance.defaultData, "data") != null ? screenInstance.defaultData.getData() : new PresenceData();
                    PresenceData currentPresenceData = Config.getProperty(screenInstance.currentData, "data") != null ? screenInstance.currentData.getData() : defaultPresenceData;
                    this.openScreen(new PresenceEditorGui((GuiScreen)screenInstance, currentPresenceData, defaultPresenceData, output -> screenInstance.currentData.setData((PresenceData)output)));
                } else {
                    screenInstance.currentData.setIconOverride((String)attributeName);
                }
            })), entry.getValue().getSecond(), new String[0]));
            if (isEven) {
                ++buttonRow;
            }
            ++index;
        }
    }

    @Override
    protected boolean allowedToReset() {
        return true;
    }

    @Override
    protected Status getInstanceData() {
        return this.INSTANCE;
    }

    @Override
    protected Status getCurrentData() {
        return CraftPresence.CONFIG.statusMessages;
    }

    @Override
    protected Status getDefaultData() {
        return this.DEFAULTS;
    }
}

