/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.config.Config;
import forge.com.gitlab.cdagaming.craftpresence.config.category.Dimension;
import forge.com.gitlab.cdagaming.craftpresence.config.gui.PresenceEditorGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.SelectorGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.TextWidget;
import io.github.cdagaming.unicore.utils.StringUtils;
import net.minecraft.client.gui.GuiScreen;

public class DimensionSettingsGui
extends ConfigurationGui<Dimension> {
    private final Dimension INSTANCE;
    private final Dimension DEFAULTS = this.getCurrentData().getDefaults();
    private ExtendedButtonControl dimensionMessagesButton;
    private TextWidget defaultMessage;
    private TextWidget defaultIcon;

    DimensionSettingsGui(GuiScreen parentScreen) {
        super(parentScreen, "gui.config.title", "gui.config.title.dimension_messages");
        this.INSTANCE = this.getCurrentData().copy();
    }

    @Override
    protected void appendControls() {
        super.appendControls();
        ModuleData defaultData = this.getInstanceData().dimensionData.get("default");
        String defaultDimensionMessage = Config.getProperty(defaultData, "textOverride") != null ? defaultData.getTextOverride() : "";
        this.defaultMessage = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(0), 180, 20, () -> {
            ModuleData defaultDimensionData = this.getInstanceData().dimensionData.getOrDefault("default", new ModuleData());
            defaultDimensionData.setTextOverride(this.defaultMessage.getControlMessage());
            this.getInstanceData().dimensionData.put("default", defaultDimensionData);
        }, "gui.config.message.default.dimension", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.dimension_messages.dimension_messages", CraftPresence.CLIENT.generateArgumentMessage("dimension."))))));
        this.defaultMessage.setControlMessage(defaultDimensionMessage);
        this.defaultIcon = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(1), 147, 20, () -> {
            this.getInstanceData().fallbackDimensionIcon = this.defaultIcon.getControlMessage();
        }, "gui.config.name.dimension_messages.dimension_icon", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.dimension_messages.dimension_icon", new Object[0])))));
        this.addIconSelector(this.childFrame, () -> this.defaultIcon, (attributeName, currentValue) -> {
            this.getInstanceData().fallbackDimensionIcon = currentValue;
        });
        this.defaultIcon.setControlMessage(this.getInstanceData().fallbackDimensionIcon);
        this.dimensionMessagesButton = this.childFrame.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getButtonY(2), 180, 20, "gui.config.name.dimension_messages.dimension_messages", () -> this.openScreen(new SelectorGui(this.currentScreen, Constants.TRANSLATOR.translate("gui.config.title.selector.dimension", new Object[0]), CraftPresence.DIMENSIONS.DIMENSION_NAMES, null, null, true, true, ScrollableListControl.RenderType.None, (attributeName, currentValue) -> {
            ModuleData defaultDimensionData = this.getInstanceData().dimensionData.get("default");
            ModuleData currentDimensionData = this.getInstanceData().dimensionData.get(attributeName);
            String defaultMessage = Config.getProperty(defaultDimensionData, "textOverride") != null ? defaultDimensionData.getTextOverride() : "";
            String currentMessage = Config.getProperty(currentDimensionData, "textOverride") != null ? currentDimensionData.getTextOverride() : "";
            ModuleData newData = new ModuleData();
            if (StringUtils.isNullOrEmpty(currentMessage) || currentMessage.equals(defaultMessage)) {
                newData.setTextOverride(defaultMessage);
            }
            newData.setIconOverride((String)currentValue);
            this.getInstanceData().dimensionData.put((String)attributeName, newData);
        }, (currentValue, parentScreen) -> this.openScreen(new DynamicEditorGui((GuiScreen)parentScreen, (String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.getInstanceData().dimensionData.get("default");
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage;
        }, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.getInstanceData().dimensionData.get("default");
            screenInstance.currentData = this.getInstanceData().dimensionData.get(attributeName);
            screenInstance.isPreliminaryData = screenInstance.currentData == null;
            screenInstance.mainTitle = Constants.TRANSLATOR.translate("gui.config.title.dimension.edit_specific_dimension", attributeName);
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = Config.getProperty(screenInstance.currentData, "textOverride") != null ? screenInstance.currentData.getTextOverride() : screenInstance.originalPrimaryMessage;
        }, (screenInstance, attributeName, inputText) -> {
            screenInstance.currentData.setTextOverride((String)inputText);
            this.getInstanceData().dimensionData.put((String)attributeName, screenInstance.currentData);
            if (!CraftPresence.DIMENSIONS.DIMENSION_NAMES.contains(attributeName)) {
                CraftPresence.DIMENSIONS.DIMENSION_NAMES.add((String)attributeName);
            }
        }, (screenInstance, attributeName, inputText) -> {
            this.getInstanceData().dimensionData.remove(attributeName);
            if (!CraftPresence.DIMENSIONS.DEFAULT_NAMES.contains(attributeName)) {
                CraftPresence.DIMENSIONS.DIMENSION_NAMES.remove(attributeName);
            }
        }, (attributeName, screenInstance, isPresenceButton) -> {
            if (isPresenceButton.booleanValue()) {
                PresenceData defaultPresenceData = Config.getProperty(screenInstance.defaultData, "data") != null ? screenInstance.defaultData.getData() : new PresenceData();
                PresenceData currentPresenceData = Config.getProperty(screenInstance.currentData, "data") != null ? screenInstance.currentData.getData() : defaultPresenceData;
                this.openScreen(new PresenceEditorGui((GuiScreen)screenInstance, currentPresenceData, defaultPresenceData, output -> screenInstance.currentData.setData((PresenceData)output)));
            } else {
                screenInstance.currentData.setIconOverride((String)attributeName);
            }
        }, (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.dimension_messages.dimension_messages", CraftPresence.CLIENT.generateArgumentMessage("dimension.")))))))), () -> {
            if (!this.dimensionMessagesButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.hover.access", Constants.TRANSLATOR.translate("gui.config.name.general.detect_dimension_data", new Object[0]))));
            } else {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.dimension_messages.dimension_messages", CraftPresence.CLIENT.generateArgumentMessage("dimension."))));
            }
        }, new String[0]));
        this.proceedButton.setOnHover(() -> {
            if (!this.proceedButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.hover.empty.default", new Object[0])));
            }
        });
    }

    @Override
    protected boolean allowedToReset() {
        return true;
    }

    @Override
    protected void syncRenderStates() {
        super.syncRenderStates();
        this.proceedButton.setControlEnabled(!StringUtils.isNullOrEmpty(this.defaultMessage.getControlMessage()));
        this.dimensionMessagesButton.setControlEnabled(CraftPresence.DIMENSIONS.enabled);
    }

    @Override
    protected Dimension getInstanceData() {
        return this.INSTANCE;
    }

    @Override
    protected Dimension getCurrentData() {
        return CraftPresence.CONFIG.dimensionSettings;
    }

    @Override
    protected Dimension getDefaultData() {
        return this.DEFAULTS;
    }
}

