/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.entity;

import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.impl.Module;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.config.Config;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_100;
import net.minecraft.class_1150;
import net.minecraft.class_482;
import net.minecraft.class_864;
import net.minecraft.class_867;

public class EntityUtils
implements Module {
    public boolean enabled = false;
    public List<String> ENTITY_NAMES = StringUtils.newArrayList();
    public List<String> DEFAULT_NAMES = StringUtils.newArrayList();
    public Map<String, String> PLAYER_BINDINGS = StringUtils.newHashMap();
    private boolean isInUse = false;
    private boolean hasScanned = false;
    private String CURRENT_TARGET_NAME;
    private String CURRENT_RIDING_NAME;
    private class_864 CURRENT_TARGET;
    private class_864 CURRENT_RIDING;

    public static String getName(class_864 entity, boolean stripFormatting) {
        String result = "";
        if (entity != null) {
            result = StringUtils.getOrDefault(entity.method_6344().method_7472(), entity.method_2518());
        }
        if (stripFormatting) {
            result = StringUtils.stripAllFormatting(result);
        }
        return result;
    }

    public static String getName(class_864 entity) {
        return EntityUtils.getName(entity, true);
    }

    public static String getWeather(class_1150 worldObj) {
        String name = "clear";
        if (worldObj != null) {
            class_100 info = worldObj.method_3588();
            name = info.method_229() ? "thunder" : (info.method_231() ? "rain" : "clear");
        }
        return name;
    }

    public static String getWeather(class_864 entity) {
        return EntityUtils.getWeather(entity != null ? entity.field_3248 : null);
    }

    @Override
    public void emptyData() {
        this.hasScanned = false;
        this.DEFAULT_NAMES.clear();
        this.ENTITY_NAMES.clear();
        this.PLAYER_BINDINGS.clear();
        this.clearClientData();
    }

    @Override
    public void clearClientData() {
        this.CURRENT_TARGET = null;
        this.CURRENT_RIDING = null;
        this.CURRENT_TARGET_NAME = null;
        this.CURRENT_RIDING_NAME = null;
        this.setInUse(false);
        CraftPresence.CLIENT.removeArguments("entity", "data.entity");
        CraftPresence.CLIENT.clearOverride("entity.target.message", "entity.target.icon", "entity.riding.message", "entity.riding.icon");
    }

    @Override
    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.advancedSettings.enablePerEntity : this.enabled;
        boolean bl = needsUpdate = this.enabled && !this.hasScanned && this.canFetchData();
        if (needsUpdate) {
            this.scanForData();
            this.hasScanned = true;
        }
        if (this.enabled) {
            if (CraftPresence.player != null) {
                this.setInUse(true);
                this.updateData();
            } else if (this.isInUse()) {
                this.clearClientData();
            }
        } else if (this.isInUse()) {
            this.emptyData();
        }
    }

    @Override
    public void updateData() {
        boolean hasRidingChanged;
        class_864 NEW_CURRENT_TARGET = CraftPresence.instance.field_3822 != null && CraftPresence.instance.field_3822.field_601 != null ? CraftPresence.instance.field_3822.field_601 : null;
        class_864 NEW_CURRENT_RIDING = CraftPresence.player.field_3247;
        boolean hasTargetChanged = !Objects.equals(NEW_CURRENT_TARGET, this.CURRENT_TARGET);
        boolean bl = hasRidingChanged = !Objects.equals(NEW_CURRENT_RIDING, this.CURRENT_RIDING);
        if (hasTargetChanged) {
            this.CURRENT_TARGET = NEW_CURRENT_TARGET;
            this.CURRENT_TARGET_NAME = EntityUtils.getName(this.CURRENT_TARGET);
            if (this.CURRENT_TARGET != null) {
                CraftPresence.CLIENT.syncTimestamp("data.entity.target.time");
                if (!this.DEFAULT_NAMES.contains(this.CURRENT_TARGET_NAME)) {
                    this.DEFAULT_NAMES.add(this.CURRENT_TARGET_NAME);
                }
                if (!this.ENTITY_NAMES.contains(this.CURRENT_TARGET_NAME)) {
                    this.ENTITY_NAMES.add(this.CURRENT_TARGET_NAME);
                }
            }
        }
        if (hasRidingChanged) {
            this.CURRENT_RIDING = NEW_CURRENT_RIDING;
            this.CURRENT_RIDING_NAME = EntityUtils.getName(this.CURRENT_RIDING);
            if (this.CURRENT_RIDING != null) {
                CraftPresence.CLIENT.syncTimestamp("data.entity.riding.time");
                if (!this.DEFAULT_NAMES.contains(this.CURRENT_RIDING_NAME)) {
                    this.DEFAULT_NAMES.add(this.CURRENT_RIDING_NAME);
                }
                if (!this.ENTITY_NAMES.contains(this.CURRENT_RIDING_NAME)) {
                    this.ENTITY_NAMES.add(this.CURRENT_RIDING_NAME);
                }
            }
        }
        if (hasTargetChanged || hasRidingChanged) {
            this.updatePresence();
        }
    }

    @Override
    public void updatePresence() {
        ModuleData defaultTargetData = CraftPresence.CONFIG.advancedSettings.entitySettings.targetData.get("default");
        ModuleData defaultRidingData = CraftPresence.CONFIG.advancedSettings.entitySettings.ridingData.get("default");
        ModuleData currentTargetData = CraftPresence.CONFIG.advancedSettings.entitySettings.targetData.get(this.CURRENT_TARGET_NAME);
        ModuleData currentRidingData = CraftPresence.CONFIG.advancedSettings.entitySettings.targetData.get(this.CURRENT_RIDING_NAME);
        String defaultTargetMessage = Config.isValidProperty(defaultTargetData, "textOverride") ? defaultTargetData.getTextOverride() : "";
        String defaultRidingMessage = Config.isValidProperty(defaultRidingData, "textOverride") ? defaultRidingData.getTextOverride() : "";
        String currentTargetMessage = Config.isValidProperty(currentTargetData, "textOverride") ? currentTargetData.getTextOverride() : defaultTargetMessage;
        String currentRidingMessage = Config.isValidProperty(currentRidingData, "textOverride") ? currentRidingData.getTextOverride() : defaultRidingMessage;
        String currentTargetIcon = Config.isValidProperty(currentTargetData, "iconOverride") ? currentTargetData.getIconOverride() : this.CURRENT_TARGET_NAME;
        String currentRidingIcon = Config.isValidProperty(currentRidingData, "iconOverride") ? currentRidingData.getIconOverride() : this.CURRENT_RIDING_NAME;
        String formattedTargetIcon = CraftPresence.CLIENT.imageOf("entity.target.icon", true, currentTargetIcon, CraftPresence.CONFIG.advancedSettings.entitySettings.fallbackEntityIcon);
        String formattedRidingIcon = CraftPresence.CLIENT.imageOf("entity.riding.icon", true, currentRidingIcon, CraftPresence.CONFIG.advancedSettings.entitySettings.fallbackEntityIcon);
        CraftPresence.CLIENT.syncArgument("entity.default.icon", CraftPresence.CONFIG.advancedSettings.entitySettings.fallbackEntityIcon);
        if (this.CURRENT_TARGET != null) {
            CraftPresence.CLIENT.syncArgument("data.entity.target.instance", this.CURRENT_TARGET);
            CraftPresence.CLIENT.syncArgument("data.entity.target.class", this.CURRENT_TARGET.getClass());
            CraftPresence.CLIENT.syncArgument("entity.target.name", this.CURRENT_TARGET_NAME);
            CraftPresence.CLIENT.syncOverride(currentTargetData != null ? currentTargetData : defaultTargetData, "entity.target.message", "entity.target.icon");
            CraftPresence.CLIENT.syncArgument("entity.target.message", currentTargetMessage);
            CraftPresence.CLIENT.syncArgument("entity.target.icon", formattedTargetIcon);
        } else {
            CraftPresence.CLIENT.removeArguments("entity.target", "data.entity.target");
        }
        if (this.CURRENT_RIDING != null) {
            CraftPresence.CLIENT.syncArgument("data.entity.riding.instance", this.CURRENT_RIDING);
            CraftPresence.CLIENT.syncArgument("data.entity.riding.class", this.CURRENT_RIDING.getClass());
            CraftPresence.CLIENT.syncArgument("entity.riding.name", this.CURRENT_RIDING_NAME);
            CraftPresence.CLIENT.syncOverride(currentRidingData != null ? currentRidingData : defaultRidingData, "entity.riding.message", "entity.riding.icon");
            CraftPresence.CLIENT.syncArgument("entity.riding.message", currentRidingMessage);
            CraftPresence.CLIENT.syncArgument("entity.riding.icon", formattedRidingIcon);
        } else {
            CraftPresence.CLIENT.removeArguments("entity.riding", "data.entity.riding");
        }
    }

    @Override
    public void getAllData() {
        if (!class_867.method_8367().isEmpty()) {
            for (Object entityLocationObj : class_867.method_8367()) {
                String entityLocation = (String)entityLocationObj;
                if (entityLocation == null) continue;
                String entityName = StringUtils.getOrDefault(entityLocation, "generic");
                if (!this.DEFAULT_NAMES.contains(entityName)) {
                    this.DEFAULT_NAMES.add(entityName);
                }
                if (this.ENTITY_NAMES.contains(entityName)) continue;
                this.ENTITY_NAMES.add(entityName);
            }
        }
        if (CraftPresence.SERVER.enabled) {
            for (class_482 playerInfo : CraftPresence.SERVER.currentPlayerList) {
                String uuidString;
                if (playerInfo == null || StringUtils.isNullOrEmpty(uuidString = playerInfo.field_1679)) continue;
                if (!this.ENTITY_NAMES.contains(uuidString)) {
                    this.ENTITY_NAMES.add(uuidString);
                }
                if (this.PLAYER_BINDINGS.containsKey(uuidString)) continue;
                this.PLAYER_BINDINGS.put(uuidString, uuidString);
            }
        }
        for (String entityTargetEntry : CraftPresence.CONFIG.advancedSettings.entitySettings.targetData.keySet()) {
            if (StringUtils.isNullOrEmpty(entityTargetEntry) || this.ENTITY_NAMES.contains(entityTargetEntry)) continue;
            this.ENTITY_NAMES.add(entityTargetEntry);
        }
        for (String entityRidingEntry : CraftPresence.CONFIG.advancedSettings.entitySettings.ridingData.keySet()) {
            if (StringUtils.isNullOrEmpty(entityRidingEntry) || this.ENTITY_NAMES.contains(entityRidingEntry)) continue;
            this.ENTITY_NAMES.add(entityRidingEntry);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean isInUse() {
        return this.isInUse;
    }

    @Override
    public void setInUse(boolean state) {
        this.isInUse = state;
    }
}

