/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.element.ColorData;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.config.category.Accessibility;
import fabric.com.gitlab.cdagaming.craftpresence.config.gui.ColorEditorGui;
import fabric.com.gitlab.cdagaming.craftpresence.utils.KeyUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.CheckBoxControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.impl.ControlsGui;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.impl.SelectorGui;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.TextWidget;
import io.github.cdagaming.unicore.impl.Pair;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.List;
import java.util.Map;
import net.minecraft.class_388;

public class AccessibilitySettingsGui
extends ConfigurationGui<Accessibility> {
    private final Accessibility INSTANCE;
    private final Accessibility DEFAULTS;
    private final Map<String, Pair<ColorData, ColorData>> colorSettings = StringUtils.newHashMap();
    private ExtendedTextControl languageIdText;
    private CheckBoxControl stripTranslationColorsButton;
    private CheckBoxControl stripTranslationFormattingButton;
    private CheckBoxControl stripExtraGuiElementsButton;
    private CheckBoxControl renderTooltipsButton;
    private ExtendedButtonControl controlsButton;

    AccessibilitySettingsGui(class_388 parentScreen) {
        super(parentScreen, "gui.config.title", "gui.config.title.accessibility");
        this.DEFAULTS = this.getCurrentData().getDefaults();
        this.INSTANCE = this.getCurrentData().copy();
    }

    @Override
    protected void appendControls() {
        super.appendControls();
        this.colorSettings.clear();
        this.colorSettings.put("tooltipBackground", new Pair<ColorData, ColorData>(this.getInstanceData().tooltipBackground, this.getDefaultData().tooltipBackground));
        this.colorSettings.put("tooltipBorder", new Pair<ColorData, ColorData>(this.getInstanceData().tooltipBorder, this.getDefaultData().tooltipBorder));
        this.colorSettings.put("guiBackground", new Pair<ColorData, ColorData>(this.getInstanceData().guiBackground, this.getDefaultData().guiBackground));
        this.colorSettings.put("altGuiBackground", new Pair<ColorData, ColorData>(this.getInstanceData().altGuiBackground, this.getDefaultData().altGuiBackground));
        int calc1 = this.getScreenWidth() / 2 - 183;
        int calc2 = this.getScreenWidth() / 2 + 3;
        this.languageIdText = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(0), 180, 20, () -> {
            this.getInstanceData().languageId = this.languageIdText.getControlMessage();
        }, "gui.config.name.accessibility.language_id", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.accessibility.language_id", new Object[0])))));
        this.languageIdText.setControlMessage(this.getInstanceData().languageId);
        this.stripTranslationColorsButton = this.childFrame.addControl(new CheckBoxControl(calc1, this.getButtonY(1), "gui.config.name.accessibility.strip_translation_colors", this.getInstanceData().stripTranslationColors, () -> {
            this.getInstanceData().stripTranslationColors = this.stripTranslationColorsButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.accessibility.strip_translation_colors", new Object[0])))));
        this.stripTranslationFormattingButton = this.childFrame.addControl(new CheckBoxControl(calc1, this.getButtonY(2, -10), "gui.config.name.accessibility.strip_translation_formatting", this.getInstanceData().stripTranslationFormatting, () -> {
            this.getInstanceData().stripTranslationFormatting = this.stripTranslationFormattingButton.isChecked();
        }, () -> {
            if (this.stripTranslationFormattingButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.accessibility.strip_translation_formatting", new Object[0])));
            } else if (ModUtils.IS_TEXT_FORMATTING_BLOCKED) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("craftpresence.message.unsupported", new Object[0])));
            }
        }));
        this.stripExtraGuiElementsButton = this.childFrame.addControl(new CheckBoxControl(calc1, this.getButtonY(3, -20), "gui.config.name.accessibility.strip_extra_gui_elements", this.getInstanceData().stripExtraGuiElements, () -> {
            this.getInstanceData().stripExtraGuiElements = this.stripExtraGuiElementsButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.accessibility.strip_extra_gui_elements", new Object[0])))));
        this.renderTooltipsButton = this.childFrame.addControl(new CheckBoxControl(calc1, this.getButtonY(4, -30), "gui.config.name.accessibility.render_tooltips", this.getInstanceData().renderTooltips, () -> {
            this.getInstanceData().renderTooltips = this.renderTooltipsButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.accessibility.render_tooltips", new Object[0])))));
        List<String> controlInfo = StringUtils.newArrayList("key.craftpresence.category");
        KeyUtils.FilterMode controlMode = KeyUtils.FilterMode.Category;
        if (Constants.IS_LEGACY_SOFT) {
            controlInfo.clear();
            StringUtils.addEntriesNotPresent(controlInfo, CraftPresence.KEYBINDINGS.getRawKeyMappings().keySet());
            controlMode = KeyUtils.FilterMode.Name;
        }
        KeyUtils.FilterMode finalControlMode = controlMode;
        this.controlsButton = this.childFrame.addControl(new ExtendedButtonControl(calc2, this.getButtonY(1), 180, 20, "gui.config.message.button.controls", () -> this.openScreen(new ControlsGui(this.currentScreen, finalControlMode, controlInfo)), new String[0]));
        this.childFrame.addControl(new ExtendedButtonControl(calc2, this.getButtonY(2), 180, 20, "gui.config.title.editor.color", () -> this.openScreen(new SelectorGui(this.currentScreen, Constants.TRANSLATOR.translate("gui.config.title.selector.item", new Object[0]), this.colorSettings.keySet(), null, null, true, false, ScrollableListControl.RenderType.None, null, (currentValue, parentScreen) -> {
            Pair<ColorData, ColorData> settings = this.colorSettings.get(currentValue);
            this.openScreen(new ColorEditorGui((class_388)parentScreen, settings.getFirst(), settings.getSecond()));
        })), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.hover.color_editor", new Object[0]))), new String[0]));
    }

    @Override
    protected boolean allowedToReset() {
        return true;
    }

    @Override
    protected void syncRenderStates() {
        super.syncRenderStates();
        this.stripTranslationFormattingButton.setControlEnabled(!ModUtils.IS_TEXT_FORMATTING_BLOCKED);
        this.controlsButton.setControlEnabled(CraftPresence.KEYBINDINGS.areKeysRegistered());
        this.proceedButton.setControlEnabled(!StringUtils.isNullOrEmpty(this.languageIdText.getControlMessage()));
    }

    @Override
    protected Accessibility getInstanceData() {
        return this.INSTANCE;
    }

    @Override
    protected Accessibility getCurrentData() {
        return CraftPresence.CONFIG.accessibilitySettings;
    }

    @Override
    protected Accessibility getDefaultData() {
        return this.DEFAULTS;
    }
}

