/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core.integrations.screen;

import com.gitlab.cdagaming.craftpresence.core.integrations.screen.ScreenRectangle;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.annotation.Nullable;

public class ScissorStack {
    private final Deque<ScreenRectangle> stack = new ArrayDeque<ScreenRectangle>();

    public ScreenRectangle push(ScreenRectangle scissor) {
        ScreenRectangle last = this.stack.peekLast();
        if (last != null) {
            ScreenRectangle intersection = scissor.intersection(last);
            ScreenRectangle lv2 = intersection != null ? intersection : ScreenRectangle.empty();
            this.stack.addLast(lv2);
            return lv2;
        }
        this.stack.addLast(scissor);
        return scissor;
    }

    @Nullable
    public ScreenRectangle pop() {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("Scissor stack underflow");
        }
        this.stack.removeLast();
        return this.stack.peekLast();
    }
}

