/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.integrations.replaymod;

import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.impl.Module;
import com.gitlab.cdagaming.craftpresence.core.utils.FileUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.MappingUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import external.io.github.classgraph.ClassInfo;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.config.Config;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;

public class ReplayModUtils
implements Module {
    private final Class<?> screenClass = FileUtils.findValidClass("com.replaymod.lib.de.johni0702.minecraft.gui.container.GuiScreen");
    private final Class<?> overlayClass = FileUtils.findValidClass("com.replaymod.lib.de.johni0702.minecraft.gui.container.GuiOverlay");
    private final Class<?> abstractContainerClass = FileUtils.findValidClass("com.replaymod.lib.de.johni0702.minecraft.gui.container.AbstractGuiContainer");
    private final Class<?> abstractScreenClass = FileUtils.findValidClass("com.replaymod.lib.de.johni0702.minecraft.gui.container.AbstractGuiScreen");
    private final Class<?> abstractOverlayClass = FileUtils.findValidClass("com.replaymod.lib.de.johni0702.minecraft.gui.container.AbstractGuiOverlay");
    private final Class<?> videoRendererScreen = FileUtils.findValidClass("com.replaymod.render.gui.GuiVideoRenderer");
    private final Class<?> videoRendererInfo = FileUtils.findValidClass("com.replaymod.render.rendering.VideoRenderer");
    public boolean enabled = false;
    private boolean isInUse = false;
    private boolean hasScanned = false;
    private String CURRENT_GUI_NAME;
    private Object CURRENT_SCREEN;

    @Override
    public void emptyData() {
        this.clearClientData();
    }

    @Override
    public void clearClientData() {
        this.CURRENT_GUI_NAME = null;
        this.CURRENT_SCREEN = null;
        this.setInUse(false);
        CraftPresence.CLIENT.removeArguments("replaymod");
    }

    @Override
    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.advancedSettings.enablePerGui : this.enabled;
        boolean bl = needsUpdate = this.enabled && !this.hasScanned && this.canFetchData();
        if (needsUpdate) {
            this.scanForData();
            this.hasScanned = true;
        }
        if (this.isEnabled()) {
            if (CraftPresence.GUIS.CURRENT_SCREEN != null) {
                this.setInUse(true);
                this.updateData();
            } else if (this.isInUse()) {
                this.clearClientData();
            }
        } else if (this.isInUse()) {
            this.emptyData();
        }
    }

    @Override
    public void updateData() {
        if (CraftPresence.GUIS.CURRENT_SCREEN == null) {
            this.clearClientData();
        } else {
            Object possibleScreen = StringUtils.executeMethod(this.screenClass, null, new Class[]{GuiScreen.class}, new Object[]{CraftPresence.GUIS.CURRENT_SCREEN}, "from");
            Object possibleOverlay = StringUtils.executeMethod(this.overlayClass, null, new Class[]{GuiScreen.class}, new Object[]{CraftPresence.GUIS.CURRENT_SCREEN}, "from");
            if (possibleScreen == null && possibleOverlay == null) {
                this.clearClientData();
            } else {
                Object newScreen = possibleOverlay != null ? possibleOverlay : possibleScreen;
                String newScreenName = MappingUtils.getClassName(newScreen);
                if (!newScreen.equals(this.CURRENT_SCREEN) || !newScreenName.equals(this.CURRENT_GUI_NAME)) {
                    this.CURRENT_SCREEN = newScreen;
                    this.CURRENT_GUI_NAME = newScreenName;
                    if (!CraftPresence.GUIS.GUI_NAMES.contains(newScreenName)) {
                        CraftPresence.GUIS.GUI_NAMES.add(newScreenName);
                    }
                    this.updatePresence();
                }
                this.syncPlaceholders();
            }
        }
    }

    @Override
    public void getAllData() {
        List<Class<?>> searchClasses = StringUtils.newArrayList(this.abstractContainerClass, this.abstractScreenClass, this.abstractOverlayClass);
        for (ClassInfo classObj : FileUtils.getClassNamesMatchingSuperType(searchClasses, new String[0]).values()) {
            String screenName = MappingUtils.getClassName(classObj);
            if (!CraftPresence.GUIS.GUI_NAMES.contains(screenName)) {
                CraftPresence.GUIS.GUI_NAMES.add(screenName);
            }
            if (CraftPresence.GUIS.GUI_CLASSES.containsKey(screenName)) continue;
            CraftPresence.GUIS.GUI_CLASSES.put(screenName, classObj);
        }
    }

    @Override
    public boolean canFetchData() {
        return FileUtils.canScanClasses();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean isInUse() {
        return this.isInUse;
    }

    @Override
    public void setInUse(boolean state) {
        this.isInUse = state;
    }

    @Override
    public void updatePresence() {
        ModuleData defaultData = CraftPresence.CONFIG.advancedSettings.guiSettings.guiData.get("default");
        ModuleData currentData = CraftPresence.CONFIG.advancedSettings.guiSettings.guiData.get(this.CURRENT_GUI_NAME);
        String defaultMessage = Config.isValidProperty(defaultData, "textOverride") ? defaultData.getTextOverride() : "";
        String currentMessage = Config.isValidProperty(currentData, "textOverride") ? currentData.getTextOverride() : defaultMessage;
        String defaultIcon = Config.isValidProperty(defaultData, "iconOverride") ? defaultData.getIconOverride() : this.CURRENT_GUI_NAME;
        String currentIcon = Config.isValidProperty(currentData, "iconOverride") ? currentData.getIconOverride() : defaultIcon;
        String formattedIcon = CraftPresence.CLIENT.imageOf("screen.icon", true, currentIcon, CraftPresence.CONFIG.advancedSettings.guiSettings.fallbackGuiIcon);
        CraftPresence.CLIENT.syncArgument("screen.default.icon", CraftPresence.CONFIG.advancedSettings.guiSettings.fallbackGuiIcon);
        CraftPresence.CLIENT.syncArgument("data.screen.instance", this.CURRENT_SCREEN);
        CraftPresence.CLIENT.syncArgument("screen.name", this.CURRENT_GUI_NAME);
        CraftPresence.CLIENT.syncOverride(currentData != null ? currentData : defaultData, "screen.message", "screen.icon");
        CraftPresence.CLIENT.syncArgument("screen.message", currentMessage);
        CraftPresence.CLIENT.syncArgument("screen.icon", formattedIcon);
    }

    private void syncPlaceholders() {
        if (this.CURRENT_SCREEN != null && this.CURRENT_SCREEN.getClass() == this.videoRendererScreen) {
            CraftPresence.CLIENT.syncArgument("replaymod.time.current", this.secToString(StringUtils.getValidInteger(StringUtils.getField(this.videoRendererScreen, this.CURRENT_SCREEN, "renderTimeTaken")).getSecond() / 1000));
            CraftPresence.CLIENT.syncArgument("replaymod.time.remaining", this.secToString(StringUtils.getValidInteger(StringUtils.getField(this.videoRendererScreen, this.CURRENT_SCREEN, "renderTimeLeft")).getSecond() / 1000));
            Object rendererObj = StringUtils.getField(this.videoRendererScreen, this.CURRENT_SCREEN, "renderer");
            if (rendererObj != null && rendererObj.getClass() == this.videoRendererInfo) {
                CraftPresence.CLIENT.syncArgument("replaymod.frames.current", StringUtils.executeMethod(this.videoRendererInfo, rendererObj, null, null, "getFramesDone"));
                CraftPresence.CLIENT.syncArgument("replaymod.frames.total", StringUtils.executeMethod(this.videoRendererInfo, rendererObj, null, null, "getTotalFrames"));
            }
        } else {
            CraftPresence.CLIENT.removeArguments("replaymod");
        }
    }

    private String secToString(int seconds) {
        int hours = seconds / 3600;
        int min = seconds / 60 - hours * 60;
        int sec = seconds - (min * 60 + hours * 60 * 60);
        StringBuilder builder = new StringBuilder();
        if (hours > 0) {
            builder.append(hours).append("hour(s)");
        }
        if (min > 0 || hours > 0) {
            builder.append(min).append("minute(s)");
        }
        builder.append(sec).append("second(s)");
        return builder.toString();
    }
}

