/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core.utils;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.integrations.versioning.VersionComparator;
import com.gitlab.cdagaming.craftpresence.core.utils.FileUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.UrlUtils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ModUpdaterUtils {
    public UpdateState currentState = UpdateState.PENDING;
    public String modID;
    public String updateUrl;
    public String downloadUrl;
    public String targetLatestVersion;
    public String targetRecommendedVersion;
    public String targetVersion;
    public Map<String, String> changelogData = new LinkedHashMap<String, String>();
    public String currentVersion;
    public String currentGameVersion;

    public ModUpdaterUtils(String modID, String updateUrl, String currentVersion, String currentGameVersion) {
        this.modID = modID;
        this.updateUrl = updateUrl;
        this.currentGameVersion = currentGameVersion;
        this.currentVersion = currentVersion;
    }

    public void flushData() {
        this.currentState = UpdateState.PENDING;
        this.targetRecommendedVersion = "";
        this.targetLatestVersion = "";
        this.targetVersion = "";
        this.downloadUrl = "";
        this.changelogData.clear();
    }

    public void checkForUpdates() {
        this.checkForUpdates(null);
    }

    public void checkForUpdates(Runnable callback) {
        Constants.getThreadFactory().newThread(() -> this.process(callback)).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(Runnable callback) {
        try {
            boolean hasLatest;
            this.flushData();
            if (StringUtils.isNullOrEmpty(this.updateUrl)) {
                return;
            }
            Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.updater.init", this.modID, this.currentGameVersion, this.updateUrl), new Object[0]);
            String data = UrlUtils.getURLText(this.updateUrl, "UTF-8");
            Constants.LOG.debugInfo(Constants.TRANSLATOR.translate("craftpresence.logger.info.updater.receive.data", data), new Object[0]);
            Map json = FileUtils.getJsonData(data, Map.class, new FileUtils.Modifiers[0]);
            Map promos = (Map)json.get("promos");
            this.downloadUrl = (String)json.get("homepage");
            this.targetRecommendedVersion = (String)promos.get(this.currentGameVersion + "-recommended");
            this.targetLatestVersion = (String)promos.get(this.currentGameVersion + "-latest");
            VersionComparator cmp = new VersionComparator();
            boolean hasRecommended = !StringUtils.isNullOrEmpty(this.targetRecommendedVersion);
            boolean bl = hasLatest = !StringUtils.isNullOrEmpty(this.targetLatestVersion);
            if (hasRecommended) {
                int diff = cmp.compare(this.targetRecommendedVersion, this.currentVersion);
                if (diff == 0) {
                    this.currentState = UpdateState.UP_TO_DATE;
                } else if (diff < 0) {
                    this.currentState = UpdateState.AHEAD;
                    if (hasLatest && cmp.compare(this.currentVersion, this.targetLatestVersion) < 0) {
                        this.currentState = UpdateState.OUTDATED;
                        this.targetVersion = this.targetLatestVersion;
                    }
                } else {
                    this.currentState = UpdateState.OUTDATED;
                    this.targetVersion = this.targetRecommendedVersion;
                }
            } else if (hasLatest) {
                this.currentState = cmp.compare(this.currentVersion, this.targetLatestVersion) < 0 ? UpdateState.BETA_OUTDATED : UpdateState.BETA;
                this.targetVersion = this.targetLatestVersion;
            } else {
                this.currentState = UpdateState.BETA;
            }
            Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.updater.receive.status", this.modID, this.currentState.getDisplayName(), this.targetVersion), new Object[0]);
            this.changelogData.clear();
            Map tmp = (Map)json.get(this.currentGameVersion);
            if (tmp != null) {
                List<String> ordered = StringUtils.newArrayList();
                for (String key : tmp.keySet()) {
                    if (cmp.compare(key, this.currentVersion) <= 0 || !StringUtils.isNullOrEmpty(this.targetVersion) && cmp.compare(key, this.targetVersion) >= 1) continue;
                    ordered.add(key);
                }
                Collections.sort(ordered);
                for (String ver : ordered) {
                    this.changelogData.put(ver, (String)tmp.get(ver));
                }
            }
        }
        catch (Throwable ex) {
            Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.updater.failed", new Object[0]), new Object[0]);
            Constants.LOG.debugError(ex);
            this.currentState = UpdateState.FAILED;
        }
        finally {
            if (callback != null) {
                callback.run();
            }
        }
    }

    public static enum UpdateState {
        FAILED,
        UP_TO_DATE("Release"),
        AHEAD,
        OUTDATED,
        BETA_OUTDATED("Beta (Outdated)"),
        BETA,
        PENDING;

        final String displayName;

        private UpdateState() {
            this.displayName = StringUtils.formatWord(this.name().toLowerCase());
        }

        private UpdateState(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

