/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.config.Config;
import forge.com.gitlab.cdagaming.craftpresence.config.element.ModuleData;
import forge.com.gitlab.cdagaming.craftpresence.impl.Module;
import forge.com.gitlab.cdagaming.craftpresence.impl.Pair;
import forge.com.gitlab.cdagaming.craftpresence.impl.Tuple;
import forge.com.gitlab.cdagaming.craftpresence.impl.discord.DiscordStatus;
import forge.com.gitlab.cdagaming.craftpresence.impl.discord.PartyPrivacy;
import forge.com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiPlayerInfo;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.GuiConnecting;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.network.NetHandlerPlayClient;

public class ServerUtils
implements Module {
    public boolean isInUse = false;
    public boolean enabled = false;
    public boolean hasScanned = false;
    public List<GuiPlayerInfo> currentPlayerList = Lists.newArrayList();
    public List<String> knownAddresses = Lists.newArrayList();
    public Map<String, ServerData> knownServerData = Maps.newHashMap();
    private String currentServer_IP;
    private String currentServer_Name;
    private String currentServer_MOTD;
    private List<String> currentServer_MOTD_Lines = Lists.newArrayList();
    private String currentServerMessage = "";
    private boolean canUseEndpointIcon = false;
    private String currentServerIcon = "";
    private String timeString24;
    private String timeString12;
    private String dayString;
    private String currentDifficulty;
    private String currentWorldName;
    private int currentPlayers;
    private int maxPlayers;
    private int serverIndex;
    private Tuple<Double, Double, Double> currentCoordinates = new Tuple<Double, Double, Double>(0.0, 0.0, 0.0);
    private Pair<Double, Double> currentHealth = new Pair<Double, Double>(0.0, 0.0);
    private ServerData currentServerData;
    private ServerData requestedServerData;
    private NetHandlerPlayClient currentConnection;
    private boolean queuedForUpdate = false;
    private boolean joinInProgress = false;
    private boolean isOnLAN = false;

    @Override
    public void emptyData() {
        this.hasScanned = false;
        this.currentPlayerList.clear();
        this.knownAddresses.clear();
        this.knownServerData.clear();
        this.clearClientData();
    }

    @Override
    public void clearClientData() {
        this.currentServer_IP = null;
        this.currentServer_MOTD = null;
        this.currentServer_MOTD_Lines.clear();
        this.currentServer_Name = null;
        this.currentServerData = null;
        this.currentConnection = null;
        this.currentCoordinates = new Tuple<Double, Double, Double>(0.0, 0.0, 0.0);
        this.currentHealth = new Pair<Double, Double>(0.0, 0.0);
        this.currentDifficulty = null;
        this.currentWorldName = null;
        this.currentServerMessage = "";
        this.currentServerIcon = "";
        this.canUseEndpointIcon = false;
        this.timeString24 = null;
        this.timeString12 = null;
        this.dayString = null;
        this.currentPlayers = 0;
        this.maxPlayers = 0;
        this.queuedForUpdate = false;
        this.isOnLAN = false;
        this.setInUse(false);
        if (!this.joinInProgress) {
            this.requestedServerData = null;
        }
        CraftPresence.CLIENT.removeArguments("server", "world", "player");
        CraftPresence.CLIENT.clearOverride("server.message", "server.icon");
        CraftPresence.CLIENT.clearPartyData(true, false);
    }

    @Override
    public void onTick() {
        boolean needsUpdate;
        this.joinInProgress = CraftPresence.CLIENT.STATUS == DiscordStatus.JoinGame || CraftPresence.CLIENT.STATUS == DiscordStatus.SpectateGame;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.generalSettings.detectWorldData : this.enabled;
        boolean bl = needsUpdate = this.enabled && !this.hasScanned;
        if (needsUpdate) {
            new Thread(this::getAllData, "CraftPresence-Server-Lookup").start();
            this.hasScanned = true;
        }
        if (this.enabled) {
            if (CraftPresence.player != null && !this.joinInProgress) {
                this.setInUse(true);
                this.updateData();
            } else if (this.isInUse()) {
                this.clearClientData();
            }
        } else if (this.isInUse()) {
            this.emptyData();
        }
        if (this.joinInProgress && this.requestedServerData != null) {
            CraftPresence.instance.func_152344_a(() -> this.joinServer(this.requestedServerData));
        }
    }

    @Override
    public void updateData() {
        ServerData newServerData = CraftPresence.instance.func_147104_D();
        NetHandlerPlayClient newConnection = CraftPresence.instance.func_147114_u();
        if (!this.joinInProgress) {
            String newGameDay;
            String newGameTime;
            String secondaryWorldName;
            String primaryWorldName;
            String newWorldName;
            String newDifficulty;
            Pair<Double, Double> newHealth;
            String newServer_MOTD;
            ArrayList newPlayerList = newConnection != null ? Lists.newArrayList((Iterable)newConnection.field_147303_b) : Lists.newArrayList();
            int newCurrentPlayers = newConnection != null ? newConnection.field_147303_b.size() : 1;
            int newMaxPlayers = newConnection != null && newConnection.field_147304_c >= newCurrentPlayers ? newConnection.field_147304_c : newCurrentPlayers + 1;
            boolean newLANStatus = CraftPresence.instance.func_71356_B() && newCurrentPlayers > 1 || newServerData != null && newServerData.func_152585_d();
            String newServer_IP = newServerData != null && !StringUtils.isNullOrEmpty(newServerData.field_78845_b) ? newServerData.field_78845_b : "127.0.0.1";
            String newServer_Name = newServerData != null && !StringUtils.isNullOrEmpty(newServerData.field_78847_a) ? newServerData.field_78847_a : CraftPresence.CONFIG.serverSettings.fallbackServerName;
            String string = newServer_MOTD = !this.isOnLAN && !CraftPresence.instance.func_71356_B() && newServerData != null && !StringUtils.isNullOrEmpty(newServerData.field_78843_d) && !newServerData.field_78843_d.equalsIgnoreCase(ModUtils.TRANSLATOR.translate("craftpresence.multiplayer.status.cannot_connect", new Object[0])) && !newServerData.field_78843_d.equalsIgnoreCase(ModUtils.TRANSLATOR.translate("craftpresence.multiplayer.status.cannot_resolve", new Object[0])) && !newServerData.field_78843_d.equalsIgnoreCase(ModUtils.TRANSLATOR.translate("craftpresence.multiplayer.status.polling", new Object[0])) && !newServerData.field_78843_d.equalsIgnoreCase(ModUtils.TRANSLATOR.translate("craftpresence.multiplayer.status.pinging", new Object[0])) ? StringUtils.stripColors(newServerData.field_78843_d) : CraftPresence.CONFIG.serverSettings.fallbackServerMotd;
            if (newLANStatus != this.isOnLAN || newServerData != null && !newServerData.equals(this.currentServerData) || newServerData == null && this.currentServerData != null || newConnection != null && !newConnection.equals(this.currentConnection) || !newServer_IP.equals(this.currentServer_IP) || !StringUtils.isNullOrEmpty(newServer_MOTD) && !newServer_MOTD.equals(this.currentServer_MOTD) || !StringUtils.isNullOrEmpty(newServer_Name) && !newServer_Name.equals(this.currentServer_Name)) {
                this.currentServer_IP = newServer_IP;
                if (!newServer_MOTD.equals(this.currentServer_MOTD)) {
                    this.currentServer_MOTD = newServer_MOTD;
                    this.currentServer_MOTD_Lines = StringUtils.splitTextByNewLine(newServer_MOTD);
                }
                this.currentServer_Name = newServer_Name;
                this.currentServerData = newServerData;
                this.currentConnection = newConnection;
                this.isOnLAN = newLANStatus;
                this.queuedForUpdate = true;
                if (!StringUtils.isNullOrEmpty(this.currentServer_IP)) {
                    String formattedIP;
                    String string2 = formattedIP = this.currentServer_IP.contains(":") ? StringUtils.formatAddress(this.currentServer_IP, false) : this.currentServer_IP;
                    if (!this.knownAddresses.contains(formattedIP)) {
                        this.knownAddresses.add(formattedIP);
                    }
                }
                ServerList serverList = new ServerList(CraftPresence.instance);
                serverList.func_78853_a();
                if (serverList.func_78856_c() != this.serverIndex || CraftPresence.CONFIG.serverSettings.serverData.size() != this.serverIndex) {
                    this.getAllData();
                }
            }
            double newX = StringUtils.roundDouble(CraftPresence.player != null ? CraftPresence.player.field_70165_t : 0.0, CraftPresence.CONFIG.advancedSettings.roundSize);
            double newY = StringUtils.roundDouble(CraftPresence.player != null ? CraftPresence.player.field_70163_u : 0.0, CraftPresence.CONFIG.advancedSettings.roundSize);
            double newZ = StringUtils.roundDouble(CraftPresence.player != null ? CraftPresence.player.field_70161_v : 0.0, CraftPresence.CONFIG.advancedSettings.roundSize);
            Tuple<Double, Double, Double> newCoordinates = new Tuple<Double, Double, Double>(newX, newY, newZ);
            if (!newCoordinates.equals(this.currentCoordinates)) {
                this.currentCoordinates = newCoordinates;
                this.queuedForUpdate = true;
            }
            Pair<Double, Double> pair = newHealth = CraftPresence.player != null ? new Pair<Double, Double>(StringUtils.roundDouble(CraftPresence.player.func_110143_aJ(), 0), StringUtils.roundDouble(CraftPresence.player.func_110138_aP(), 0)) : new Pair<Double, Double>(0.0, 0.0);
            if (!newHealth.equals(this.currentHealth)) {
                this.currentHealth = newHealth;
                this.queuedForUpdate = true;
            }
            String string3 = CraftPresence.player != null ? (CraftPresence.player.field_70170_p.func_72912_H().func_76093_s() ? ModUtils.TRANSLATOR.translate("craftpresence.defaults.mode.hardcore", new Object[0]) : CraftPresence.player.field_70170_p.field_73013_u.name()) : (newDifficulty = "");
            if (!newDifficulty.equals(this.currentDifficulty)) {
                this.currentDifficulty = newDifficulty;
                this.queuedForUpdate = true;
            }
            if (!(newWorldName = StringUtils.getOrDefault(primaryWorldName = CraftPresence.instance.func_71401_C() != null ? CraftPresence.instance.func_71401_C().func_71221_J() : "", secondaryWorldName = CraftPresence.player != null ? CraftPresence.player.field_70170_p.func_72912_H().func_76065_j() : ModUtils.TRANSLATOR.translate("craftpresence.defaults.world_name", new Object[0]))).equals(this.currentWorldName)) {
                this.currentWorldName = newWorldName;
                this.queuedForUpdate = true;
            }
            String string4 = newGameTime = CraftPresence.player != null ? this.getTimeString(CraftPresence.player.field_70170_p.func_72820_D()) : null;
            if (!StringUtils.isNullOrEmpty(newGameTime) && !newGameTime.equals(this.timeString24)) {
                this.timeString24 = newGameTime;
                this.timeString12 = StringUtils.convertTime(newGameTime, "HH:mm", "hh:mm aa");
                this.queuedForUpdate = true;
            }
            String string5 = newGameDay = CraftPresence.player != null ? String.format("%d", CraftPresence.player.field_70170_p.func_72820_D() / 24000L) : null;
            if (!StringUtils.isNullOrEmpty(newGameDay) && !newGameDay.equals(this.dayString)) {
                this.dayString = newGameDay;
                this.queuedForUpdate = true;
            }
            if (newCurrentPlayers != this.currentPlayers || newMaxPlayers != this.maxPlayers) {
                this.currentPlayers = newCurrentPlayers;
                this.maxPlayers = newMaxPlayers;
                this.queuedForUpdate = true;
            }
            if (!newPlayerList.equals(this.currentPlayerList)) {
                this.currentPlayerList = newPlayerList;
                if (CraftPresence.ENTITIES.enabled) {
                    CraftPresence.ENTITIES.ENTITY_NAMES.removeAll(CraftPresence.ENTITIES.PLAYER_BINDINGS.keySet());
                    CraftPresence.ENTITIES.getAllData();
                }
            }
        }
        if (this.queuedForUpdate) {
            this.updatePresence();
        }
    }

    private String getTimeString(long worldTime) {
        int ticks = (int)(worldTime % 24000L);
        if ((ticks += 6000) > 24000) {
            ticks -= 24000;
        }
        return String.format("%02d:%02d", ticks / 1000, (int)((double)(ticks % 1000) / 1000.0 * 60.0));
    }

    private String makeSecret() {
        String formattedKey = CraftPresence.CLIENT.CLIENT_ID + "";
        boolean containsServerName = false;
        boolean containsServerIP = false;
        if (!StringUtils.isNullOrEmpty(this.currentServer_Name)) {
            formattedKey = formattedKey + "-" + this.currentServer_Name.toLowerCase();
            containsServerName = true;
        }
        if (!StringUtils.isNullOrEmpty(this.currentServer_IP)) {
            formattedKey = formattedKey + "-" + this.currentServer_IP.toLowerCase();
            containsServerIP = true;
        }
        formattedKey = formattedKey + ";" + containsServerName + ";" + containsServerIP;
        return formattedKey;
    }

    public void verifyAndJoin(String secret) {
        boolean isValidSecret;
        String[] boolParts = secret.split(";");
        String[] stringParts = boolParts[0].split("-");
        boolean containsValidClientID = StringUtils.elementExists(stringParts, 0) && stringParts[0].length() >= 18 && StringUtils.getValidLong(stringParts[0]).getFirst() != false;
        boolean containsServerName = StringUtils.elementExists(boolParts, 1) && StringUtils.elementExists(stringParts, 1) && Boolean.parseBoolean(boolParts[1]);
        boolean containsServerIP = StringUtils.elementExists(boolParts, 2) && StringUtils.elementExists(stringParts, 2) && Boolean.parseBoolean(boolParts[2]);
        String serverName = containsServerName ? stringParts[1] : CraftPresence.CONFIG.serverSettings.fallbackServerName;
        String serverIP = containsServerIP ? stringParts[2] : "";
        boolean bl = isValidSecret = boolParts.length <= 4 && stringParts.length <= 3 && containsValidClientID;
        if (isValidSecret) {
            if (CraftPresence.CONFIG.generalSettings.enableJoinRequests) {
                this.requestedServerData = new ServerData(serverName, serverIP, false);
            } else {
                ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.warning.config.disabled.enable_join_request", new Object[0]), new Object[0]);
            }
        } else {
            ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.discord.join", secret), new Object[0]);
        }
    }

    private void joinServer(ServerData serverData) {
        try {
            if (CraftPresence.player != null) {
                CraftPresence.player.field_70170_p.func_72882_A();
                CraftPresence.instance.func_71403_a(null);
            }
            CraftPresence.instance.func_147108_a((GuiScreen)new GuiConnecting((GuiScreen)(CraftPresence.instance.field_71462_r != null ? CraftPresence.instance.field_71462_r : new GuiMainMenu()), CraftPresence.instance, serverData));
        }
        catch (Exception ex) {
            if (CommandUtils.isVerboseMode()) {
                ex.printStackTrace();
            }
        }
        finally {
            this.requestedServerData = null;
        }
    }

    @Override
    public void updatePresence() {
        this.canUseEndpointIcon = false;
        CraftPresence.CLIENT.syncArgument("player.position.x", this.currentCoordinates.getFirst());
        CraftPresence.CLIENT.syncArgument("player.position.y", this.currentCoordinates.getSecond());
        CraftPresence.CLIENT.syncArgument("player.position.z", this.currentCoordinates.getThird());
        CraftPresence.CLIENT.syncArgument("player.health.current", this.currentHealth.getFirst());
        CraftPresence.CLIENT.syncArgument("player.health.max", this.currentHealth.getSecond());
        CraftPresence.CLIENT.syncArgument("world.difficulty", StringUtils.getOrDefault(this.currentDifficulty));
        CraftPresence.CLIENT.syncArgument("world.name", StringUtils.getOrDefault(this.currentWorldName));
        CraftPresence.CLIENT.syncArgument("world.time24", StringUtils.getOrDefault(this.timeString24));
        CraftPresence.CLIENT.syncArgument("world.time12", StringUtils.getOrDefault(this.timeString12));
        CraftPresence.CLIENT.syncArgument("world.day", StringUtils.getOrDefault(this.dayString));
        CraftPresence.CLIENT.syncArgument("server.default.icon", CraftPresence.CONFIG.serverSettings.fallbackServerIcon);
        ModuleData resultData = new ModuleData();
        if (!CraftPresence.instance.func_71356_B() && this.currentServerData != null) {
            String currentIcon;
            CraftPresence.CLIENT.syncArgument("server.players.current", this.currentPlayers);
            CraftPresence.CLIENT.syncArgument("server.players.max", this.maxPlayers);
            String formattedIP = this.currentServer_IP.contains(":") ? StringUtils.formatAddress(this.currentServer_IP, false) : this.currentServer_IP;
            CraftPresence.CLIENT.syncArgument("server.address.full", this.currentServer_IP);
            CraftPresence.CLIENT.syncArgument("server.address.short", formattedIP);
            CraftPresence.CLIENT.syncArgument("server.name", this.currentServer_Name);
            CraftPresence.CLIENT.syncArgument("server.motd.raw", this.currentServer_MOTD);
            if (!this.currentServer_MOTD_Lines.isEmpty()) {
                int index = 1;
                for (String motdPart : this.currentServer_MOTD_Lines) {
                    CraftPresence.CLIENT.syncArgument("data.server.motd.line." + index, motdPart);
                    ++index;
                }
            }
            ModuleData defaultData = CraftPresence.CONFIG.serverSettings.serverData.get("default");
            ModuleData alternateData = CraftPresence.CONFIG.serverSettings.serverData.get(this.currentServer_Name);
            ModuleData primaryData = CraftPresence.CONFIG.serverSettings.serverData.get(formattedIP);
            this.canUseEndpointIcon = CraftPresence.CONFIG.advancedSettings.allowEndpointIcons && !StringUtils.isNullOrEmpty(CraftPresence.CONFIG.advancedSettings.serverIconEndpoint);
            String defaultIcon = Config.isValidProperty(defaultData, "iconOverride") ? defaultData.getIconOverride() : "";
            String alternateIcon = Config.isValidProperty(alternateData, "iconOverride") ? alternateData.getIconOverride() : defaultIcon;
            String string = currentIcon = Config.isValidProperty(primaryData, "iconOverride") ? primaryData.getIconOverride() : alternateIcon;
            resultData = primaryData != null ? primaryData : (alternateData != null ? alternateData : defaultData);
            this.currentServerIcon = currentIcon;
            if (StringUtils.isNullOrEmpty(this.currentServerIcon)) {
                if (this.canUseEndpointIcon) {
                    if (!CraftPresence.CONFIG.displaySettings.dynamicIcons.containsKey(formattedIP)) {
                        CraftPresence.CONFIG.displaySettings.dynamicIcons.put(formattedIP, CraftPresence.CLIENT.compileData(String.format(CraftPresence.CONFIG.advancedSettings.serverIconEndpoint, formattedIP)).get().toString());
                        DiscordAssetUtils.syncCustomAssets();
                        CraftPresence.CONFIG.save();
                    }
                    this.currentServerIcon = formattedIP;
                } else {
                    this.currentServerIcon = this.currentServer_Name;
                }
            }
            if (this.isOnLAN) {
                resultData = CraftPresence.CONFIG.statusMessages.lanData;
                this.currentServerMessage = Config.isValidProperty(resultData, "textOverride") ? resultData.getTextOverride() : "";
                this.currentServerIcon = Config.isValidProperty(resultData, "iconOverride") ? resultData.getIconOverride() : "";
            } else {
                String defaultMessage = Config.isValidProperty(defaultData, "textOverride") ? defaultData.getTextOverride() : "";
                String alternateMessage = alternateData != null && Config.isValidProperty(alternateData, "textOverride") ? alternateData.getTextOverride() : defaultMessage;
                String string2 = this.currentServerMessage = primaryData != null && Config.isValidProperty(primaryData, "textOverride") ? primaryData.getTextOverride() : alternateMessage;
                if (CraftPresence.CONFIG.generalSettings.enableJoinRequests) {
                    CraftPresence.CLIENT.PARTY_ID = !StringUtils.isNullOrEmpty(this.currentServer_Name) && !this.currentServer_Name.equalsIgnoreCase(CraftPresence.CONFIG.serverSettings.fallbackServerName) ? "Join Server: " + this.currentServer_Name : "Join Server: " + this.currentServer_IP;
                    CraftPresence.CLIENT.JOIN_SECRET = this.makeSecret();
                    CraftPresence.CLIENT.PARTY_SIZE = this.currentPlayers;
                    CraftPresence.CLIENT.PARTY_MAX = this.maxPlayers;
                    CraftPresence.CLIENT.PARTY_PRIVACY = PartyPrivacy.from(CraftPresence.CONFIG.generalSettings.partyPrivacyLevel % 2);
                }
            }
        } else if (CraftPresence.instance.func_71356_B()) {
            resultData = CraftPresence.CONFIG.statusMessages.singleplayerData;
            this.currentServerMessage = Config.isValidProperty(resultData, "textOverride") ? resultData.getTextOverride() : "";
            this.currentServerIcon = Config.isValidProperty(resultData, "iconOverride") ? resultData.getIconOverride() : "";
        }
        String formattedIcon = CraftPresence.CLIENT.imageOf("server.icon", true, this.currentServerIcon, CraftPresence.CONFIG.serverSettings.fallbackServerIcon);
        CraftPresence.CLIENT.syncOverride(resultData, "server.message", "server.icon");
        CraftPresence.CLIENT.syncArgument("server.message", this.currentServerMessage);
        CraftPresence.CLIENT.syncArgument("server.icon", formattedIcon);
        this.queuedForUpdate = false;
    }

    @Override
    public void getAllData() {
        block5: {
            try {
                ServerList serverList = new ServerList(CraftPresence.instance);
                serverList.func_78853_a();
                this.serverIndex = serverList.func_78856_c();
                for (int currentIndex = 0; currentIndex < this.serverIndex; ++currentIndex) {
                    String formattedIP;
                    ServerData data = serverList.func_78850_a(currentIndex);
                    if (StringUtils.isNullOrEmpty(data.field_78845_b)) continue;
                    String string = formattedIP = data.field_78845_b.contains(":") ? StringUtils.formatAddress(data.field_78845_b, false) : data.field_78845_b;
                    if (!this.knownAddresses.contains(formattedIP)) {
                        this.knownAddresses.add(formattedIP);
                    }
                    if (this.knownServerData.containsKey(data.field_78845_b)) continue;
                    this.knownServerData.put(data.field_78845_b, data);
                }
            }
            catch (Exception ex) {
                if (!CommandUtils.isVerboseMode()) break block5;
                ex.printStackTrace();
            }
        }
        for (String serverEntry : CraftPresence.CONFIG.serverSettings.serverData.keySet()) {
            if (StringUtils.isNullOrEmpty(serverEntry) || this.knownAddresses.contains(serverEntry)) continue;
            this.knownAddresses.add(serverEntry);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean isInUse() {
        return this.isInUse;
    }

    @Override
    public void setInUse(boolean state) {
        if (state && !this.isInUse) {
            CraftPresence.CLIENT.syncTimestamp("data.server.time");
        }
        this.isInUse = state;
    }

    public ServerData getDataFromName(String serverAddress) {
        return this.knownServerData.getOrDefault(serverAddress, null);
    }
}

