/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;

public class PaginatedScreen
extends ExtendedScreen {
    private final Map<Integer, List<Gui>> paginatedControls = Maps.newHashMap();
    private final Map<Integer, List<ScrollableListControl>> paginatedLists = Maps.newHashMap();
    protected ExtendedButtonControl nextPageButton;
    protected ExtendedButtonControl previousPageButton;
    protected ExtendedButtonControl backButton;
    protected int startPage;
    protected int currentPage = this.startPage = 0;
    protected int maxPages = this.startPage;
    private Runnable onPageChange;

    public PaginatedScreen(GuiScreen parentScreen) {
        super(parentScreen);
    }

    public PaginatedScreen(GuiScreen parentScreen, boolean debugMode) {
        super(parentScreen, debugMode);
    }

    public PaginatedScreen(GuiScreen parentScreen, boolean debugMode, boolean verboseMode) {
        super(parentScreen, debugMode, verboseMode);
    }

    @Override
    public void initializeUi() {
        this.backButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getScreenHeight() - 30, 180, 20, "gui.config.message.button.back", () -> CraftPresence.GUIS.openScreen(this.parentScreen), new String[0]));
        this.previousPageButton = this.addControl(new ExtendedButtonControl(this.backButton.getControlPosX() - 23, this.getScreenHeight() - 30, 20, 20, "<", () -> {
            if (this.currentPage > this.startPage) {
                --this.currentPage;
                if (this.onPageChange != null) {
                    this.onPageChange.run();
                }
            }
        }, new String[0]));
        this.nextPageButton = this.addControl(new ExtendedButtonControl(this.backButton.getControlPosX() + this.backButton.getControlWidth() + 3, this.getScreenHeight() - 30, 20, 20, ">", () -> {
            if (this.currentPage < this.maxPages) {
                ++this.currentPage;
                if (this.onPageChange != null) {
                    this.onPageChange.run();
                }
            }
        }, new String[0]));
        this.previousPageButton.setControlEnabled(this.currentPage > this.startPage);
        this.nextPageButton.setControlEnabled(this.currentPage < this.maxPages);
        super.initializeUi();
    }

    @Nonnull
    protected <T extends Gui> T addControl(@Nonnull T buttonIn, int renderTarget) {
        if (!this.paginatedControls.containsKey(renderTarget)) {
            this.paginatedControls.put(renderTarget, Lists.newArrayList((Object[])new Gui[]{buttonIn}));
            if (renderTarget > this.maxPages) {
                this.maxPages = renderTarget;
            }
        } else {
            this.paginatedControls.get(renderTarget).add(buttonIn);
        }
        return super.addControl(buttonIn);
    }

    @Nonnull
    protected <T extends ScrollableListControl> T addList(@Nonnull T buttonIn, int renderTarget) {
        if (!this.paginatedLists.containsKey(renderTarget)) {
            this.paginatedLists.put(renderTarget, Lists.newArrayList((Object[])new ScrollableListControl[]{buttonIn}));
            if (renderTarget > this.maxPages) {
                this.maxPages = renderTarget;
            }
        } else {
            this.paginatedLists.get(renderTarget).add(buttonIn);
        }
        return super.addList(buttonIn);
    }

    @Override
    public void preRender() {
        ArrayList defaultButtons = Lists.newArrayList((Object[])new Gui[]{this.previousPageButton, this.nextPageButton, this.backButton});
        List<Gui> elementsToRender = this.paginatedControls.getOrDefault(this.currentPage, defaultButtons);
        List<ScrollableListControl> listsToRender = this.paginatedLists.getOrDefault(this.currentPage, Lists.newArrayList());
        for (Gui extendedControl : this.extendedControls) {
            if (extendedControl instanceof ExtendedButtonControl) {
                ((ExtendedButtonControl)extendedControl).setControlVisible(elementsToRender.contains(extendedControl) || defaultButtons.contains(extendedControl));
                ((ExtendedButtonControl)extendedControl).setControlEnabled(elementsToRender.contains(extendedControl) || defaultButtons.contains(extendedControl));
            }
            if (!(extendedControl instanceof ExtendedTextControl)) continue;
            ((ExtendedTextControl)extendedControl).func_146189_e(elementsToRender.contains(extendedControl) || defaultButtons.contains(extendedControl));
            ((ExtendedTextControl)extendedControl).func_146184_c(elementsToRender.contains(extendedControl) || defaultButtons.contains(extendedControl));
        }
        for (ScrollableListControl listControl : this.extendedLists) {
            listControl.func_148143_b(listsToRender.contains((Object)listControl));
        }
        this.previousPageButton.setControlEnabled(this.currentPage > this.startPage);
        this.nextPageButton.setControlEnabled(this.currentPage < this.maxPages);
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 200 && this.currentPage > this.startPage) {
            --this.currentPage;
        }
        if (keyCode == 208 && this.currentPage < this.maxPages) {
            ++this.currentPage;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    public void renderString(String text, float xPos, float yPos, int color, int renderTarget) {
        if (renderTarget == this.currentPage) {
            this.getFontRenderer().func_78261_a(text, Math.round(xPos), Math.round(yPos), color);
        }
    }

    public void setOnPageChange(Runnable onPageChange) {
        this.onPageChange = onPageChange;
    }
}

