/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.config.Config;
import forge.com.gitlab.cdagaming.craftpresence.config.element.ModuleData;
import forge.com.gitlab.cdagaming.craftpresence.impl.Module;
import forge.com.gitlab.cdagaming.craftpresence.impl.Pair;
import forge.com.gitlab.cdagaming.craftpresence.utils.FileUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.ImageUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.MappingUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.CheckBoxControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiUtils
implements Module {
    public final Map<String, Class<?>> GUI_CLASSES = Maps.newHashMap();
    public boolean configGUIOpened = false;
    public boolean isInUse = false;
    public boolean isFocused = false;
    public boolean enabled = false;
    public boolean hasScanned = false;
    public int lastIndex = 0;
    public List<String> GUI_NAMES = Lists.newArrayList();
    public String CURRENT_GUI_NAME;
    public Class<?> CURRENT_GUI_CLASS;
    public GuiScreen CURRENT_SCREEN;

    public static FontRenderer getDefaultFontRenderer() {
        return CraftPresence.instance.field_71466_p;
    }

    public static int getDefaultFontHeight() {
        return GuiUtils.getDefaultFontRenderer().field_78288_b;
    }

    public static String wrapFormattedStringToWidth(FontRenderer fontRenderer, String stringInput, int wrapWidth) {
        int stringSizeToWidth = GuiUtils.sizeStringToWidth(fontRenderer, stringInput, wrapWidth);
        if (stringInput.length() <= stringSizeToWidth) {
            return stringInput;
        }
        String subString = stringInput.substring(0, stringSizeToWidth);
        char currentCharacter = stringInput.charAt(stringSizeToWidth);
        boolean flag = Character.isSpaceChar(currentCharacter) || currentCharacter == '\n';
        String s1 = StringUtils.getFormatFromString(subString) + stringInput.substring(stringSizeToWidth + (flag ? 1 : 0));
        return subString + "\n" + GuiUtils.wrapFormattedStringToWidth(fontRenderer, s1, wrapWidth);
    }

    public static int sizeStringToWidth(FontRenderer fontRenderer, String stringEntry, int wrapWidth) {
        int currentLine;
        int stringLength = stringEntry.length();
        int charWidth = 0;
        int currentIndex = -1;
        boolean flag = false;
        for (currentLine = 0; currentLine < stringLength; ++currentLine) {
            char currentCharacter = stringEntry.charAt(currentLine);
            String stringOfCharacter = String.valueOf(currentCharacter);
            if (currentCharacter == ' ' || currentCharacter == '\n') {
                currentIndex = currentLine;
                if (currentCharacter == '\n') break;
            }
            if (currentCharacter == '\u00a7' && currentLine < stringLength - 1) {
                flag = (stringOfCharacter = String.valueOf(currentCharacter = stringEntry.charAt(++currentLine))).equalsIgnoreCase("l") && !stringOfCharacter.equalsIgnoreCase("r") && !StringUtils.STRIP_COLOR_PATTERN.matcher(stringOfCharacter).find();
            }
            charWidth += fontRenderer.func_78256_a(stringOfCharacter);
            if (flag) {
                ++charWidth;
            }
            if (charWidth > wrapWidth) break;
        }
        return currentLine != stringLength && currentIndex != -1 && currentIndex < currentLine ? currentIndex : currentLine;
    }

    public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, double zLevel) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + height), zLevel, (double)((float)u * 0.00390625f), (double)((float)(v + height) * 0.00390625f));
        tessellator.func_78374_a((double)(x + width), (double)(y + height), zLevel, (double)((float)(u + width) * 0.00390625f), (double)((float)(v + height) * 0.00390625f));
        tessellator.func_78374_a((double)(x + width), (double)y, zLevel, (double)((float)(u + width) * 0.00390625f), (double)((float)v * 0.00390625f));
        tessellator.func_78374_a((double)x, (double)y, zLevel, (double)((float)u * 0.00390625f), (double)((float)v * 0.00390625f));
        GL11.glEnable((int)3008);
        tessellator.func_78381_a();
    }

    public boolean isMouseWithin(double mouseX, double mouseY, double topIn, double bottomIn, double leftIn, double rightIn) {
        return mouseY >= topIn && mouseY <= bottomIn && mouseX >= leftIn && mouseX <= rightIn;
    }

    public boolean isMouseOver(double mouseX, double mouseY, double elementX, double elementY, double elementWidth, double elementHeight) {
        return mouseX >= elementX && mouseX <= elementX + elementWidth && mouseY >= elementY && mouseY <= elementY + elementHeight;
    }

    public boolean isMouseOver(double mouseX, double mouseY, ExtendedButtonControl button) {
        return button.isControlVisible() && this.isMouseOver(mouseX, mouseY, button.getControlPosX(), button.getControlPosY(), button.getControlWidth() - 1, button.getControlHeight() - 1);
    }

    public boolean isMouseOver(double mouseX, double mouseY, ExtendedTextControl textControl) {
        return this.isMouseOver(mouseX, mouseY, textControl.getControlPosX(), textControl.getControlPosY(), textControl.getControlWidth() - 1, textControl.getControlHeight() - 1);
    }

    public boolean isMouseOver(double mouseX, double mouseY, CheckBoxControl checkBox) {
        return checkBox.isControlVisible() && this.isMouseOver(mouseX, mouseY, checkBox.getControlPosX(), checkBox.getControlPosY(), checkBox.boxWidth - 1, checkBox.getControlHeight() - 1);
    }

    public int getNextIndex() {
        return this.lastIndex++;
    }

    public void resetIndex() {
        this.lastIndex = 0;
    }

    @Override
    public void emptyData() {
        this.hasScanned = false;
        this.GUI_NAMES.clear();
        this.GUI_CLASSES.clear();
        this.clearClientData();
    }

    @Override
    public void clearClientData() {
        this.CURRENT_GUI_NAME = null;
        this.CURRENT_SCREEN = null;
        this.CURRENT_GUI_CLASS = null;
        this.setInUse(false);
        CraftPresence.CLIENT.removeArguments("screen", "data.screen");
        CraftPresence.CLIENT.clearOverride("screen.message", "screen.icon");
    }

    @Override
    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.advancedSettings.enablePerGui : this.enabled;
        this.isFocused = CraftPresence.instance.field_71462_r != null && CraftPresence.instance.field_71415_G;
        boolean bl = needsUpdate = this.enabled && !this.hasScanned;
        if (needsUpdate) {
            new Thread(this::getAllData, "CraftPresence-Screen-Lookup").start();
            this.hasScanned = true;
        }
        if (this.enabled) {
            if (CraftPresence.instance.field_71462_r != null) {
                this.setInUse(true);
                this.updateData();
            } else if (this.isInUse()) {
                this.clearClientData();
            }
        } else if (this.isInUse()) {
            this.emptyData();
        }
        if (this.configGUIOpened && !(CraftPresence.instance.field_71462_r instanceof ExtendedScreen)) {
            this.configGUIOpened = false;
        }
    }

    public void openScreen(GuiScreen targetScreen) {
        CraftPresence.instance.func_152344_a(() -> CraftPresence.instance.func_147108_a(targetScreen));
    }

    @Override
    public void updateData() {
        if (CraftPresence.instance.field_71462_r == null) {
            this.clearClientData();
        } else {
            GuiScreen newScreen = CraftPresence.instance.field_71462_r;
            Class<?> newScreenClass = newScreen.getClass();
            String newScreenName = MappingUtils.getClassName(newScreen);
            if (!(newScreen.equals(this.CURRENT_SCREEN) && newScreenClass.equals(this.CURRENT_GUI_CLASS) && newScreenName.equals(this.CURRENT_GUI_NAME))) {
                this.CURRENT_SCREEN = newScreen;
                this.CURRENT_GUI_CLASS = newScreenClass;
                this.CURRENT_GUI_NAME = newScreenName;
                if (!this.GUI_NAMES.contains(newScreenName)) {
                    this.GUI_NAMES.add(newScreenName);
                }
                if (!this.GUI_CLASSES.containsKey(newScreenName)) {
                    this.GUI_CLASSES.put(newScreenName, newScreenClass);
                }
                this.updatePresence();
            }
        }
    }

    @Override
    public void getAllData() {
        ArrayList searchClasses = Lists.newArrayList((Object[])new Class[]{GuiScreen.class, GuiContainer.class});
        for (Class<?> classObj : FileUtils.getClassNamesMatchingSuperType(searchClasses, CraftPresence.CONFIG.advancedSettings.includeExtraGuiClasses, new String[0])) {
            String screenName = MappingUtils.getClassName(classObj);
            if (!this.GUI_NAMES.contains(screenName)) {
                this.GUI_NAMES.add(screenName);
            }
            if (this.GUI_CLASSES.containsKey(screenName)) continue;
            this.GUI_CLASSES.put(screenName, classObj);
        }
        for (String guiEntry : CraftPresence.CONFIG.advancedSettings.guiSettings.guiData.keySet()) {
            if (StringUtils.isNullOrEmpty(guiEntry) || this.GUI_NAMES.contains(guiEntry)) continue;
            this.GUI_NAMES.add(guiEntry);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean isInUse() {
        return this.isInUse;
    }

    @Override
    public void setInUse(boolean state) {
        this.isInUse = state;
    }

    @Override
    public boolean canBeLoaded() {
        return true;
    }

    @Override
    public void updatePresence() {
        ModuleData defaultData = CraftPresence.CONFIG.advancedSettings.guiSettings.guiData.get("default");
        ModuleData currentData = CraftPresence.CONFIG.advancedSettings.guiSettings.guiData.get(this.CURRENT_GUI_NAME);
        String defaultMessage = Config.isValidProperty(defaultData, "textOverride") ? defaultData.getTextOverride() : "";
        String currentMessage = Config.isValidProperty(currentData, "textOverride") ? currentData.getTextOverride() : defaultMessage;
        String defaultIcon = Config.isValidProperty(defaultData, "iconOverride") ? defaultData.getIconOverride() : this.CURRENT_GUI_NAME;
        String currentIcon = Config.isValidProperty(currentData, "iconOverride") ? currentData.getIconOverride() : defaultIcon;
        String formattedIcon = CraftPresence.CLIENT.imageOf("screen.icon", true, currentIcon, CraftPresence.CONFIG.advancedSettings.guiSettings.fallbackGuiIcon);
        CraftPresence.CLIENT.syncArgument("screen.default.icon", CraftPresence.CONFIG.advancedSettings.guiSettings.fallbackGuiIcon);
        CraftPresence.CLIENT.syncArgument("data.screen.instance", this.CURRENT_SCREEN);
        CraftPresence.CLIENT.syncArgument("screen.name", this.CURRENT_GUI_NAME);
        CraftPresence.CLIENT.syncArgument("data.screen.class", this.CURRENT_GUI_CLASS);
        CraftPresence.CLIENT.syncOverride(currentData != null ? currentData : defaultData, "screen.message", "screen.icon");
        CraftPresence.CLIENT.syncArgument("screen.message", currentMessage);
        CraftPresence.CLIENT.syncArgument("screen.icon", formattedIcon);
        CraftPresence.CLIENT.syncTimestamp("data.screen.time");
    }

    public void drawMultiLineString(List<String> textToInput, int posX, int posY, int screenWidth, int screenHeight, int maxTextWidth, FontRenderer fontRenderer, boolean withBackground) {
        if (CraftPresence.CONFIG.advancedSettings.renderTooltips && !ModUtils.forceBlockTooltipRendering && !textToInput.isEmpty() && fontRenderer != null) {
            ArrayList textLines = textToInput;
            int tooltipTextWidth = 0;
            for (String textLine : textLines) {
                int textLineWidth = fontRenderer.func_78256_a(textLine);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            int titleLinesCount = 1;
            int tooltipX = posX + 12;
            if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = posX - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = posX > screenWidth / 2 ? posX - 12 - 8 : screenWidth - 16 - posX;
                needsWrap = true;
            }
            if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList wrappedTextLines = Lists.newArrayList();
                for (int i = 0; i < textLines.size(); ++i) {
                    String textLine = textLines.get(i);
                    List<String> wrappedLine = StringUtils.splitTextByNewLine(GuiUtils.wrapFormattedStringToWidth(fontRenderer, textLine, tooltipTextWidth));
                    if (i == 0) {
                        titleLinesCount = wrappedLine.size();
                    }
                    for (String line : wrappedLine) {
                        int lineWidth = fontRenderer.func_78256_a(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add(line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = posX > screenWidth / 2 ? posX - 16 - tooltipTextWidth : posX + 12;
            }
            int tooltipY = posY - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > titleLinesCount) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY < 4) {
                tooltipY = 4;
            } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 4;
            }
            if (withBackground) {
                String borderColor;
                boolean usingExternalTexture;
                String backgroundColor;
                GL11.glDisable((int)2929);
                int zLevel = 300;
                if (StringUtils.isValidColorCode(CraftPresence.CONFIG.accessibilitySettings.tooltipBackgroundColor)) {
                    backgroundColor = CraftPresence.CONFIG.accessibilitySettings.tooltipBackgroundColor.length() == 6 ? "#" + CraftPresence.CONFIG.accessibilitySettings.tooltipBackgroundColor : (CraftPresence.CONFIG.accessibilitySettings.tooltipBackgroundColor.startsWith("0x") ? Long.toString(Long.decode(CraftPresence.CONFIG.accessibilitySettings.tooltipBackgroundColor).intValue()) : CraftPresence.CONFIG.accessibilitySettings.tooltipBackgroundColor);
                    this.drawGradientRect(300.0f, tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, backgroundColor, backgroundColor);
                    this.drawGradientRect(300.0f, tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, backgroundColor, backgroundColor);
                    this.drawGradientRect(300.0f, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
                    this.drawGradientRect(300.0f, tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
                    this.drawGradientRect(300.0f, tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
                } else {
                    ResourceLocation backGroundTexture;
                    usingExternalTexture = ImageUtils.isExternalImage(CraftPresence.CONFIG.accessibilitySettings.tooltipBackgroundColor);
                    double widthDivider = 32.0;
                    double heightDivider = 32.0;
                    if (!usingExternalTexture) {
                        backgroundColor = CraftPresence.CONFIG.accessibilitySettings.tooltipBackgroundColor.contains(":") && !CraftPresence.CONFIG.accessibilitySettings.tooltipBackgroundColor.startsWith(":") ? CraftPresence.CONFIG.accessibilitySettings.tooltipBackgroundColor : (CraftPresence.CONFIG.accessibilitySettings.tooltipBackgroundColor.startsWith(":") ? CraftPresence.CONFIG.accessibilitySettings.tooltipBackgroundColor.substring(1) : "minecraft:" + CraftPresence.CONFIG.accessibilitySettings.tooltipBackgroundColor);
                        if (backgroundColor.contains(":")) {
                            String[] splitInput = backgroundColor.split(":", 2);
                            backGroundTexture = new ResourceLocation(splitInput[0], splitInput[1]);
                        } else {
                            backGroundTexture = new ResourceLocation(backgroundColor);
                        }
                    } else {
                        String formattedConvertedName = CraftPresence.CONFIG.accessibilitySettings.tooltipBackgroundColor.replaceFirst("file://", "");
                        String[] urlBits = formattedConvertedName.trim().split("/");
                        String textureName = urlBits[urlBits.length - 1].trim();
                        backGroundTexture = ImageUtils.getTextureFromUrl(textureName, CraftPresence.CONFIG.accessibilitySettings.tooltipBackgroundColor.toLowerCase().startsWith("file://") ? new File(formattedConvertedName) : formattedConvertedName);
                        widthDivider = tooltipTextWidth + 8;
                        heightDivider = tooltipHeight + 8;
                    }
                    this.drawTextureRect(300.0, tooltipX - 4, tooltipY - 4, tooltipTextWidth + 8, tooltipHeight + 8, 0.0, widthDivider, heightDivider, false, backGroundTexture);
                }
                if (StringUtils.isValidColorCode(CraftPresence.CONFIG.accessibilitySettings.tooltipBorderColor)) {
                    borderColor = CraftPresence.CONFIG.accessibilitySettings.tooltipBorderColor.length() == 6 ? "#" + CraftPresence.CONFIG.accessibilitySettings.tooltipBorderColor : (CraftPresence.CONFIG.accessibilitySettings.tooltipBorderColor.startsWith("0x") ? Long.toString(Long.decode(CraftPresence.CONFIG.accessibilitySettings.tooltipBorderColor).intValue()) : CraftPresence.CONFIG.accessibilitySettings.tooltipBorderColor);
                    int borderColorCode = borderColor.startsWith("#") ? StringUtils.getColorFromHex(borderColor).getRGB() : Integer.parseInt(borderColor);
                    String borderColorEnd = Integer.toString((borderColorCode & 0xFEFEFE) >> 1 | borderColorCode & 0xFF000000);
                    this.drawGradientRect(300.0f, tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, borderColor, borderColorEnd);
                    this.drawGradientRect(300.0f, tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, borderColor, borderColorEnd);
                    this.drawGradientRect(300.0f, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, borderColor, borderColor);
                    this.drawGradientRect(300.0f, tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, borderColorEnd, borderColorEnd);
                } else {
                    ResourceLocation borderTexture;
                    usingExternalTexture = ImageUtils.isExternalImage(CraftPresence.CONFIG.accessibilitySettings.tooltipBorderColor);
                    if (!usingExternalTexture) {
                        borderColor = CraftPresence.CONFIG.accessibilitySettings.tooltipBorderColor.contains(":") && !CraftPresence.CONFIG.accessibilitySettings.tooltipBorderColor.startsWith(":") ? CraftPresence.CONFIG.accessibilitySettings.tooltipBorderColor : (CraftPresence.CONFIG.accessibilitySettings.tooltipBorderColor.startsWith(":") ? CraftPresence.CONFIG.accessibilitySettings.tooltipBorderColor.substring(1) : "minecraft:" + CraftPresence.CONFIG.accessibilitySettings.tooltipBorderColor);
                        if (borderColor.contains(":")) {
                            String[] splitInput = borderColor.split(":", 2);
                            borderTexture = new ResourceLocation(splitInput[0], splitInput[1]);
                        } else {
                            borderTexture = new ResourceLocation(borderColor);
                        }
                    } else {
                        String formattedConvertedName = CraftPresence.CONFIG.accessibilitySettings.tooltipBorderColor.replaceFirst("file://", "");
                        String[] urlBits = formattedConvertedName.trim().split("/");
                        String textureName = urlBits[urlBits.length - 1].trim();
                        borderTexture = ImageUtils.getTextureFromUrl(textureName, CraftPresence.CONFIG.accessibilitySettings.tooltipBorderColor.toLowerCase().startsWith("file://") ? new File(formattedConvertedName) : formattedConvertedName);
                    }
                    this.drawTextureRect(300.0, tooltipX - 3, tooltipY - 3, tooltipTextWidth + 5, 1.0, 0.0, usingExternalTexture ? (double)(tooltipTextWidth + 5) : 32.0, usingExternalTexture ? 1.0 : 32.0, false, borderTexture);
                    this.drawTextureRect(300.0, tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipTextWidth + 5, 1.0, 0.0, usingExternalTexture ? (double)(tooltipTextWidth + 5) : 32.0, usingExternalTexture ? 1.0 : 32.0, false, borderTexture);
                    this.drawTextureRect(300.0, tooltipX - 3, tooltipY - 3, 1.0, tooltipHeight + 5, 0.0, usingExternalTexture ? 1.0 : 32.0, usingExternalTexture ? (double)(tooltipHeight + 5) : 32.0, false, borderTexture);
                    this.drawTextureRect(300.0, tooltipX + tooltipTextWidth + 2, tooltipY - 3, 1.0, tooltipHeight + 6, 0.0, usingExternalTexture ? 1.0 : 32.0, usingExternalTexture ? (double)(tooltipHeight + 6) : 32.0, false, borderTexture);
                }
            }
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                String line = (String)textLines.get(lineNumber);
                fontRenderer.func_78261_a(line, tooltipX, tooltipY, -1);
                if (lineNumber + 1 == titleLinesCount) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            if (withBackground) {
                GL11.glEnable((int)2929);
            }
        }
    }

    public void drawMultiLineString(List<String> textToInput, int posX, int posY, ExtendedScreen screenInstance, boolean withBackground) {
        this.drawMultiLineString(textToInput, posX, posY, screenInstance.getScreenWidth(), screenInstance.getScreenHeight(), screenInstance.getWrapWidth(), screenInstance.getFontRenderer(), withBackground);
    }

    public void drawMultiLineString(List<String> textToInput, ExtendedScreen screenInstance, boolean withBackground) {
        this.drawMultiLineString(textToInput, screenInstance.getMouseX(), screenInstance.getMouseY(), screenInstance, withBackground);
    }

    public void drawBackground(double width, double height) {
        double widthDivider = 32.0;
        double heightDivider = 32.0;
        if (CraftPresence.instance.field_71441_e != null) {
            this.drawGradientRect(300.0f, 0.0, 0.0, width, height, "-1072689136", "-804253680");
        } else {
            String backgroundCode = CraftPresence.CONFIG.accessibilitySettings.guiBackgroundColor;
            if (StringUtils.isValidColorCode(backgroundCode)) {
                this.drawGradientRect(300.0f, 0.0, 0.0, width, height, backgroundCode, backgroundCode);
            } else {
                ResourceLocation texLocation;
                boolean usingExternalTexture = ImageUtils.isExternalImage(backgroundCode);
                if (!usingExternalTexture) {
                    if (backgroundCode.contains(":")) {
                        String[] splitInput = backgroundCode.split(":", 2);
                        texLocation = new ResourceLocation(splitInput[0], splitInput[1]);
                    } else {
                        texLocation = new ResourceLocation(backgroundCode);
                    }
                } else {
                    String formattedConvertedName = backgroundCode.replaceFirst("file://", "");
                    String[] urlBits = formattedConvertedName.trim().split("/");
                    String textureName = urlBits[urlBits.length - 1].trim();
                    texLocation = ImageUtils.getTextureFromUrl(textureName, backgroundCode.toLowerCase().startsWith("file://") ? new File(formattedConvertedName) : formattedConvertedName);
                    widthDivider = width;
                    heightDivider = height;
                }
                this.drawTextureRect(0.0, 0.0, 0.0, width, height, 0.0, widthDivider, heightDivider, CraftPresence.CONFIG.accessibilitySettings.showBackgroundAsDark, texLocation);
            }
        }
    }

    public void renderSlider(int x, int y, int u, int v, int width, int height, double zLevel, ResourceLocation texLocation) {
        try {
            if (texLocation != null) {
                CraftPresence.instance.func_110434_K().func_110577_a(texLocation);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(x, y, u, v, width, height, zLevel);
        this.drawTexturedModalRect(x + 4, y, u + 196, v, width, height, zLevel);
    }

    public void renderButton(int x, int y, int width, int height, int hoverState, double zLevel, ResourceLocation texLocation) {
        try {
            if (texLocation != null) {
                CraftPresence.instance.func_110434_K().func_110577_a(texLocation);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        int v = 46 + hoverState * 20;
        int xOffset = width / 2;
        this.drawTexturedModalRect(x, y, 0, v, xOffset, height, zLevel);
        this.drawTexturedModalRect(x + xOffset, y, 200 - xOffset, v, xOffset, height, zLevel);
        GL11.glDisable((int)3042);
    }

    public void drawTextureRect(double zLevel, double xPos, double yPos, double width, double height, double tint, ResourceLocation texLocation) {
        this.drawTextureRect(zLevel, xPos, yPos, width, height, tint, 32.0, 32.0, false, texLocation);
    }

    public void drawTextureRect(double zLevel, double xPos, double yPos, double width, double height, double tint, double widthDivider, double heightDivider, boolean shouldBeDark, ResourceLocation texLocation) {
        try {
            if (texLocation != null) {
                CraftPresence.instance.func_110434_K().func_110577_a(texLocation);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78378_d(shouldBeDark ? 0x404040 : 0xFFFFFF);
        tessellator.func_78374_a(xPos, yPos + height, zLevel, 0.0, height / heightDivider + tint);
        tessellator.func_78374_a(xPos + width, yPos + height, zLevel, width / widthDivider, height / heightDivider + tint);
        tessellator.func_78374_a(xPos + width, yPos, zLevel, width / widthDivider, tint);
        tessellator.func_78374_a(xPos, yPos, zLevel, 0.0, tint);
        tessellator.func_78381_a();
    }

    public void drawGradientRect(float zLevel, double left, double top, double right, double bottom, String startColorCode, String endColorCode) {
        Color startColorObj = null;
        Color endColorObj = null;
        int startColor = 0xFFFFFF;
        int endColor = 0xFFFFFF;
        if (!StringUtils.isNullOrEmpty(startColorCode)) {
            if (startColorCode.startsWith("#")) {
                startColorObj = StringUtils.getColorFromHex(startColorCode);
                endColorObj = !StringUtils.isNullOrEmpty(endColorCode) && endColorCode.startsWith("#") ? StringUtils.getColorFromHex(endColorCode) : startColorObj;
            } else {
                Pair<Boolean, Integer> startColorData = StringUtils.getValidInteger(startColorCode);
                Pair<Boolean, Integer> endColorData = StringUtils.getValidInteger(endColorCode);
                if (startColorData.getFirst().booleanValue() || endColorData.getFirst().booleanValue()) {
                    startColor = startColorData.getFirst() != false ? startColorData.getSecond() : endColor;
                    endColor = endColorData.getFirst() != false ? endColorData.getSecond() : startColor;
                }
            }
        }
        int startColorInstance = startColorObj != null ? startColorObj.getRGB() : startColor;
        int endColorInstance = endColorObj != null ? endColorObj.getRGB() : endColor;
        float startAlpha = (float)(startColorInstance >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColorInstance >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColorInstance >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColorInstance & 0xFF) / 255.0f;
        float endAlpha = (float)(endColorInstance >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColorInstance >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColorInstance >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColorInstance & 0xFF) / 255.0f;
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(startRed, startGreen, startBlue, startAlpha);
        tessellator.func_78377_a(right, top, (double)zLevel);
        tessellator.func_78377_a(left, top, (double)zLevel);
        tessellator.func_78369_a(endRed, endGreen, endBlue, endAlpha);
        tessellator.func_78377_a(left, bottom, (double)zLevel);
        tessellator.func_78377_a(right, bottom, (double)zLevel);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
    }

    public void drawContinuousTexturedBox(Pair<Integer, Integer> positionData, Pair<Integer, Integer> uVLevels, Pair<Integer, Integer> screenDimensions, Pair<Integer, Integer> textureDimensions, Pair<Integer, Integer> verticalBorderData, Pair<Integer, Integer> sideBorderData, double zLevel, ResourceLocation texLocation) {
        try {
            if (texLocation != null) {
                CraftPresence.instance.func_110434_K().func_110577_a(texLocation);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        int x = positionData.getFirst();
        int y = positionData.getSecond();
        int u = uVLevels.getFirst();
        int v = uVLevels.getSecond();
        int width = screenDimensions.getFirst();
        int height = screenDimensions.getSecond();
        int textureWidth = textureDimensions.getFirst();
        int textureHeight = textureDimensions.getSecond();
        int topBorder = verticalBorderData.getFirst();
        int bottomBorder = verticalBorderData.getSecond();
        int leftBorder = sideBorderData.getFirst();
        int rightBorder = sideBorderData.getSecond();
        int fillerWidth = textureWidth - leftBorder - rightBorder;
        int fillerHeight = textureHeight - topBorder - bottomBorder;
        int canvasWidth = width - leftBorder - rightBorder;
        int canvasHeight = height - topBorder - bottomBorder;
        int xPasses = canvasWidth / fillerWidth;
        int remainderWidth = canvasWidth % fillerWidth;
        int yPasses = canvasHeight / fillerHeight;
        int remainderHeight = canvasHeight % fillerHeight;
        this.drawTexturedModalRect(x, y, u, v, leftBorder, topBorder, zLevel);
        this.drawTexturedModalRect(x + leftBorder + canvasWidth, y, u + leftBorder + fillerWidth, v, rightBorder, topBorder, zLevel);
        this.drawTexturedModalRect(x, y + topBorder + canvasHeight, u, v + topBorder + fillerHeight, leftBorder, bottomBorder, zLevel);
        this.drawTexturedModalRect(x + leftBorder + canvasWidth, y + topBorder + canvasHeight, u + leftBorder + fillerWidth, v + topBorder + fillerHeight, rightBorder, bottomBorder, zLevel);
        for (int i = 0; i < xPasses + (remainderWidth > 0 ? 1 : 0); ++i) {
            this.drawTexturedModalRect(x + leftBorder + i * fillerWidth, y, u + leftBorder, v, i == xPasses ? remainderWidth : fillerWidth, topBorder, zLevel);
            this.drawTexturedModalRect(x + leftBorder + i * fillerWidth, y + topBorder + canvasHeight, u + leftBorder, v + topBorder + fillerHeight, i == xPasses ? remainderWidth : fillerWidth, bottomBorder, zLevel);
            for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
                this.drawTexturedModalRect(x + leftBorder + i * fillerWidth, y + topBorder + j * fillerHeight, u + leftBorder, v + topBorder, i == xPasses ? remainderWidth : fillerWidth, j == yPasses ? remainderHeight : fillerHeight, zLevel);
            }
        }
        for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
            this.drawTexturedModalRect(x, y + topBorder + j * fillerHeight, u, v + topBorder, leftBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel);
            this.drawTexturedModalRect(x + leftBorder + canvasWidth, y + topBorder + j * fillerHeight, u + leftBorder + fillerWidth, v + topBorder, rightBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel);
        }
    }

    public int getButtonY(int order) {
        return 40 + 25 * (order - 1);
    }

    public int getButtonY(int order, int offset, boolean appendByOrder) {
        return this.getButtonY(order) + offset * (appendByOrder ? order : 1);
    }

    public int getButtonY(int order, int offset) {
        return this.getButtonY(order, offset, false);
    }
}

