/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.commands;

import com.google.common.collect.Lists;
import external.com.jagrosh.discordipc.IPCClient;
import external.org.meteordev.starscript.compiler.Expr;
import external.org.meteordev.starscript.value.Value;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.impl.discord.DiscordStatus;
import forge.com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.FileUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAsset;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.SelectorGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.gui.GuiScreen;

public class CommandsGui
extends ExtendedScreen {
    private static String[] executionCommandArgs;
    public ExtendedButtonControl proceedButton;
    private ExtendedTextControl commandInput;
    private String executionString;
    private boolean blockInteractions = false;
    private String[] commandArgs;
    private String[] filteredCommandArgs;
    private List<String> tabCompletions = Lists.newArrayList();

    public CommandsGui(GuiScreen parentScreen) {
        super(parentScreen);
        this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.usage.main", new Object[0]);
    }

    public static void executeCommand(String ... args) {
        executionCommandArgs = args;
    }

    private static List<String> getListOfStringsMatchingLastWord(String[] inputArgs, Collection<?> possibleCompletions) {
        String s = inputArgs[inputArgs.length - 1];
        ArrayList list = Lists.newArrayList();
        if (!possibleCompletions.isEmpty()) {
            for (Object object : possibleCompletions) {
                String str;
                if (object == null || !CommandsGui.doesStringStartWith(s, str = String.valueOf(object))) continue;
                list.add(str);
            }
        }
        return list;
    }

    private static boolean doesStringStartWith(String original, String region) {
        return region.regionMatches(true, 0, original, 0, original.length());
    }

    @Override
    public void initializeUi() {
        this.commandInput = this.addControl(new ExtendedTextControl(this.getFontRenderer(), 115, this.getScreenHeight() - 30, this.getScreenWidth() - 120, 20));
        this.commandInput.setControlMaxLength(512);
        this.proceedButton = this.addControl(new ExtendedButtonControl(10, this.getScreenHeight() - 30, 100, 20, "gui.config.message.button.back", () -> CraftPresence.GUIS.openScreen(this.parentScreen), new String[0]));
        super.initializeUi();
    }

    @Override
    public void preRender() {
        String mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title.commands", new Object[0]);
        this.renderString(mainTitle, (float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(mainTitle) / 2.0f, 10.0f, 0xFFFFFF);
        this.proceedButton.setControlEnabled(!this.blockInteractions);
        this.commandInput.func_146184_c(!this.blockInteractions);
        if (!this.blockInteractions) {
            this.checkCommands();
        }
        CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(this.executionString), 25, 35, this, false);
    }

    private void checkCommands() {
        if (!StringUtils.isNullOrEmpty(this.commandInput.getControlMessage()) && this.commandInput.getControlMessage().startsWith("/")) {
            this.commandArgs = this.commandInput.getControlMessage().replace("/", "").split(" ");
            this.filteredCommandArgs = this.commandInput.getControlMessage().replace("/", "").replace("cp", "").replace("craftpresence", "").trim().split(" ");
            this.tabCompletions = this.getTabCompletions(this.filteredCommandArgs);
        }
        if (executionCommandArgs != null) {
            if (executionCommandArgs.length == 0 || executionCommandArgs[0].equalsIgnoreCase("help") || executionCommandArgs[0].equalsIgnoreCase("?") || executionCommandArgs[0].equalsIgnoreCase("")) {
                this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.usage.main", new Object[0]);
            } else if (!StringUtils.isNullOrEmpty(executionCommandArgs[0])) {
                if (executionCommandArgs[0].equalsIgnoreCase("request")) {
                    if (executionCommandArgs.length == 1) {
                        if (CraftPresence.CLIENT.STATUS == DiscordStatus.JoinRequest && CraftPresence.CLIENT.REQUESTER_USER != null) {
                            if (CraftPresence.CONFIG.generalSettings.enableJoinRequests) {
                                this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.request.info", CraftPresence.CLIENT.REQUESTER_USER.getName(), CraftPresence.SYSTEM.TIMER);
                                CraftPresence.CLIENT.awaitingReply = true;
                            } else {
                                CraftPresence.CLIENT.ipcInstance.respondToJoinRequest(CraftPresence.CLIENT.REQUESTER_USER, IPCClient.ApprovalMode.DENY);
                                CraftPresence.CLIENT.STATUS = DiscordStatus.Ready;
                                CraftPresence.SYSTEM.TIMER = 0;
                                CraftPresence.CLIENT.awaitingReply = false;
                            }
                        } else {
                            this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.request.none", new Object[0]);
                            CraftPresence.CLIENT.awaitingReply = false;
                        }
                    } else if (!StringUtils.isNullOrEmpty(executionCommandArgs[1])) {
                        if (CraftPresence.CLIENT.awaitingReply && CraftPresence.CONFIG.generalSettings.enableJoinRequests) {
                            if (executionCommandArgs[1].equalsIgnoreCase("accept")) {
                                this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.request.accept", CraftPresence.CLIENT.REQUESTER_USER.getName());
                                CraftPresence.CLIENT.ipcInstance.respondToJoinRequest(CraftPresence.CLIENT.REQUESTER_USER, IPCClient.ApprovalMode.ACCEPT);
                                CraftPresence.CLIENT.STATUS = DiscordStatus.Ready;
                                CraftPresence.SYSTEM.TIMER = 0;
                                CraftPresence.CLIENT.awaitingReply = false;
                            } else if (executionCommandArgs[1].equalsIgnoreCase("deny")) {
                                this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.request.denied", CraftPresence.CLIENT.REQUESTER_USER.getName());
                                CraftPresence.CLIENT.ipcInstance.respondToJoinRequest(CraftPresence.CLIENT.REQUESTER_USER, IPCClient.ApprovalMode.DENY);
                                CraftPresence.CLIENT.STATUS = DiscordStatus.Ready;
                                CraftPresence.SYSTEM.TIMER = 0;
                                CraftPresence.CLIENT.awaitingReply = false;
                            } else {
                                this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.unrecognized", new Object[0]);
                            }
                        } else {
                            this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.request.none", new Object[0]);
                        }
                    }
                } else if (executionCommandArgs[0].equalsIgnoreCase("export")) {
                    String clientId = CraftPresence.CONFIG.generalSettings.clientId;
                    boolean doFullCopy = false;
                    String urlMeta = "";
                    if (executionCommandArgs.length == 1) {
                        this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.usage.export", clientId, false);
                    } else if (!StringUtils.isNullOrEmpty(executionCommandArgs[1])) {
                        if (executionCommandArgs[1].equalsIgnoreCase("assets")) {
                            if (executionCommandArgs.length >= 3 && executionCommandArgs.length <= 5) {
                                for (int i = 2; i < executionCommandArgs.length; ++i) {
                                    if (StringUtils.isValidBoolean(executionCommandArgs[i])) {
                                        doFullCopy = Boolean.parseBoolean(executionCommandArgs[i]);
                                        continue;
                                    }
                                    if (DiscordAssetUtils.isValidId(executionCommandArgs[i])) {
                                        clientId = executionCommandArgs[i];
                                        continue;
                                    }
                                    Matcher matcher = Pattern.compile("\"(.*?)\"").matcher(this.commandInput.getControlMessage());
                                    if (!matcher.find()) continue;
                                    urlMeta = matcher.group(1);
                                }
                            } else {
                                this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.unrecognized", new Object[0]);
                            }
                            this.exportAssets(clientId, doFullCopy, urlMeta);
                        } else {
                            this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.unrecognized", new Object[0]);
                        }
                    }
                } else if (executionCommandArgs[0].equalsIgnoreCase("compile")) {
                    if (executionCommandArgs.length == 1) {
                        this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.usage.compile", new Object[0]);
                    } else {
                        Matcher matcher = Pattern.compile("\"(.*?)\"").matcher(this.commandInput.getControlMessage());
                        if (matcher.find()) {
                            String contents = matcher.group(1);
                            StringBuilder out = new StringBuilder();
                            Supplier<Value> data = CraftPresence.CLIENT.getCompileResult(contents, out, new Expr.Visitor[0]);
                            String value = data.get().toString();
                            int length = StringUtils.getBytes(value, "UTF-8").length;
                            this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.compile", value, length, out.toString().replace("\n", "\\n"));
                        } else {
                            this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.unrecognized", new Object[0]);
                        }
                    }
                } else if (executionCommandArgs[0].equalsIgnoreCase("search")) {
                    if (executionCommandArgs.length == 1) {
                        this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.usage.search", new Object[0]);
                    } else if (!StringUtils.isNullOrEmpty(executionCommandArgs[1])) {
                        ArrayList results = Lists.newArrayList(CraftPresence.CLIENT.getArgumentEntries(executionCommandArgs[1]));
                        if (!results.isEmpty()) {
                            CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.view.items", new Object[0]), results, null, null, false, false, ScrollableListControl.RenderType.Placeholder.setCanRenderImage(false), null, null));
                        } else {
                            this.executionString = ModUtils.TRANSLATOR.translate("gui.config.message.empty.list", new Object[0]);
                        }
                    }
                } else if (executionCommandArgs[0].equalsIgnoreCase("reload")) {
                    this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.reload", new Object[0]);
                    CommandUtils.reloadData(true);
                    this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.reload.complete", new Object[0]);
                } else if (executionCommandArgs[0].equalsIgnoreCase("shutdown")) {
                    this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.shutdown.pre", new Object[0]);
                    CraftPresence.CLIENT.shutDown();
                    this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.shutdown.post", new Object[0]);
                } else if (executionCommandArgs[0].equalsIgnoreCase("reboot")) {
                    this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.reboot.pre", new Object[0]);
                    CommandUtils.rebootRPC(true);
                    this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.reboot.post", new Object[0]);
                } else if (executionCommandArgs[0].equalsIgnoreCase("view")) {
                    if (executionCommandArgs.length == 1) {
                        this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.usage.view", new Object[0]);
                    } else if (!StringUtils.isNullOrEmpty(executionCommandArgs[1])) {
                        if (executionCommandArgs[1].equalsIgnoreCase("placeholders")) {
                            CommandsGui.executeCommand("search", "all");
                            return;
                        }
                        if (executionCommandArgs[1].equalsIgnoreCase("items")) {
                            if (CraftPresence.TILE_ENTITIES.enabled) {
                                CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.view.items", new Object[0]), CraftPresence.TILE_ENTITIES.TILE_ENTITY_NAMES, null, null, false, false, ScrollableListControl.RenderType.None, null, null));
                            } else {
                                this.executionString = ModUtils.TRANSLATOR.translate("gui.config.message.hover.access", ModUtils.TRANSLATOR.translate("gui.config.name.advanced.enable_per_item", new Object[0]));
                            }
                        } else if (executionCommandArgs[1].equalsIgnoreCase("entities")) {
                            if (CraftPresence.ENTITIES.enabled) {
                                CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.view.entities", new Object[0]), CraftPresence.ENTITIES.ENTITY_NAMES, null, null, false, false, ScrollableListControl.RenderType.EntityData, null, null));
                            } else {
                                this.executionString = ModUtils.TRANSLATOR.translate("gui.config.message.hover.access", ModUtils.TRANSLATOR.translate("gui.config.name.advanced.enable_per_entity", new Object[0]));
                            }
                        } else if (executionCommandArgs[1].equalsIgnoreCase("servers")) {
                            if (CraftPresence.SERVER.enabled) {
                                CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.view.servers", new Object[0]), CraftPresence.SERVER.knownAddresses, null, null, false, false, ScrollableListControl.RenderType.ServerData, null, null));
                            } else {
                                this.executionString = ModUtils.TRANSLATOR.translate("gui.config.message.hover.access", ModUtils.TRANSLATOR.translate("gui.config.name.general.detect_world_data", new Object[0]));
                            }
                        } else if (executionCommandArgs[1].equalsIgnoreCase("screens")) {
                            if (CraftPresence.GUIS.enabled) {
                                CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.view.guis", new Object[0]), CraftPresence.GUIS.GUI_NAMES, null, null, false, false, null, null, null));
                            } else {
                                this.executionString = ModUtils.TRANSLATOR.translate("gui.config.message.hover.access", ModUtils.TRANSLATOR.translate("gui.config.name.advanced.enable_per_gui", new Object[0]));
                            }
                        } else if (executionCommandArgs[1].equalsIgnoreCase("biomes")) {
                            if (CraftPresence.BIOMES.enabled) {
                                CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.view.biomes", new Object[0]), CraftPresence.BIOMES.BIOME_NAMES, null, null, false, false, null, null, null));
                            } else {
                                this.executionString = ModUtils.TRANSLATOR.translate("gui.config.message.hover.access", ModUtils.TRANSLATOR.translate("gui.config.name.general.detect_biome_data", new Object[0]));
                            }
                        } else if (executionCommandArgs[1].equalsIgnoreCase("dimensions")) {
                            if (CraftPresence.DIMENSIONS.enabled) {
                                CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.view.dimensions", new Object[0]), CraftPresence.DIMENSIONS.DIMENSION_NAMES, null, null, false, false, null, null, null));
                            } else {
                                this.executionString = ModUtils.TRANSLATOR.translate("gui.config.message.hover.access", ModUtils.TRANSLATOR.translate("gui.config.name.general.detect_dimension_data", new Object[0]));
                            }
                        } else if (executionCommandArgs[1].equalsIgnoreCase("currentData")) {
                            this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.current_data", CraftPresence.CLIENT.CURRENT_USER.getName(), StringUtils.convertString(CraftPresence.CLIENT.DETAILS, "UTF-8", true), StringUtils.convertString(CraftPresence.CLIENT.GAME_STATE, "UTF-8", true), CraftPresence.CLIENT.START_TIMESTAMP, CraftPresence.CLIENT.CLIENT_ID, StringUtils.convertString(CraftPresence.CLIENT.LARGE_IMAGE_KEY, "UTF-8", true), StringUtils.convertString(CraftPresence.CLIENT.LARGE_IMAGE_TEXT, "UTF-8", true), StringUtils.convertString(CraftPresence.CLIENT.SMALL_IMAGE_KEY, "UTF-8", true), StringUtils.convertString(CraftPresence.CLIENT.SMALL_IMAGE_TEXT, "UTF-8", true), CraftPresence.CLIENT.PARTY_ID, CraftPresence.CLIENT.PARTY_SIZE, CraftPresence.CLIENT.PARTY_MAX, CraftPresence.CLIENT.PARTY_PRIVACY.name(), CraftPresence.CLIENT.JOIN_SECRET, CraftPresence.CLIENT.END_TIMESTAMP, CraftPresence.CLIENT.MATCH_SECRET, CraftPresence.CLIENT.SPECTATE_SECRET, CraftPresence.CLIENT.BUTTONS.toString(), CraftPresence.CLIENT.INSTANCE);
                        } else if (executionCommandArgs[1].equalsIgnoreCase("assets")) {
                            if (executionCommandArgs.length == 2) {
                                this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.usage.view.assets", new Object[0]);
                            } else if (!StringUtils.isNullOrEmpty(executionCommandArgs[2])) {
                                if (executionCommandArgs[2].equalsIgnoreCase("custom")) {
                                    CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.view.assets.custom", new Object[0]), DiscordAssetUtils.CUSTOM_ASSET_LIST.keySet(), null, null, false, false, ScrollableListControl.RenderType.CustomDiscordAsset, null, null));
                                } else if (executionCommandArgs[2].equalsIgnoreCase("all")) {
                                    CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.view.assets.all", new Object[0]), DiscordAssetUtils.ASSET_LIST.keySet(), null, null, false, false, ScrollableListControl.RenderType.DiscordAsset, null, null));
                                }
                            }
                        } else {
                            this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.unrecognized", new Object[0]);
                        }
                    }
                } else {
                    this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.unrecognized", new Object[0]);
                }
            } else {
                this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.logger.error.command", new Object[0]);
            }
        }
        executionCommandArgs = null;
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) {
        if (this.commandInput.isControlFocused() && this.commandInput.getControlMessage().startsWith("/") && this.commandArgs != null && this.commandArgs.length > 0 && (this.commandArgs[0].equalsIgnoreCase("cp") || this.commandArgs[0].equalsIgnoreCase("craftpresence"))) {
            if (keyCode == 15 && !this.tabCompletions.isEmpty()) {
                if (this.commandArgs.length > 1 && (this.filteredCommandArgs[this.filteredCommandArgs.length - 1].length() > 1 || this.filteredCommandArgs[this.filteredCommandArgs.length - 1].equalsIgnoreCase("?"))) {
                    this.commandInput.setControlMessage(this.commandInput.getControlMessage().replace(this.filteredCommandArgs[this.filteredCommandArgs.length - 1], this.tabCompletions.get(0)));
                }
            } else if (keyCode == 28 || keyCode == 156) {
                CommandsGui.executeCommand(this.filteredCommandArgs);
            }
        }
        if (!this.blockInteractions) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    private List<String> getTabCompletions(String[] args) {
        ArrayList completions = Lists.newArrayList();
        if (args.length == 1) {
            completions.add("?");
            completions.add("help");
            completions.add("compile");
            completions.add("search");
            completions.add("reload");
            completions.add("request");
            completions.add("export");
            completions.add("view");
            completions.add("reboot");
            completions.add("shutdown");
        } else if (args.length == 2) {
            if (args[0].equalsIgnoreCase("export")) {
                completions.add("assets");
            } else if (args[0].equalsIgnoreCase("search")) {
                completions.add("type:");
                completions.add("all");
            } else if (args[0].equalsIgnoreCase("view")) {
                completions.add("placeholders");
                completions.add("currentData");
                completions.add("assets");
                completions.add("dimensions");
                completions.add("biomes");
                completions.add("items");
                completions.add("entities");
                completions.add("servers");
                completions.add("screens");
            } else if (args[0].equalsIgnoreCase("request")) {
                completions.add("accept");
                completions.add("deny");
            }
        } else if (args.length == 3 && args[0].equalsIgnoreCase("view") && args[1].equalsIgnoreCase("assets")) {
            completions.add("all");
            completions.add("custom");
        }
        return CommandsGui.getListOfStringsMatchingLastWord(args, completions);
    }

    private void exportAssets(String clientId, boolean doFullCopy, String urlMeta) {
        new Thread(() -> {
            this.blockInteractions = true;
            DiscordAsset[] assetList = DiscordAssetUtils.loadAssets(clientId, false);
            OutputStream outputData = null;
            OutputStreamWriter outputStream = null;
            BufferedWriter bw = null;
            boolean hasError = false;
            if (assetList != null) {
                block18: {
                    String filePath = "craftpresence" + File.separator + "export" + File.separator + clientId + File.separator;
                    this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.export.pre", assetList.length, clientId, doFullCopy);
                    if (!doFullCopy) {
                        try {
                            File dataDir = new File(filePath + "downloads.txt");
                            if (!dataDir.getParentFile().exists() && !dataDir.getParentFile().mkdirs()) {
                                hasError = true;
                            }
                            outputData = Files.newOutputStream(dataDir.toPath(), new OpenOption[0]);
                            outputStream = new OutputStreamWriter(outputData, CraftPresence.CLIENT.ipcInstance.getEncoding());
                            bw = new BufferedWriter(outputStream);
                            bw.write("## Export Data => " + clientId);
                            bw.newLine();
                            bw.newLine();
                        }
                        catch (Exception ex) {
                            if (CommandUtils.isVerboseMode()) {
                                ex.printStackTrace();
                            }
                            hasError = true;
                        }
                    }
                    for (int i = 0; i < assetList.length; ++i) {
                        this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.export.progress", clientId, i + 1, assetList.length);
                        DiscordAsset asset = assetList[i];
                        String assetUrl = DiscordAssetUtils.getDiscordAssetUrl(clientId, asset.getId(), false) + urlMeta;
                        String assetName = asset.getName() + ".png";
                        if (doFullCopy) {
                            FileUtils.downloadFile(assetUrl, new File(filePath + assetName));
                            continue;
                        }
                        if (!hasError) {
                            try {
                                bw.write("* " + assetName + " => " + assetUrl);
                                bw.newLine();
                            }
                            catch (Exception ex) {
                                if (CommandUtils.isVerboseMode()) {
                                    ex.printStackTrace();
                                }
                                hasError = true;
                            }
                            continue;
                        }
                        this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.export.exception", clientId);
                    }
                    try {
                        if (bw != null) {
                            bw.close();
                        }
                        if (outputStream != null) {
                            outputStream.close();
                        }
                        if (outputData != null) {
                            outputData.close();
                        }
                    }
                    catch (Exception ex) {
                        ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.data.close", new Object[0]), new Object[0]);
                        if (!CommandUtils.isVerboseMode()) break block18;
                        ex.printStackTrace();
                    }
                }
                this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.export.post", assetList.length, clientId, doFullCopy);
            } else {
                this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.export.exception", clientId);
            }
            this.blockInteractions = false;
        }, "CraftPresence-Asset-Exporter").start();
    }
}

