/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.impl.Pair;
import forge.com.gitlab.cdagaming.craftpresence.impl.Tuple;
import forge.com.gitlab.cdagaming.craftpresence.integrations.FieldReflectionUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.FileUtils;
import java.awt.Color;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class StringUtils {
    public static final String UNKNOWN_BASE64_ID = "data:image/unknown;base64";
    public static final char COLOR_CHAR = '\u00a7';
    public static final String TOO_LARGE = "<...>";
    public static final Predicate<String> NULL_OR_EMPTY = StringUtils::isNullOrEmpty;
    public static final Pattern STRIP_COLOR_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    private static final Pattern BASE64_PATTERN = Pattern.compile("data:(?<type>.+?);base64,(?<data>.+)");
    private static final Pattern TRIMMED_UUID_PATTERN = Pattern.compile("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})");
    private static final Pattern FULL_UUID_PATTERN = Pattern.compile("(\\w{8})-(\\w{4})-(\\w{4})-(\\w{4})-(\\w{12})");
    private static final Pattern BRACKET_PATTERN = Pattern.compile("\\([^0-9]*\\d+[^0-9]*\\)");
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(.*?)\\s(.*?)");
    private static final Pattern ALPHANUMERIC_PATTERN = Pattern.compile(".*[a-zA-Z0-9].*");

    public static Color getColorFromHex(String hexColor) {
        try {
            if (hexColor.length() == 7 && !StringUtils.isNullOrEmpty(hexColor.substring(1))) {
                int r = Integer.valueOf(hexColor.substring(1, 3), 16);
                int g = Integer.valueOf(hexColor.substring(3, 5), 16);
                int b = Integer.valueOf(hexColor.substring(5, 7), 16);
                return new Color(r, g, b);
            }
            if (hexColor.length() == 6 && !hexColor.startsWith("#")) {
                int r = Integer.valueOf(hexColor.substring(0, 2), 16);
                int g = Integer.valueOf(hexColor.substring(2, 4), 16);
                int b = Integer.valueOf(hexColor.substring(4, 6), 16);
                return new Color(r, g, b);
            }
            return Color.white;
        }
        catch (Exception ex) {
            return Color.white;
        }
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    public static byte[] getBytes(String original, String encoding) {
        try {
            if (!StringUtils.isNullOrEmpty(encoding)) {
                return original.getBytes(encoding);
            }
            return original.getBytes();
        }
        catch (Exception ex) {
            return original.getBytes();
        }
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    public static String convertString(String original, String encoding, boolean decode) {
        try {
            if (decode) {
                return new String(StringUtils.getBytes(original, null), encoding);
            }
            return new String(StringUtils.getBytes(original, encoding));
        }
        catch (Exception ex) {
            return original;
        }
    }

    public static boolean isWithinValue(double value, double min, double max, boolean contains_min, boolean contains_max, boolean check_sanity) {
        if (check_sanity) {
            if (min > max) {
                min = max;
            }
            if (max < min) {
                max = min;
            }
            if (min < 0.0) {
                min = 0.0;
            }
            if (max < 0.0) {
                max = 0.0;
            }
        }
        if (!contains_min) {
            min += 1.0;
        }
        if (!contains_max) {
            max -= 1.0;
        }
        return value >= min && value <= max;
    }

    public static boolean isWithinValue(double value, double min, double max, boolean contains_min, boolean contains_max) {
        return StringUtils.isWithinValue(value, min, max, contains_min, contains_max, true);
    }

    public static boolean isWithinValue(double value, double min, double max) {
        return StringUtils.isWithinValue(value, min, max, false, false);
    }

    public static double roundDouble(double value, int places) {
        if (places < 0) {
            return value;
        }
        double x = Math.pow(10.0, places);
        return (double)Math.round(value * x) / x;
    }

    public static String getHexFromColor(Color color) {
        return "0x" + StringUtils.toSafeHexValue(color.getAlpha()) + StringUtils.toSafeHexValue(color.getRed()) + StringUtils.toSafeHexValue(color.getGreen()) + StringUtils.toSafeHexValue(color.getBlue());
    }

    private static String toSafeHexValue(int number) {
        StringBuilder builder = new StringBuilder(Integer.toHexString(number & 0xFF));
        while (builder.length() < 2) {
            builder.append("0");
        }
        return builder.toString().toUpperCase();
    }

    public static String getOrDefault(String primary, String secondary, Predicate<String> condition) {
        return condition.test(primary) ? primary : secondary;
    }

    public static String getOrDefault(String primary, String secondary) {
        return StringUtils.getOrDefault(primary, secondary, NULL_OR_EMPTY.negate());
    }

    public static String getOrDefault(String primary) {
        return StringUtils.getOrDefault(primary, "");
    }

    public static <T> void revlist(List<T> list) {
        if (list == null || list.size() <= 1) {
            return;
        }
        T value = list.remove(0);
        StringUtils.revlist(list);
        list.add(value);
    }

    public static Pair<String, List<String>> getMatches(String regexValue, Object original, int flags) {
        return original != null ? StringUtils.getMatches(regexValue, original.toString(), flags) : new Pair<String, List<String>>("", Lists.newArrayList());
    }

    public static Pair<String, List<String>> getMatches(String regexValue, Object original) {
        return StringUtils.getMatches(regexValue, original, 0);
    }

    public static Pair<String, List<String>> getMatches(String regexValue, String original, int flags) {
        ArrayList matches = Lists.newArrayList();
        if (!StringUtils.isNullOrEmpty(original)) {
            Pattern pattern = Pattern.compile(regexValue, flags);
            Matcher m = pattern.matcher(original);
            while (m.find()) {
                matches.add(m.group());
            }
        }
        return new Pair<String, List<String>>(original, matches);
    }

    public static Pair<String, List<String>> getMatches(String regexValue, String original) {
        return StringUtils.getMatches(regexValue, original, 0);
    }

    public static String removeMatches(Pair<String, List<String>> matchData, List<Pair<String, String>> parsedMatchData, int maxMatches) {
        String finalString = "";
        if (matchData != null) {
            finalString = matchData.getFirst();
            List<String> matchList = matchData.getSecond();
            if (!matchList.isEmpty()) {
                int foundMatches = 0;
                for (String match : matchList) {
                    boolean isValidScan = foundMatches >= maxMatches;
                    boolean alreadyRemoved = false;
                    if (parsedMatchData != null && !parsedMatchData.isEmpty()) {
                        for (Pair<String, String> parsedArgument : parsedMatchData) {
                            if (!parsedArgument.getFirst().equalsIgnoreCase(match) || !StringUtils.isNullOrEmpty(parsedArgument.getSecond())) continue;
                            finalString = finalString.replaceFirst(match, "");
                            alreadyRemoved = true;
                            break;
                        }
                    }
                    if (alreadyRemoved) continue;
                    if (isValidScan) {
                        finalString = finalString.replaceFirst(match, "");
                    }
                    ++foundMatches;
                }
            }
        }
        return finalString;
    }

    public static String replaceAnyCase(String source, String targetToReplace, String replaceWith) {
        if (!StringUtils.isNullOrEmpty(source)) {
            return Pattern.compile(targetToReplace, 82).matcher(source).replaceAll(Matcher.quoteReplacement(replaceWith));
        }
        return "";
    }

    @SafeVarargs
    public static String sequentialReplaceAnyCase(String source, Map<String, String> ... replaceArgs) {
        if (!StringUtils.isNullOrEmpty(source)) {
            String finalResult = source;
            for (Map<String, String> replaceData : replaceArgs) {
                if (replaceData.isEmpty()) continue;
                for (Map.Entry<String, String> replacementData : replaceData.entrySet()) {
                    finalResult = StringUtils.replaceAnyCase(finalResult, replacementData.getKey(), replacementData.getValue());
                }
            }
            return finalResult;
        }
        return "";
    }

    public static String minifyString(String source, int length) {
        if (!StringUtils.isNullOrEmpty(source)) {
            return length >= 0 ? source.substring(0, length) : source;
        }
        return "";
    }

    public static boolean isNullOrEmpty(String entry, boolean allowWhitespace) {
        if (entry != null) {
            entry = allowWhitespace ? entry : entry.trim();
        }
        return entry == null || entry.isEmpty() || entry.equalsIgnoreCase("null");
    }

    public static boolean isNullOrEmpty(String entry) {
        return StringUtils.isNullOrEmpty(entry, false);
    }

    public static boolean isValidBoolean(Object entry) {
        return entry != null && StringUtils.isValidBoolean(entry.toString());
    }

    public static boolean isValidBoolean(String entry) {
        return !StringUtils.isNullOrEmpty(entry) && (entry.equalsIgnoreCase("true") || entry.equalsIgnoreCase("false"));
    }

    public static boolean isValidColorCode(String entry) {
        return !StringUtils.isNullOrEmpty(entry) && (entry.startsWith("#") || entry.length() == 6 || entry.startsWith("0x") || StringUtils.getValidInteger(entry).getFirst() != false);
    }

    public static Pair<Boolean, Integer> getValidInteger(Object entry) {
        return entry != null ? StringUtils.getValidInteger(entry.toString()) : new Pair<Boolean, Integer>(false, 0);
    }

    public static Pair<Boolean, Integer> getValidInteger(String entry) {
        Pair<Boolean, Integer> finalSet = new Pair<Boolean, Integer>();
        if (!StringUtils.isNullOrEmpty(entry)) {
            try {
                finalSet.setSecond(Integer.parseInt(entry));
                finalSet.setFirst(true);
            }
            catch (Exception ex) {
                finalSet.setFirst(false);
            }
        } else {
            finalSet.setFirst(false);
        }
        return finalSet;
    }

    public static Pair<Boolean, Long> getValidLong(String entry) {
        Pair<Boolean, Long> finalSet = new Pair<Boolean, Long>();
        if (!StringUtils.isNullOrEmpty(entry)) {
            try {
                finalSet.setSecond(Long.parseLong(entry));
                finalSet.setFirst(true);
            }
            catch (Exception ex) {
                finalSet.setFirst(false);
            }
        } else {
            finalSet.setFirst(false);
        }
        return finalSet;
    }

    public static String formatAddress(String input, boolean returnPort) {
        if (!StringUtils.isNullOrEmpty(input)) {
            String[] formatted = input.split(":", 2);
            return !returnPort ? (StringUtils.elementExists(formatted, 0) ? formatted[0].trim() : "127.0.0.1") : (StringUtils.elementExists(formatted, 1) ? formatted[1].trim() : "25565");
        }
        return !returnPort ? "127.0.0.1" : "25565";
    }

    public static boolean containsWhitespace(String original) {
        return StringUtils.isNullOrEmpty(original) || WHITESPACE_PATTERN.matcher(original).find();
    }

    public static boolean containsAlphaNumeric(String original) {
        return !StringUtils.isNullOrEmpty(original) && ALPHANUMERIC_PATTERN.matcher(original).find();
    }

    public static String formatToCamel(String original) {
        if (StringUtils.isNullOrEmpty(original)) {
            return original;
        }
        String[] words = original.split("[\\W_]+");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            word = i == 0 ? (word.isEmpty() ? word : word.toLowerCase()) : (word.isEmpty() ? word : Character.toUpperCase(word.charAt(0)) + word.substring(1).toLowerCase());
            builder.append(word);
        }
        return builder.toString();
    }

    public static String formatAsIcon(String original, String whitespaceIndex) {
        String formattedKey = original;
        if (StringUtils.isNullOrEmpty(formattedKey)) {
            return formattedKey;
        }
        if (StringUtils.containsWhitespace(formattedKey)) {
            formattedKey = formattedKey.replaceAll("\\s+", whitespaceIndex);
        }
        if (formattedKey.contains("'")) {
            formattedKey = formattedKey.replaceAll("'", "");
        }
        if (formattedKey.contains(".")) {
            formattedKey = formattedKey.replaceAll("\\.", "_");
        }
        if (formattedKey.contains("(")) {
            formattedKey = formattedKey.replaceAll("\\(", "_");
        }
        if (formattedKey.contains(")")) {
            formattedKey = formattedKey.replaceAll("\\)", "_");
        }
        if (BRACKET_PATTERN.matcher(formattedKey).find()) {
            formattedKey = BRACKET_PATTERN.matcher(formattedKey).replaceAll("");
        }
        if (STRIP_COLOR_PATTERN.matcher(formattedKey).find()) {
            formattedKey = STRIP_COLOR_PATTERN.matcher(formattedKey).replaceAll("");
        }
        return formattedKey.toLowerCase().trim();
    }

    public static String formatAsIcon(String original) {
        return StringUtils.formatAsIcon(original, "");
    }

    public static Tuple<Boolean, String, String> isBase64(String original) {
        String formattedKey = original;
        String imageIdentifier = "";
        Tuple<Boolean, String, String> finalData = new Tuple<Boolean, String, String>(false, imageIdentifier, formattedKey);
        if (!StringUtils.isNullOrEmpty(formattedKey)) {
            if (formattedKey.contains(",")) {
                String[] splitData = formattedKey.split(",", 2);
                imageIdentifier = splitData[0];
                formattedKey = splitData[1];
            }
            finalData.setFirst(BASE64_PATTERN.matcher(imageIdentifier + "," + formattedKey).find());
            finalData.setSecond(imageIdentifier);
            finalData.setThird(formattedKey);
        }
        return finalData;
    }

    public static boolean isValidUuid(String input) {
        return !StringUtils.isNullOrEmpty(input) && (input.contains("-") ? FULL_UUID_PATTERN : TRIMMED_UUID_PATTERN).matcher(input).find();
    }

    public static String getFromUuid(String input, boolean trimmed) {
        if (!StringUtils.isValidUuid(input)) {
            return input;
        }
        if (trimmed) {
            return input.replace("-", "");
        }
        Pattern pattern = input.contains("-") ? FULL_UUID_PATTERN : TRIMMED_UUID_PATTERN;
        return pattern.matcher(input).find() ? pattern.matcher(input).replaceFirst("$1-$2-$3-$4-$5") : input;
    }

    public static String getFromUuid(String input) {
        return StringUtils.getFromUuid(input, false);
    }

    public static String getFromUuid(UUID input) {
        return StringUtils.getFromUuid(input.toString());
    }

    public static UUID getAsUuid(String input) {
        return UUID.fromString(StringUtils.getFromUuid(input, false));
    }

    public static <T> List<T> addEntriesNotPresent(List<T> original, List<T> newList) {
        for (T entry : newList) {
            if (original.contains(entry)) continue;
            original.add(entry);
        }
        return original;
    }

    public static <T> List<T> addEntriesNotPresent(List<T> original, Predicate<? super T> filter, List<T> newList) {
        newList = newList.stream().filter(filter).collect(Collectors.toList());
        return StringUtils.addEntriesNotPresent(original, newList);
    }

    public static <T> List<T> addEntriesNotPresent(List<T> original, Set<T> newList) {
        return StringUtils.addEntriesNotPresent(original, Lists.newArrayList(newList));
    }

    public static <T> List<T> addEntriesNotPresent(List<T> original, Predicate<? super T> filter, Set<T> newList) {
        newList = newList.stream().filter(filter).collect(Collectors.toSet());
        return StringUtils.addEntriesNotPresent(original, newList);
    }

    public static <T> List<T> addEntriesNotPresent(List<T> original, T[] newList) {
        return StringUtils.addEntriesNotPresent(original, Arrays.asList(newList));
    }

    public static String formatWord(String original) {
        return StringUtils.formatWord(original, false);
    }

    public static String formatWord(String original, boolean avoid) {
        return StringUtils.formatWord(original, avoid, false);
    }

    public static String formatWord(String original, boolean avoid, boolean skipSymbolReplacement) {
        return StringUtils.formatWord(original, avoid, skipSymbolReplacement, -1);
    }

    public static String formatWord(String original, boolean avoid, boolean skipSymbolReplacement, int caseCheckTimes) {
        String formattedKey = original;
        if (StringUtils.isNullOrEmpty(formattedKey) || avoid) {
            return formattedKey;
        }
        if (StringUtils.containsWhitespace(formattedKey)) {
            formattedKey = formattedKey.replaceAll("\\s+", " ");
        }
        if (!skipSymbolReplacement) {
            if (formattedKey.contains("_")) {
                formattedKey = formattedKey.replaceAll("_", " ");
            }
            if (formattedKey.contains("-")) {
                formattedKey = formattedKey.replaceAll("-", " ");
            }
            if (BRACKET_PATTERN.matcher(formattedKey).find()) {
                formattedKey = BRACKET_PATTERN.matcher(formattedKey).replaceAll("");
            }
            if (STRIP_COLOR_PATTERN.matcher(formattedKey).find()) {
                formattedKey = STRIP_COLOR_PATTERN.matcher(formattedKey).replaceAll("");
            }
        }
        return StringUtils.removeRepeatWords(StringUtils.capitalizeWord(formattedKey, caseCheckTimes)).trim();
    }

    public static String removeRepeatWords(String original) {
        String[] wordList;
        if (StringUtils.isNullOrEmpty(original)) {
            return original;
        }
        String lastWord = "";
        StringBuilder finalString = new StringBuilder();
        for (String word : wordList = original.split(" ")) {
            if (!StringUtils.isNullOrEmpty(lastWord) && word.equalsIgnoreCase(lastWord)) continue;
            finalString.append(word).append(" ");
            lastWord = word;
        }
        return finalString.toString().trim();
    }

    public static String formatIdentifier(String originalId, boolean formatToId) {
        return StringUtils.formatIdentifier(originalId, formatToId, false);
    }

    public static String formatIdentifier(String originalId, boolean formatToId, boolean avoid) {
        StringBuilder formattedKey = new StringBuilder(originalId);
        if (StringUtils.isNullOrEmpty(formattedKey.toString())) {
            return formattedKey.toString();
        }
        if (formattedKey.toString().contains("WorldProvider")) {
            formattedKey = new StringBuilder(formattedKey.toString().replace("WorldProvider", ""));
        }
        if (formattedKey.toString().contains("BiomeGen")) {
            formattedKey = new StringBuilder(formattedKey.toString().replace("BiomeGen", ""));
        }
        if (formattedKey.toString().contains("MobSpawner")) {
            formattedKey = new StringBuilder(formattedKey.toString().replace("MobSpawner", ""));
        }
        if (StringUtils.containsWhitespace(formattedKey.toString())) {
            formattedKey = new StringBuilder(formattedKey.toString().replaceAll("\\s+", " "));
        }
        if (formattedKey.toString().contains(":")) {
            formattedKey = new StringBuilder(formattedKey.toString().split(":", 2)[1]);
        }
        if (formattedKey.toString().contains("{") || formattedKey.toString().contains("}")) {
            formattedKey = new StringBuilder(formattedKey.toString().replaceAll("[{}]", ""));
        }
        if (formattedKey.toString().equalsIgnoreCase("surface")) {
            formattedKey = new StringBuilder("overworld");
        } else if (formattedKey.toString().equalsIgnoreCase("hell") || formattedKey.toString().equalsIgnoreCase("nether")) {
            formattedKey = new StringBuilder("the_nether");
        } else if (formattedKey.toString().equalsIgnoreCase("end") || formattedKey.toString().equalsIgnoreCase("sky")) {
            formattedKey = new StringBuilder("the_end");
        }
        if (formatToId) {
            return StringUtils.formatAsIcon(formattedKey.toString().replace(" ", "_"));
        }
        return StringUtils.formatWord(formattedKey.toString(), avoid);
    }

    public static String getFormatFromString(String text) {
        int stringLength = text.length();
        StringBuilder s = new StringBuilder();
        int index = -1;
        while ((index = text.indexOf(167, index + 1)) != -1) {
            char currentCharacter;
            String charString;
            if (index >= stringLength - 1 || !STRIP_COLOR_PATTERN.matcher(charString = String.valueOf(currentCharacter = text.charAt(index + 1))).find()) continue;
            s = new StringBuilder('\u00a7' + charString);
        }
        return s.toString();
    }

    public static String convertTime(String original, String originalPattern, String newPattern) {
        try {
            SimpleDateFormat oldFormat = new SimpleDateFormat(originalPattern);
            Date oldInfo = oldFormat.parse(original);
            SimpleDateFormat newFormat = new SimpleDateFormat(newPattern);
            return newFormat.format(oldInfo);
        }
        catch (Exception ex) {
            return original;
        }
    }

    public static String capitalizeWord(String str, int timesToCheck) {
        StringBuilder s = new StringBuilder();
        int charIndex = 32;
        int timesLeft = timesToCheck;
        for (int index = 0; index < str.length(); ++index) {
            if (charIndex == 32 && str.charAt(index) != ' ' && (timesLeft > 0 || timesLeft == -1)) {
                s.append(Character.toUpperCase(str.charAt(index)));
                if (timesLeft > 0) {
                    --timesLeft;
                }
            } else {
                s.append(str.charAt(index));
            }
            charIndex = str.charAt(index);
        }
        return s.toString().trim();
    }

    public static String capitalizeWord(String str) {
        return StringUtils.capitalizeWord(str, -1);
    }

    public static List<String> splitTextByNewLine(String original) {
        if (!StringUtils.isNullOrEmpty(original)) {
            String formattedText = original;
            if (formattedText.contains("\r\n")) {
                formattedText = original.replace("\r\n", "&newline&");
            }
            if (formattedText.contains("\n")) {
                formattedText = original.replace("\n", "&newline&");
            }
            if (formattedText.contains("\\n")) {
                formattedText = original.replace("\\n", "&newline&");
            }
            if (formattedText.contains("\\\\n+")) {
                formattedText = original.replace("\\\\n+", "&newline&");
            }
            return Lists.newArrayList((Object[])formattedText.split("&newline&"));
        }
        return Lists.newArrayList();
    }

    public static String join(String separator, List<String> input) {
        if (input == null || input.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.size(); ++i) {
            sb.append(input.get(i));
            if (i >= input.size() - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static void sendMessageToPlayer(Entity sender, String message) {
        if (sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            List<String> lines = StringUtils.splitTextByNewLine(message);
            if (!lines.isEmpty()) {
                for (String line : lines) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(line));
                }
            }
        }
    }

    public static boolean elementExists(String[] data, int index) {
        return StringUtils.elementExists(Arrays.asList(data), index);
    }

    public static boolean elementExists(List<String> data, int index) {
        boolean result;
        try {
            result = data.size() >= index && !StringUtils.isNullOrEmpty(data.get(index));
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    public static Object getField(Class<?> classToAccess, Object instance, String ... fieldNames) {
        Pair<Boolean, FieldReflectionUtils.ClassFields.Field> result = StringUtils.getValidField(classToAccess, fieldNames);
        if (result.getFirst().booleanValue()) {
            return result.getSecond().getValue(instance);
        }
        return null;
    }

    public static Object getField(String classToAccess, Object instance, String ... fieldNames) {
        Class<?> foundClass = FileUtils.findValidClass(classToAccess);
        if (foundClass != null) {
            return StringUtils.getField(foundClass, instance, fieldNames);
        }
        return null;
    }

    public static Object getField(Object classToAccess, Object instance, String ... fieldNames) {
        if (classToAccess instanceof String) {
            return StringUtils.getField((String)classToAccess, instance, fieldNames);
        }
        return StringUtils.getField(classToAccess instanceof Class ? (Class<?>)classToAccess : classToAccess.getClass(), instance, fieldNames);
    }

    public static Pair<Boolean, FieldReflectionUtils.ClassFields.Field> getValidField(Class<?> classToAccess, String ... fieldNames) {
        FieldReflectionUtils.ClassFields<?> classFields = FieldReflectionUtils.ofClass(classToAccess);
        Pair<Boolean, Object> result = new Pair<Boolean, Object>(false, null);
        for (String fieldName : fieldNames) {
            try {
                FieldReflectionUtils.ClassFields.Field<?> lookupField = classFields.getUntypedField(FieldReflectionUtils.LookupType.DECLARED, fieldName);
                if (lookupField == null) continue;
                result.setFirst(true);
                result.setSecond(lookupField);
                break;
            }
            catch (Throwable ex) {
                if (!CommandUtils.isVerboseMode()) continue;
                ex.printStackTrace();
            }
        }
        return result;
    }

    public static Pair<Boolean, FieldReflectionUtils.ClassFields.Field> getValidField(String classToAccess, String ... fieldNames) {
        Class<?> foundClass = FileUtils.findValidClass(classToAccess);
        if (foundClass != null) {
            return StringUtils.getValidField(foundClass, fieldNames);
        }
        return new Pair<Boolean, Object>(false, null);
    }

    @SafeVarargs
    public static void updateField(Class<?> classToAccess, Object instance, Pair<String, Object> ... fieldData) {
        for (Pair<String, Object> currentData : fieldData) {
            Pair<Boolean, FieldReflectionUtils.ClassFields.Field> result = StringUtils.getValidField(classToAccess, currentData.getFirst());
            if (!result.getFirst().booleanValue()) continue;
            result.getSecond().setValue(instance, currentData.getSecond());
            if (!CommandUtils.isVerboseMode()) continue;
            ModUtils.LOG.debugInfo(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.update.dynamic", currentData.toString(), classToAccess.getName()), new Object[0]);
        }
    }

    @SafeVarargs
    public static void updateField(String classToAccess, Object instance, Pair<String, Object> ... fieldData) {
        Class<?> foundClass = FileUtils.findValidClass(classToAccess);
        if (foundClass != null) {
            StringUtils.updateField(foundClass, instance, fieldData);
        }
    }

    public static Object executeMethod(Class<?> classToAccess, Object instance, String methodName, Class<?>[] parameterTypes, Object[] parameters) {
        Object result;
        block2: {
            result = null;
            try {
                Method lookupMethod = classToAccess.getDeclaredMethod(methodName, parameterTypes);
                lookupMethod.setAccessible(true);
                result = lookupMethod.invoke(instance, parameters);
            }
            catch (Throwable ex) {
                if (!CommandUtils.isVerboseMode()) break block2;
                ex.printStackTrace();
            }
        }
        return result;
    }

    @SafeVarargs
    public static Map<String, Object> executeMethod(Class<?> classToAccess, Object instance, Pair<String, Pair<Object[], Class<?>[]>> ... methodData) {
        HashMap results = Maps.newHashMap();
        for (Pair<String, Pair<Object[], Class<?>[]>> methodInstance : methodData) {
            results.put(methodInstance.getFirst(), StringUtils.executeMethod(classToAccess, instance, methodInstance.getFirst(), methodInstance.getSecond().getSecond(), methodInstance.getSecond().getFirst()));
        }
        return results;
    }

    public static String stripColors(String input) {
        return StringUtils.isNullOrEmpty(input) ? input : STRIP_COLOR_PATTERN.matcher(input).replaceAll("");
    }
}

