/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.config.gui.MainGui;
import forge.com.gitlab.cdagaming.craftpresence.impl.KeyConverter;
import forge.com.gitlab.cdagaming.craftpresence.impl.Pair;
import forge.com.gitlab.cdagaming.craftpresence.impl.Tuple;
import forge.com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.gui.GuiControls;
import net.minecraft.client.settings.KeyBinding;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.input.Keyboard;

public class KeyUtils {
    private static final List<Integer> clearKeys = Lists.newArrayList();
    private static final List<Integer> invalidKeys = Lists.newArrayList();
    private final Map<String, Tuple<KeyBinding, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>>> KEY_MAPPINGS = Maps.newHashMap();
    public Map<String, Integer> keySyncQueue = Maps.newHashMap();
    private boolean keysRegistered = false;

    public static boolean isValidKeyCode(int sourceKeyCode) {
        return !invalidKeys.contains(sourceKeyCode);
    }

    public static boolean isValidClearCode(int sourceKeyCode) {
        if (clearKeys.isEmpty()) {
            clearKeys.add(ModUtils.MCProtocolID > 340 ? 256 : 1);
        }
        return clearKeys.contains(sourceKeyCode);
    }

    public static String getKeyName(int original) {
        int unknownKeyCode = ModUtils.MCProtocolID <= 340 ? -1 : 0;
        String unknownKeyName = (ModUtils.MCProtocolID <= 340 ? KeyConverter.fromGlfw.get(unknownKeyCode) : KeyConverter.toGlfw.get(unknownKeyCode)).getSecond();
        if (KeyUtils.isValidKeyCode(original)) {
            if (ModUtils.MCProtocolID <= 340 && KeyConverter.toGlfw.containsKey(original)) {
                return KeyConverter.toGlfw.get(original).getSecond();
            }
            if (ModUtils.MCProtocolID > 340 && KeyConverter.fromGlfw.containsKey(original)) {
                return KeyConverter.fromGlfw.get(original).getSecond();
            }
            String altKeyName = Integer.toString(original);
            String keyName = original != unknownKeyCode ? Keyboard.getKeyName((int)original) : unknownKeyName;
            return StringUtils.getOrDefault(keyName, altKeyName);
        }
        return unknownKeyName;
    }

    void register() {
        this.KEY_MAPPINGS.put("configKeyCode", new Tuple<KeyBinding, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Object>(new KeyBinding("key.craftpresence.config_keycode.name", CraftPresence.CONFIG.accessibilitySettings.configKeyCode, "key.craftpresence.category"), new Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>(() -> {
            if (!CraftPresence.GUIS.isFocused && !CraftPresence.GUIS.configGUIOpened) {
                CraftPresence.GUIS.openScreen(new MainGui(CraftPresence.instance.field_71462_r));
            }
        }, (keyCode, shouldSave) -> {
            CraftPresence.CONFIG.accessibilitySettings.configKeyCode = keyCode;
            if (shouldSave.booleanValue()) {
                CraftPresence.CONFIG.save();
            }
        }, vanillaBind -> vanillaBind != CraftPresence.CONFIG.accessibilitySettings.configKeyCode), null));
    }

    public boolean areKeysRegistered() {
        return this.keysRegistered;
    }

    public Map<String, Tuple<KeyBinding, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>>> getRawKeyMappings() {
        return Maps.newHashMap(this.KEY_MAPPINGS);
    }

    public String getKeyName(String original) {
        String unknownKeyName = (ModUtils.MCProtocolID <= 340 ? KeyConverter.fromGlfw.get(-1) : KeyConverter.toGlfw.get(0)).getSecond();
        if (!StringUtils.isNullOrEmpty(original)) {
            Pair<Boolean, Integer> integerData = StringUtils.getValidInteger(original);
            if (integerData.getFirst().booleanValue()) {
                return KeyUtils.getKeyName(integerData.getSecond());
            }
            return unknownKeyName;
        }
        return unknownKeyName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onTick() {
        block18: {
            if (!this.keysRegistered) {
                if (CraftPresence.instance.field_71474_y != null) {
                    for (Map.Entry<String, Tuple<KeyBinding, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>>> entry : this.KEY_MAPPINGS.entrySet()) {
                        KeyBinding mapping = entry.getValue().getFirst();
                        CraftPresence.instance.field_71474_y.field_74324_K = (KeyBinding[])ArrayUtils.add((Object[])CraftPresence.instance.field_71474_y.field_74324_K, (Object)mapping);
                    }
                    this.keysRegistered = true;
                } else {
                    return;
                }
            }
            if (Keyboard.isCreated() && CraftPresence.CONFIG != null) {
                int unknownKeyCode = ModUtils.MCProtocolID <= 340 ? -1 : 0;
                String unknownKeyName = (ModUtils.MCProtocolID <= 340 ? KeyConverter.fromGlfw.get(unknownKeyCode) : KeyConverter.toGlfw.get(unknownKeyCode)).getSecond();
                try {
                    for (Map.Entry entry : this.KEY_MAPPINGS.entrySet()) {
                        String keyName = (String)entry.getKey();
                        Tuple keyData = (Tuple)entry.getValue();
                        KeyBinding keyBind = (KeyBinding)keyData.getFirst();
                        Tuple callbackData = (Tuple)keyData.getSecond();
                        int currentBind = keyBind.func_151463_i();
                        boolean hasBeenRun = false;
                        if (!KeyUtils.getKeyName(currentBind).equals(unknownKeyName) && !KeyUtils.isValidClearCode(currentBind) && Keyboard.isKeyDown((int)currentBind) && !(CraftPresence.instance.field_71462_r instanceof GuiControls)) {
                            try {
                                ((Runnable)callbackData.getFirst()).run();
                            }
                            catch (Throwable ex) {
                                if (keyData.getThird() != null) {
                                    ((Consumer)keyData.getThird()).accept(ex);
                                } else {
                                    ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.keycode", keyBind.func_151464_g()), new Object[0]);
                                    this.syncKeyData(keyName, ImportMode.Specific, keyBind.func_151469_h());
                                }
                            }
                            finally {
                                hasBeenRun = true;
                            }
                        }
                        if (hasBeenRun || CraftPresence.CONFIG.hasChanged) continue;
                        if (this.keySyncQueue.containsKey(keyName)) {
                            this.syncKeyData(keyName, ImportMode.Config, this.keySyncQueue.get(keyName));
                            this.keySyncQueue.remove(keyName);
                            continue;
                        }
                        if (!((Predicate)callbackData.getThird()).test(currentBind)) continue;
                        this.syncKeyData(keyName, ImportMode.Vanilla, currentBind);
                    }
                }
                catch (Throwable ex) {
                    if (!CommandUtils.isVerboseMode()) break block18;
                    ex.printStackTrace();
                }
            }
        }
    }

    private void syncKeyData(String keyName, ImportMode mode, int keyCode) {
        Tuple keyData = this.KEY_MAPPINGS.getOrDefault(keyName, null);
        if (mode == ImportMode.Config) {
            ((KeyBinding)keyData.getFirst()).func_151462_b(keyCode);
        } else if (mode == ImportMode.Vanilla) {
            ((BiConsumer)((Tuple)keyData.getSecond()).getSecond()).accept(keyCode, true);
        } else if (mode == ImportMode.Specific) {
            this.syncKeyData(((KeyBinding)keyData.getFirst()).func_151464_g(), ImportMode.Config, keyCode);
            this.syncKeyData(keyName, ImportMode.Vanilla, keyCode);
        } else if (CommandUtils.isVerboseMode()) {
            ModUtils.LOG.debugWarn(ModUtils.TRANSLATOR.translate("craftpresence.logger.warning.convert.invalid", keyName, mode.name()), new Object[0]);
        }
    }

    public Map<String, Tuple<KeyBinding, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>>> getKeyMappings(FilterMode mode, List<String> filterData) {
        HashMap filteredMappings = Maps.newHashMap();
        for (Map.Entry<String, Tuple<KeyBinding, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>>> entry : this.KEY_MAPPINGS.entrySet()) {
            String keyName = entry.getKey();
            if (mode != FilterMode.None && mode != FilterMode.Category && mode != FilterMode.Id && (mode != FilterMode.Name || !filterData.contains(keyName))) continue;
            Tuple<KeyBinding, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>> keyData = entry.getValue();
            if (!(mode == FilterMode.None || mode == FilterMode.Category && filterData.contains(keyData.getFirst().func_151466_e()) || mode == FilterMode.Id && filterData.contains(keyData.getFirst().func_151464_g())) && mode != FilterMode.Name) continue;
            filteredMappings.put(keyName, keyData);
        }
        return filteredMappings;
    }

    public Map<String, Tuple<KeyBinding, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>>> getKeyMappings() {
        return this.getKeyMappings(FilterMode.None, Lists.newArrayList());
    }

    public static enum ImportMode {
        Config,
        Vanilla,
        Specific;

    }

    public static enum FilterMode {
        Category,
        Name,
        Id,
        None;

    }
}

