/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.integrations.multimc;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;

@SuppressFBWarnings(value={"MS_CANNOT_BE_FINAL"})
public class MultiMCUtils {
    private static final Properties configFile = new Properties();
    private static final String instanceFile = new File(CraftPresence.SYSTEM.USER_DIR).getParent() + File.separator + "instance.cfg";
    public static String INSTANCE_NAME;
    public static String ICON_KEY;

    public static boolean contains(String key) {
        return configFile.containsKey(key);
    }

    public static String get(String key) {
        return MultiMCUtils.contains(key) ? configFile.getProperty(key) : null;
    }

    public static void loadInstance() {
        block9: {
            ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.instance.init", new Object[0]), new Object[0]);
            try (InputStream inputStream = Files.newInputStream(Paths.get(instanceFile, new String[0]), new OpenOption[0]);){
                configFile.load(inputStream);
                INSTANCE_NAME = MultiMCUtils.get("name");
                String tempIconKey = MultiMCUtils.get("iconKey");
                String defaultIconName = "default";
                String defaultIconKey = "infinity";
                ICON_KEY = StringUtils.formatAsIcon(!StringUtils.isNullOrEmpty(tempIconKey) && !tempIconKey.equals("default") ? tempIconKey : "infinity");
                if (!StringUtils.isNullOrEmpty(INSTANCE_NAME) && !StringUtils.isNullOrEmpty(ICON_KEY)) {
                    ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.instance.loaded", INSTANCE_NAME, ICON_KEY), new Object[0]);
                    CraftPresence.packFound = true;
                }
            }
            catch (Exception ex) {
                ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.file.instance", new Object[0]), new Object[0]);
                if ((ex.getClass() == FileNotFoundException.class || ex.getClass() == NoSuchFileException.class) && !CommandUtils.isVerboseMode()) break block9;
                ex.printStackTrace();
            }
        }
    }
}

