/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.config.gui;

import com.google.common.collect.Lists;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.config.Config;
import forge.com.gitlab.cdagaming.craftpresence.config.gui.AboutGui;
import forge.com.gitlab.cdagaming.craftpresence.config.gui.AccessibilitySettingsGui;
import forge.com.gitlab.cdagaming.craftpresence.config.gui.AdvancedSettingsGui;
import forge.com.gitlab.cdagaming.craftpresence.config.gui.BiomeSettingsGui;
import forge.com.gitlab.cdagaming.craftpresence.config.gui.DimensionSettingsGui;
import forge.com.gitlab.cdagaming.craftpresence.config.gui.GeneralSettingsGui;
import forge.com.gitlab.cdagaming.craftpresence.config.gui.PresenceSettingsGui;
import forge.com.gitlab.cdagaming.craftpresence.config.gui.ServerSettingsGui;
import forge.com.gitlab.cdagaming.craftpresence.config.gui.StatusMessagesGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.KeyUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.commands.CommandsGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.ControlsGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiScreen;

public class MainGui
extends ExtendedScreen {
    private ExtendedButtonControl biomeSet;
    private ExtendedButtonControl dimensionSet;
    private ExtendedButtonControl serverSet;
    private ExtendedButtonControl controlsButton;
    private ExtendedButtonControl proceedButton;
    private ExtendedButtonControl commandGUIButton;

    public MainGui(GuiScreen parentScreen) {
        super(parentScreen);
    }

    @Override
    public void initializeUi() {
        KeyUtils.FilterMode controlMode;
        CraftPresence.GUIS.configGUIOpened = true;
        int calc1 = this.getScreenWidth() / 2 - 183;
        int calc2 = this.getScreenWidth() / 2 + 3;
        this.addControl(new ExtendedButtonControl(calc1, CraftPresence.GUIS.getButtonY(1), 180, 20, "gui.config.title.general", () -> CraftPresence.GUIS.openScreen(new GeneralSettingsGui(this.currentScreen)), () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.title.general", new Object[0])), this, true), new String[0]));
        this.biomeSet = this.addControl(new ExtendedButtonControl(calc2, CraftPresence.GUIS.getButtonY(1), 180, 20, "gui.config.title.biome_messages", () -> CraftPresence.GUIS.openScreen(new BiomeSettingsGui(this.currentScreen)), () -> {
            if (!this.biomeSet.isControlEnabled()) {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.hover.access", ModUtils.TRANSLATOR.translate("gui.config.name.general.detect_biome_data", new Object[0]))), this, true);
            } else {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.biome_messages.biome_messages", CraftPresence.CLIENT.generateArgumentMessage("biome."))), this, true);
            }
        }, new String[0]));
        this.dimensionSet = this.addControl(new ExtendedButtonControl(calc1, CraftPresence.GUIS.getButtonY(2), 180, 20, "gui.config.title.dimension_messages", () -> CraftPresence.GUIS.openScreen(new DimensionSettingsGui(this.currentScreen)), () -> {
            if (!this.dimensionSet.isControlEnabled()) {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.hover.access", ModUtils.TRANSLATOR.translate("gui.config.name.general.detect_dimension_data", new Object[0]))), this, true);
            } else {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.dimension_messages.dimension_messages", CraftPresence.CLIENT.generateArgumentMessage("dimension."))), this, true);
            }
        }, new String[0]));
        this.serverSet = this.addControl(new ExtendedButtonControl(calc2, CraftPresence.GUIS.getButtonY(2), 180, 20, "gui.config.title.server_messages", () -> CraftPresence.GUIS.openScreen(new ServerSettingsGui(this.currentScreen)), () -> {
            if (!this.serverSet.isControlEnabled()) {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.hover.access", ModUtils.TRANSLATOR.translate("gui.config.name.general.detect_world_data", new Object[0]))), this, true);
            } else {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.server_messages.server_messages", CraftPresence.CLIENT.generateArgumentMessage("server.", "world.", "player."))), this, true);
            }
        }, new String[0]));
        this.addControl(new ExtendedButtonControl(calc1, CraftPresence.GUIS.getButtonY(3), 180, 20, "gui.config.title.status_messages", () -> CraftPresence.GUIS.openScreen(new StatusMessagesGui(this.currentScreen)), () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.title.status_messages", new Object[0])), this, true), new String[0]));
        this.addControl(new ExtendedButtonControl(calc2, CraftPresence.GUIS.getButtonY(3), 180, 20, "gui.config.title.advanced", () -> CraftPresence.GUIS.openScreen(new AdvancedSettingsGui(this.currentScreen)), () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.title.advanced", new Object[0])), this, true), new String[0]));
        this.addControl(new ExtendedButtonControl(calc1, CraftPresence.GUIS.getButtonY(4), 180, 20, "gui.config.title.accessibility", () -> CraftPresence.GUIS.openScreen(new AccessibilitySettingsGui(this.currentScreen)), () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.title.accessibility", new Object[0])), this, true), new String[0]));
        this.addControl(new ExtendedButtonControl(calc2, CraftPresence.GUIS.getButtonY(4), 180, 20, "gui.config.title.presence_settings", () -> CraftPresence.GUIS.openScreen(new PresenceSettingsGui(this.currentScreen)), () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.presence_settings", new Object[0])), this, true), new String[0]));
        ArrayList controlInfo = Lists.newArrayList((Object[])new String[]{"key.craftpresence.category"});
        KeyUtils.FilterMode finalControlMode = controlMode = KeyUtils.FilterMode.Category;
        this.controlsButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getScreenHeight() - 55, 180, 20, "gui.config.message.button.controls", () -> CraftPresence.GUIS.openScreen(new ControlsGui(this.currentScreen, finalControlMode, controlInfo)), new String[0]));
        this.proceedButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getScreenHeight() - 30, 180, 20, "gui.config.message.button.back", () -> {
            if (CraftPresence.CONFIG.hasChanged) {
                CraftPresence.CONFIG.save();
                ModUtils.LOG.info(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.info.config.save", new Object[0]), new Object[0]);
            }
            CraftPresence.GUIS.configGUIOpened = false;
            if (this.field_146297_k.field_71439_g != null) {
                this.field_146297_k.field_71439_g.func_71053_j();
            } else {
                CraftPresence.GUIS.openScreen(this.parentScreen);
            }
        }, new String[0]));
        this.addControl(new ExtendedButtonControl(this.getScreenWidth() - 105, this.getScreenHeight() - 55, 95, 20, "gui.config.message.button.about", () -> CraftPresence.GUIS.openScreen(new AboutGui(this.currentScreen)), new String[0]));
        this.commandGUIButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() - 105, this.getScreenHeight() - 30, 95, 20, "gui.config.message.button.commands", () -> CraftPresence.GUIS.openScreen(new CommandsGui(this.currentScreen)), new String[0]));
        this.addControl(new ExtendedButtonControl(10, this.getScreenHeight() - 30, 95, 20, "gui.config.message.button.reset", () -> {
            CraftPresence.CONFIG = Config.loadOrCreate(true);
        }, new String[0]));
        this.addControl(new ExtendedButtonControl(10, this.getScreenHeight() - 55, 95, 20, "gui.config.message.button.sync.config", () -> {
            String configData = CraftPresence.CONFIG.toString();
            CraftPresence.CONFIG = Config.loadOrCreate();
            if (!CraftPresence.CONFIG.toString().equals(configData)) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.hasClientPropertiesChanged = true;
                CraftPresence.CONFIG.flushClientProperties = true;
                this.syncRenderStates();
            }
        }, () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.button.sync.config", new Object[0])), this, true), new String[0]));
        super.initializeUi();
    }

    @Override
    public void preRender() {
        String mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title", new Object[0]);
        String releaseNotice = ModUtils.TRANSLATOR.translate("gui.config.message.tentative", ModUtils.VERSION_ID);
        this.renderString(mainTitle, (float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(mainTitle) / 2.0f, 15.0f, 0xFFFFFF);
        if (ModUtils.VERSION_TYPE.equalsIgnoreCase("alpha")) {
            this.renderString(releaseNotice, (float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(releaseNotice) / 2.0f, this.getScreenHeight() - 85, 0xFFFFFF);
        }
        this.syncRenderStates();
    }

    @Override
    public void postRender() {
        String mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title", new Object[0]);
        if (CraftPresence.GUIS.isMouseOver(this.getMouseX(), this.getMouseY(), (float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(mainTitle) / 2.0f, 15.0, this.getStringWidth(mainTitle), this.getFontHeight())) {
            CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.title", ModUtils.VERSION_ID, CraftPresence.CONFIG._schemaVersion)), this, true);
        }
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 1) {
            if (CraftPresence.CONFIG.hasChanged) {
                CraftPresence.CONFIG = Config.loadOrCreate();
            }
            CraftPresence.GUIS.configGUIOpened = false;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    private void syncRenderStates() {
        this.biomeSet.setControlEnabled(CraftPresence.BIOMES.enabled);
        this.dimensionSet.setControlEnabled(CraftPresence.DIMENSIONS.enabled);
        this.serverSet.setControlEnabled(CraftPresence.SERVER.enabled);
        this.commandGUIButton.setControlEnabled(CraftPresence.CONFIG.advancedSettings.enableCommands);
        this.controlsButton.setControlEnabled(CraftPresence.KEYBINDINGS.areKeysRegistered());
        this.proceedButton.setControlMessage(CraftPresence.CONFIG.hasChanged ? "gui.config.message.button.save" : "gui.config.message.button.back");
    }
}

