/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.config.Config;
import forge.com.gitlab.cdagaming.craftpresence.impl.Pair;
import forge.com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.KeyUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.MappingUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.SystemUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.DiscordUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.entity.EntityUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.entity.TileEntityUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.server.ServerUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.world.BiomeUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.world.DimensionUtils;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Session;

@SuppressFBWarnings(value={"MS_CANNOT_BE_FINAL"})
public class CraftPresence {
    public static final Timer timerObj = new Timer(CraftPresence.class.getSimpleName());
    public static final KeyUtils KEYBINDINGS = new KeyUtils();
    public static final DiscordUtils CLIENT = new DiscordUtils();
    public static final ServerUtils SERVER = new ServerUtils();
    public static final BiomeUtils BIOMES = new BiomeUtils();
    public static final DimensionUtils DIMENSIONS = new DimensionUtils();
    public static final EntityUtils ENTITIES = new EntityUtils();
    public static final TileEntityUtils TILE_ENTITIES = new TileEntityUtils();
    public static final GuiUtils GUIS = new GuiUtils();
    public static final SystemUtils SYSTEM = new SystemUtils();
    public static boolean packFound = false;
    public static Minecraft instance;
    public static Session session;
    public static EntityPlayer player;
    public static Config CONFIG;
    private final Runnable initCallback;
    private boolean initialized = false;

    public CraftPresence(Runnable callback) {
        this.initCallback = callback;
        this.scheduleTick();
    }

    public CraftPresence() {
        this(null);
    }

    private void init() {
        MappingUtils.getClassMap();
        ModUtils.LOG.debugWarn(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.warning.debug_mode", new Object[0]), new Object[0]);
        ModUtils.LOG.debugInfo(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.info.os", CraftPresence.SYSTEM.OS_NAME, CraftPresence.SYSTEM.OS_ARCH, CraftPresence.SYSTEM.IS_64_BIT), new Object[0]);
        ModUtils.UPDATER.checkForUpdates(() -> {
            if (ModUtils.UPDATER.isInvalidVersion) {
                StringUtils.updateField(ModUtils.class, null, new Pair<String, String>("VERSION_ID", "v" + ModUtils.UPDATER.targetVersion));
                StringUtils.updateField(ModUtils.class, null, new Pair<String, String>("VERSION_TYPE", ModUtils.UPDATER.currentState.getDisplayName()));
                StringUtils.updateField(ModUtils.class, null, new Pair<String, String>("NAME", CraftPresence.class.getSimpleName()));
                ModUtils.UPDATER.currentVersion = ModUtils.UPDATER.targetVersion;
                ModUtils.UPDATER.isInvalidVersion = false;
            }
        });
        CONFIG = Config.getInstance();
        CommandUtils.init();
        try {
            CraftPresence.CLIENT.CLIENT_ID = CraftPresence.CONFIG.generalSettings.clientId;
            CraftPresence.CLIENT.AUTO_REGISTER = CraftPresence.CONFIG.generalSettings.autoRegister;
            CLIENT.setup();
            CLIENT.init(true);
        }
        catch (Exception ex) {
            ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.load", new Object[0]), new Object[0]);
            if (CommandUtils.isVerboseMode()) {
                ex.printStackTrace();
            }
        }
        finally {
            if (this.initCallback != null) {
                this.initCallback.run();
            }
            this.initialized = true;
        }
    }

    private void scheduleTick() {
        if (!CraftPresence.SYSTEM.IS_GAME_CLOSING) {
            timerObj.schedule(new TimerTask(){

                @Override
                public void run() {
                    CraftPresence.this.clientTick();
                }
            }, 50L);
        }
    }

    private void clientTick() {
        if (!CraftPresence.SYSTEM.IS_GAME_CLOSING) {
            instance = Minecraft.func_71410_x();
            if (this.initialized) {
                session = instance.func_110432_I();
                player = CraftPresence.instance.field_71439_g;
                CommandUtils.reloadData(false);
            } else if (instance != null && (session = instance.func_110432_I()) != null) {
                this.init();
            }
            this.scheduleTick();
        }
    }
}

