/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.gui.integrations;

import com.google.common.collect.Lists;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_1600;
import net.minecraft.class_356;
import net.minecraft.class_370;
import net.minecraft.class_372;
import net.minecraft.class_388;
import org.lwjgl.input.Keyboard;

public class ExtendedScreen
extends class_388 {
    public final class_388 parentScreen;
    public final class_388 currentScreen;
    protected final List<class_372> extendedControls = Lists.newArrayList();
    protected final List<ScrollableListControl> extendedLists = Lists.newArrayList();
    public boolean initialized = false;
    private boolean debugMode = false;
    private boolean verboseMode = false;
    private int lastMouseX = 0;
    private int lastMouseY = 0;

    public ExtendedScreen(class_388 parentScreen) {
        this.field_1229 = CraftPresence.instance;
        this.currentScreen = this;
        this.parentScreen = parentScreen;
        this.setDebugMode(CommandUtils.isDebugMode());
        this.setVerboseMode(CommandUtils.isVerboseMode());
    }

    public ExtendedScreen(class_388 parentScreen, boolean debugMode) {
        this(parentScreen);
        this.setDebugMode(debugMode);
    }

    public ExtendedScreen(class_388 parentScreen, boolean debugMode, boolean verboseMode) {
        this(parentScreen, debugMode);
        this.setVerboseMode(verboseMode);
    }

    public void method_1044() {
        this.field_1232.clear();
        this.extendedControls.clear();
        this.extendedLists.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.initializeUi();
        super.method_1044();
        this.initialized = true;
    }

    public void initializeUi() {
    }

    public void method_1028(@Nonnull class_1600 mcIn, int w, int h) {
        this.initialized = false;
        super.method_1028(mcIn, w, h);
    }

    @Nonnull
    protected <T extends class_372> T addControl(@Nonnull T buttonIn) {
        if (buttonIn instanceof class_356 && !this.field_1232.contains(buttonIn)) {
            this.field_1232.add((class_356)buttonIn);
        }
        if (!this.extendedControls.contains(buttonIn)) {
            this.extendedControls.add(buttonIn);
        }
        return buttonIn;
    }

    @Nonnull
    protected <T extends ScrollableListControl> T addList(@Nonnull T buttonIn) {
        if (!this.extendedLists.contains(buttonIn)) {
            this.extendedLists.add(buttonIn);
        }
        return buttonIn;
    }

    public void renderCriticalData() {
        CraftPresence.GUIS.drawBackground(this.getScreenWidth(), this.getScreenHeight());
    }

    public void preRender() {
    }

    public void postRender() {
    }

    public void method_1025(int mouseX, int mouseY, float partialTicks) {
        if (this.initialized) {
            this.renderCriticalData();
            this.preRender();
            for (ScrollableListControl listControl : this.extendedLists) {
                if (!listControl.method_6710()) continue;
                listControl.method_1053(mouseX, mouseY, partialTicks);
            }
            for (class_372 extendedControl : this.extendedControls) {
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.method_937();
            }
            super.method_1025(mouseX, mouseY, partialTicks);
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            for (class_372 extendedControl : this.extendedControls) {
                ExtendedButtonControl extendedButton;
                if (!(extendedControl instanceof ExtendedButtonControl) || !CraftPresence.GUIS.isMouseOver((double)mouseX, (double)mouseY, extendedButton = (ExtendedButtonControl)extendedControl)) continue;
                extendedButton.onHover();
            }
            this.postRender();
        }
    }

    public void method_1035() {
        if (this.initialized) {
            super.method_1035();
        }
    }

    protected void method_1027(@Nonnull class_356 button) {
        if (button instanceof ExtendedButtonControl) {
            ((ExtendedButtonControl)button).onClick();
        }
        super.method_1027(button);
    }

    protected void method_1024(char typedChar, int keyCode) {
        if (this.initialized) {
            if (keyCode == 1) {
                CraftPresence.GUIS.openScreen(this.parentScreen);
                return;
            }
            for (class_372 extendedControl : this.extendedControls) {
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.method_917(typedChar, keyCode);
            }
        }
    }

    protected void method_1026(int mouseX, int mouseY, int mouseButton) {
        if (this.initialized) {
            for (class_372 extendedControl : this.extendedControls) {
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.method_920(mouseX, mouseY, mouseButton);
            }
            super.method_1026(mouseX, mouseY, mouseButton);
        }
    }

    public void method_1033() {
        if (this.initialized) {
            for (class_372 extendedControl : this.extendedControls) {
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.method_916();
            }
        }
    }

    public void method_1030() {
        this.initialized = false;
        CraftPresence.GUIS.resetIndex();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void renderNotice(List<String> notice) {
        this.renderNotice(notice, 2.0f, 3.0f, false, false);
    }

    public void renderNotice(List<String> notice, float widthScale, float heightScale) {
        this.renderNotice(notice, widthScale, heightScale, false, false);
    }

    public void renderNotice(List<String> notice, float widthScale, float heightScale, boolean useXAsActual, boolean useYAsActual) {
        if (notice != null && !notice.isEmpty()) {
            for (int i = 0; i < notice.size(); ++i) {
                String string = notice.get(i);
                this.renderString(string, (useXAsActual ? widthScale : (float)this.getScreenWidth() / widthScale) - (float)this.getStringWidth(string) / widthScale, (useYAsActual ? heightScale : (float)this.getScreenHeight() / heightScale) + (float)(i * 10), 0xFFFFFF);
            }
        }
    }

    public void renderString(String text, float xPos, float yPos, int color) {
        this.getFontRenderer().method_956(text, Math.round(xPos), Math.round(yPos), color);
    }

    public int getStringWidth(String string) {
        return this.getFontRenderer().method_954(string);
    }

    public int getWrapWidth() {
        return -1;
    }

    public int getMouseX() {
        return this.lastMouseX;
    }

    public int getMouseY() {
        return this.lastMouseY;
    }

    public int getScreenWidth() {
        return this.field_1230;
    }

    public int getScreenHeight() {
        return this.field_1231;
    }

    public class_370 getFontRenderer() {
        return this.field_1229.field_3814 != null ? this.field_1229.field_3814 : GuiUtils.getDefaultFontRenderer();
    }

    public int getFontHeight() {
        return this.getFontRenderer().field_1141;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean isDebugMode) {
        this.debugMode = isDebugMode;
    }

    public boolean isVerboseMode() {
        return this.verboseMode;
    }

    public void setVerboseMode(boolean isVerboseMode) {
        this.verboseMode = isVerboseMode;
    }
}

