/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls;

import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.ImageUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import java.io.File;
import javax.annotation.Nonnull;
import net.minecraft.class_1600;
import net.minecraft.class_1653;
import net.minecraft.class_356;
import net.minecraft.class_370;

public class ExtendedButtonControl
extends class_356 {
    private String[] optionalArgs;
    private Runnable onPushEvent = null;
    private Runnable onHoverEvent = null;
    private class_370 currentFontRender = null;

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, String ... optionalArgs) {
        super(buttonId, x, y, widthIn, heightIn, buttonText);
        this.optionalArgs = optionalArgs;
    }

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, String ... optionalArgs) {
        this(buttonId, x, y, widthIn, heightIn, buttonText, optionalArgs);
        this.onPushEvent = onPushEvent;
    }

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, Runnable onHoverEvent, String ... optionalArgs) {
        this(buttonId, x, y, widthIn, heightIn, buttonText, onPushEvent, optionalArgs);
        this.onHoverEvent = onHoverEvent;
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, String ... optionalArgs) {
        super(CraftPresence.GUIS.getNextIndex(), x, y, widthIn, heightIn, buttonText);
        this.optionalArgs = optionalArgs;
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, String ... optionalArgs) {
        this(x, y, widthIn, heightIn, buttonText, optionalArgs);
        this.setOnClick(onPushEvent);
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, Runnable onHoverEvent, String ... optionalArgs) {
        this(x, y, widthIn, heightIn, buttonText, onPushEvent, optionalArgs);
        this.setOnHover(onHoverEvent);
    }

    public ExtendedButtonControl(int id, int xPos, int yPos, String displayString) {
        super(id, xPos, yPos, displayString);
    }

    public ExtendedButtonControl(int xPos, int yPos, String displayString) {
        this(CraftPresence.GUIS.getNextIndex(), xPos, yPos, displayString);
    }

    public void method_891(@Nonnull class_1600 mc, int mouseX, int mouseY) {
        this.setCurrentFontRender(mc.field_3814);
        if (this.field_1056) {
            this.field_5056 = CraftPresence.GUIS.isMouseOver((double)mouseX, (double)mouseY, this);
            int hoverState = this.method_892(this.field_5056);
            String backgroundCode = CraftPresence.CONFIG.accessibilitySettings.buttonBackgroundColor;
            if (StringUtils.isValidColorCode(backgroundCode)) {
                CraftPresence.GUIS.drawGradientRect(this.field_1172, this.getControlPosX(), this.getControlPosY(), this.getControlWidth(), this.getControlHeight(), backgroundCode, backgroundCode);
            } else {
                class_1653 texLocation;
                boolean usingExternalTexture = ImageUtils.isExternalImage(backgroundCode);
                if (!usingExternalTexture) {
                    if (backgroundCode.contains(":")) {
                        String[] splitInput = backgroundCode.split(":", 2);
                        texLocation = new class_1653(splitInput[0], splitInput[1]);
                    } else {
                        texLocation = new class_1653(backgroundCode);
                    }
                } else {
                    String formattedConvertedName = backgroundCode.replaceFirst("file://", "");
                    String[] urlBits = formattedConvertedName.trim().split("/");
                    String textureName = urlBits[urlBits.length - 1].trim();
                    texLocation = ImageUtils.getTextureFromUrl(textureName, backgroundCode.toLowerCase().startsWith("file://") ? new File(formattedConvertedName) : formattedConvertedName);
                }
                CraftPresence.GUIS.renderButton(this.getControlPosX(), this.getControlPosY(), this.getControlWidth(), this.getControlHeight(), hoverState, this.field_1172, texLocation);
            }
            this.method_893(mc, mouseX, mouseY);
            int color = !this.field_1055 ? 0xA0A0A0 : (this.field_5056 ? 0xFFFFA0 : 0xE0E0E0);
            this.method_990(this.getFontRenderer(), this.getDisplayMessage(), this.getControlPosX() + this.getControlWidth() / 2, this.getControlPosY() + (this.getControlHeight() - 8) / 2, color);
        }
    }

    public int getControlWidth() {
        return this.field_1049;
    }

    public int getControlHeight() {
        return this.field_1050;
    }

    public int getControlPosX() {
        return this.field_1051;
    }

    public int getControlPosY() {
        return this.field_1052;
    }

    public class_370 getFontRenderer() {
        return this.currentFontRender != null ? this.currentFontRender : GuiUtils.getDefaultFontRenderer();
    }

    public void setCurrentFontRender(class_370 currentFontRender) {
        this.currentFontRender = currentFontRender;
    }

    public int getFontHeight() {
        return this.getFontRenderer().field_1141;
    }

    public String[] getOptionalArgs() {
        return (String[])this.optionalArgs.clone();
    }

    public void setOnClick(Runnable event) {
        this.onPushEvent = event;
    }

    public void onClick() {
        if (this.onPushEvent != null) {
            this.onPushEvent.run();
        }
    }

    public void setOnHover(Runnable event) {
        this.onHoverEvent = event;
    }

    public void onHover() {
        if (this.onHoverEvent != null) {
            this.onHoverEvent.run();
        }
    }

    public String getDisplayMessage() {
        String result = this.getControlMessage().trim();
        if (result.contains(" ")) {
            String adjusted = result;
            for (String dataPart : result.split(" ")) {
                if (!ModUtils.TRANSLATOR.hasTranslation(dataPart)) continue;
                adjusted = adjusted.replace(dataPart, ModUtils.TRANSLATOR.translate(dataPart, new Object[0]));
            }
            result = adjusted;
        } else if (ModUtils.TRANSLATOR.hasTranslation(this.getControlMessage())) {
            result = ModUtils.TRANSLATOR.translate(result, new Object[0]);
        }
        return result;
    }

    public String getControlMessage() {
        return this.field_1053;
    }

    public void setControlMessage(String newMessage) {
        this.field_1053 = newMessage;
    }

    public boolean isControlEnabled() {
        return this.field_1055;
    }

    public void setControlEnabled(boolean isEnabled) {
        this.field_1055 = isEnabled;
    }

    public boolean isControlVisible() {
        return this.field_1056;
    }

    public void setControlVisible(boolean isVisible) {
        this.field_1056 = isVisible;
    }
}

