/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.config.Config;
import fabric.com.gitlab.cdagaming.craftpresence.config.element.ModuleData;
import fabric.com.gitlab.cdagaming.craftpresence.impl.Module;
import fabric.com.gitlab.cdagaming.craftpresence.utils.NbtUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import java.util.List;
import java.util.Map;
import net.minecraft.class_322;
import net.minecraft.class_482;
import net.minecraft.class_864;
import net.minecraft.class_867;
import net.minecraft.class_988;

public class EntityUtils
implements Module {
    public boolean isInUse = false;
    public boolean enabled = false;
    public boolean hasScanned = false;
    public String CURRENT_TARGET_NAME;
    public String CURRENT_RIDING_NAME;
    public List<String> ENTITY_NAMES = Lists.newArrayList();
    public Map<String, String> PLAYER_BINDINGS = Maps.newHashMap();
    public class_864 CURRENT_TARGET;
    public class_864 CURRENT_RIDING;
    private class_322 CURRENT_TARGET_DATA;
    private class_322 CURRENT_RIDING_DATA;

    @Override
    public void emptyData() {
        this.hasScanned = false;
        this.ENTITY_NAMES.clear();
        this.PLAYER_BINDINGS.clear();
        this.clearClientData();
    }

    @Override
    public void clearClientData() {
        this.CURRENT_TARGET = null;
        this.CURRENT_RIDING = null;
        this.CURRENT_TARGET_NAME = null;
        this.CURRENT_RIDING_NAME = null;
        this.CURRENT_TARGET_DATA = null;
        this.CURRENT_RIDING_DATA = null;
        this.setInUse(false);
        CraftPresence.CLIENT.removeArguments("entity", "data.entity");
        CraftPresence.CLIENT.clearOverride("entity.target.message", "entity.target.icon", "entity.riding.message", "entity.riding.icon");
    }

    @Override
    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.advancedSettings.enablePerEntity : this.enabled;
        boolean bl = needsUpdate = this.enabled && !this.hasScanned;
        if (needsUpdate) {
            new Thread(this::getAllData, "CraftPresence-Entity-Lookup").start();
            this.hasScanned = true;
        }
        if (this.enabled) {
            if (CraftPresence.player != null) {
                this.setInUse(true);
                this.updateData();
            } else if (this.isInUse()) {
                this.clearClientData();
            }
        } else if (this.isInUse()) {
            this.emptyData();
        }
    }

    @Override
    public void updateData() {
        boolean hasRidingNBTChanged;
        String NEW_CURRENT_RIDING_NAME;
        String NEW_CURRENT_TARGET_NAME;
        class_864 NEW_CURRENT_TARGET = CraftPresence.instance.field_3822 != null && CraftPresence.instance.field_3822.field_601 != null ? CraftPresence.instance.field_3822.field_601 : null;
        class_864 NEW_CURRENT_RIDING = CraftPresence.player.field_3247;
        class_322 NEW_CURRENT_TARGET_DATA = NbtUtils.getNbt(NEW_CURRENT_TARGET);
        class_322 NEW_CURRENT_RIDING_DATA = NbtUtils.getNbt(NEW_CURRENT_RIDING);
        if (NEW_CURRENT_TARGET instanceof class_988) {
            class_988 NEW_CURRENT_PLAYER_TARGET = (class_988)NEW_CURRENT_TARGET;
            NEW_CURRENT_TARGET_NAME = StringUtils.stripColors(NEW_CURRENT_PLAYER_TARGET.method_8429().getId().toString());
        } else {
            String string = NEW_CURRENT_TARGET_NAME = NEW_CURRENT_TARGET != null ? StringUtils.stripColors(NEW_CURRENT_TARGET.method_6344().method_7472()) : "";
        }
        if (NEW_CURRENT_RIDING instanceof class_988) {
            class_988 NEW_CURRENT_PLAYER_RIDING = (class_988)NEW_CURRENT_RIDING;
            NEW_CURRENT_RIDING_NAME = StringUtils.stripColors(NEW_CURRENT_PLAYER_RIDING.method_8429().getId().toString());
        } else {
            NEW_CURRENT_RIDING_NAME = NEW_CURRENT_RIDING != null ? StringUtils.stripColors(NEW_CURRENT_RIDING.method_6344().method_7472()) : "";
        }
        boolean hasTargetChanged = NEW_CURRENT_TARGET != null && !NEW_CURRENT_TARGET.equals((Object)this.CURRENT_TARGET) || !NEW_CURRENT_TARGET_NAME.equals(this.CURRENT_TARGET_NAME) || NEW_CURRENT_TARGET == null && this.CURRENT_TARGET != null;
        boolean hasTargetNBTChanged = !NEW_CURRENT_TARGET_DATA.equals((Object)this.CURRENT_TARGET_DATA);
        boolean hasRidingChanged = NEW_CURRENT_RIDING != null && !NEW_CURRENT_RIDING.equals((Object)this.CURRENT_RIDING) || !NEW_CURRENT_RIDING_NAME.equals(this.CURRENT_RIDING_NAME) || NEW_CURRENT_RIDING == null && this.CURRENT_RIDING != null;
        boolean bl = hasRidingNBTChanged = !NEW_CURRENT_RIDING_DATA.equals((Object)this.CURRENT_RIDING_DATA);
        if (hasTargetChanged) {
            this.CURRENT_TARGET = NEW_CURRENT_TARGET;
            this.CURRENT_TARGET_NAME = NEW_CURRENT_TARGET_NAME;
            if (this.CURRENT_TARGET != null) {
                CraftPresence.CLIENT.syncTimestamp("data.entity.target.time");
            }
        }
        if (hasTargetNBTChanged) {
            this.CURRENT_TARGET_DATA = NEW_CURRENT_TARGET_DATA;
            NbtUtils.parseTags("data.entity.target.nbt", this.CURRENT_TARGET_DATA);
        }
        if (hasRidingChanged) {
            this.CURRENT_RIDING = NEW_CURRENT_RIDING;
            this.CURRENT_RIDING_NAME = NEW_CURRENT_RIDING_NAME;
            if (this.CURRENT_RIDING != null) {
                CraftPresence.CLIENT.syncTimestamp("data.entity.riding.time");
            }
        }
        if (hasRidingNBTChanged) {
            this.CURRENT_RIDING_DATA = NEW_CURRENT_RIDING_DATA;
            NbtUtils.parseTags("data.entity.riding.nbt", this.CURRENT_RIDING_DATA);
        }
        if (hasTargetChanged || hasRidingChanged) {
            this.updatePresence();
        }
    }

    @Override
    public void updatePresence() {
        ModuleData defaultTargetData = CraftPresence.CONFIG.advancedSettings.entitySettings.targetData.get("default");
        ModuleData defaultRidingData = CraftPresence.CONFIG.advancedSettings.entitySettings.ridingData.get("default");
        ModuleData currentTargetData = CraftPresence.CONFIG.advancedSettings.entitySettings.targetData.get(this.CURRENT_TARGET_NAME);
        ModuleData currentRidingData = CraftPresence.CONFIG.advancedSettings.entitySettings.targetData.get(this.CURRENT_RIDING_NAME);
        String defaultTargetMessage = Config.isValidProperty(defaultTargetData, "textOverride") ? defaultTargetData.getTextOverride() : "";
        String defaultRidingMessage = Config.isValidProperty(defaultRidingData, "textOverride") ? defaultRidingData.getTextOverride() : "";
        String currentTargetMessage = Config.isValidProperty(currentTargetData, "textOverride") ? currentTargetData.getTextOverride() : defaultTargetMessage;
        String currentRidingMessage = Config.isValidProperty(currentRidingData, "textOverride") ? currentRidingData.getTextOverride() : defaultRidingMessage;
        String currentTargetIcon = Config.isValidProperty(currentTargetData, "iconOverride") ? currentTargetData.getIconOverride() : this.CURRENT_TARGET_NAME;
        String currentRidingIcon = Config.isValidProperty(currentRidingData, "iconOverride") ? currentRidingData.getIconOverride() : this.CURRENT_RIDING_NAME;
        String formattedTargetIcon = CraftPresence.CLIENT.imageOf("entity.target.icon", true, currentTargetIcon, CraftPresence.CONFIG.advancedSettings.entitySettings.fallbackEntityIcon);
        String formattedRidingIcon = CraftPresence.CLIENT.imageOf("entity.riding.icon", true, currentRidingIcon, CraftPresence.CONFIG.advancedSettings.entitySettings.fallbackEntityIcon);
        CraftPresence.CLIENT.syncArgument("entity.default.icon", CraftPresence.CONFIG.advancedSettings.entitySettings.fallbackEntityIcon);
        if (this.CURRENT_TARGET != null) {
            CraftPresence.CLIENT.syncArgument("data.entity.target.instance", this.CURRENT_TARGET);
            CraftPresence.CLIENT.syncArgument("data.entity.target.class", this.CURRENT_TARGET.getClass());
            CraftPresence.CLIENT.syncArgument("entity.target.name", this.getEntityName(this.CURRENT_TARGET, this.CURRENT_TARGET_NAME));
            CraftPresence.CLIENT.syncOverride(currentTargetData != null ? currentTargetData : defaultTargetData, "entity.target.message", "entity.target.icon");
            CraftPresence.CLIENT.syncArgument("entity.target.message", currentTargetMessage);
            CraftPresence.CLIENT.syncArgument("entity.target.icon", formattedTargetIcon);
        } else {
            CraftPresence.CLIENT.removeArguments("entity.target", "data.entity.target");
        }
        if (this.CURRENT_RIDING != null) {
            CraftPresence.CLIENT.syncArgument("data.entity.riding.instance", this.CURRENT_RIDING);
            CraftPresence.CLIENT.syncArgument("data.entity.riding.class", this.CURRENT_RIDING.getClass());
            CraftPresence.CLIENT.syncArgument("entity.riding.name", this.getEntityName(this.CURRENT_RIDING, this.CURRENT_RIDING_NAME));
            CraftPresence.CLIENT.syncOverride(currentRidingData != null ? currentRidingData : defaultRidingData, "entity.riding.message", "entity.riding.icon");
            CraftPresence.CLIENT.syncArgument("entity.riding.message", currentRidingMessage);
            CraftPresence.CLIENT.syncArgument("entity.riding.icon", formattedRidingIcon);
        } else {
            CraftPresence.CLIENT.removeArguments("entity.riding", "data.entity.riding");
        }
    }

    public String getEntityName(class_864 entity, String original) {
        return StringUtils.isValidUuid(original) ? entity.method_2518() : original;
    }

    @Override
    public void getAllData() {
        if (!class_867.method_8367().isEmpty()) {
            for (Object entityLocationObj : class_867.method_8367()) {
                String entityName;
                String entityLocation = (String)entityLocationObj;
                if (entityLocation == null || this.ENTITY_NAMES.contains(entityName = StringUtils.getOrDefault(entityLocation, "generic"))) continue;
                this.ENTITY_NAMES.add(entityName);
            }
        }
        if (CraftPresence.SERVER.enabled) {
            for (class_482 playerInfo : CraftPresence.SERVER.currentPlayerList) {
                String uuidString;
                if (playerInfo == null || StringUtils.isNullOrEmpty(uuidString = playerInfo.field_1679)) continue;
                if (!this.ENTITY_NAMES.contains(uuidString)) {
                    this.ENTITY_NAMES.add(uuidString);
                }
                if (this.PLAYER_BINDINGS.containsKey(uuidString)) continue;
                this.PLAYER_BINDINGS.put(uuidString, uuidString);
            }
        }
        for (String entityTargetEntry : CraftPresence.CONFIG.advancedSettings.entitySettings.targetData.keySet()) {
            if (StringUtils.isNullOrEmpty(entityTargetEntry) || this.ENTITY_NAMES.contains(entityTargetEntry)) continue;
            this.ENTITY_NAMES.add(entityTargetEntry);
        }
        for (String entityRidingEntry : CraftPresence.CONFIG.advancedSettings.entitySettings.ridingData.keySet()) {
            if (StringUtils.isNullOrEmpty(entityRidingEntry) || this.ENTITY_NAMES.contains(entityRidingEntry)) continue;
            this.ENTITY_NAMES.add(entityRidingEntry);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean isInUse() {
        return this.isInUse;
    }

    @Override
    public void setInUse(boolean state) {
        this.isInUse = state;
    }
}

