/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils;

import com.google.common.collect.Lists;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_1071;
import net.minecraft.class_269;
import net.minecraft.class_296;
import net.minecraft.class_322;
import net.minecraft.class_348;
import net.minecraft.class_401;
import net.minecraft.class_428;
import net.minecraft.class_451;
import net.minecraft.class_474;
import net.minecraft.class_501;
import net.minecraft.class_552;
import net.minecraft.class_579;
import net.minecraft.class_605;
import net.minecraft.class_864;
import net.minecraft.class_867;

public class NbtUtils {
    public static void parseTags(String prefix, class_322 data) {
        CraftPresence.CLIENT.removeArguments(prefix);
        if (data != null) {
            for (Object tag : data.method_7347()) {
                String key = tag.toString();
                String name = prefix + "." + key;
                Object rootResult = NbtUtils.parseTag(data.method_807(key));
                if (rootResult instanceof Collection) {
                    Collection subArgs = (Collection)rootResult;
                    Object[] subArray = subArgs.toArray();
                    for (int i = 0; i < subArray.length; ++i) {
                        CraftPresence.CLIENT.syncArgument(name + "[" + i + "]", subArray[i], true);
                    }
                }
                CraftPresence.CLIENT.syncArgument(name, rootResult, true);
            }
        }
    }

    public static class_322 getNbt(Object data) {
        if (data instanceof class_864) {
            return NbtUtils.getNbt((class_864)data);
        }
        if (data instanceof class_1071) {
            return NbtUtils.getNbt((class_1071)data);
        }
        return null;
    }

    public static class_322 getNbt(class_864 entity) {
        return entity != null ? NbtUtils.serializeNBT(entity) : new class_322();
    }

    public static class_322 getNbt(class_1071 stack) {
        class_322 result = new class_322();
        return stack != null ? stack.method_3424(result) : result;
    }

    public static class_605 getNbt(Object data, String ... path) {
        if (data instanceof class_864) {
            return NbtUtils.getNbt((class_864)data, path);
        }
        if (data instanceof class_1071) {
            return NbtUtils.getNbt((class_1071)data, path);
        }
        return null;
    }

    public static class_605 getNbt(class_864 entity, String ... path) {
        return NbtUtils.getNbt(NbtUtils.getNbt(entity), path);
    }

    public static class_605 getNbt(class_1071 stack, String ... path) {
        return NbtUtils.getNbt(NbtUtils.getNbt(stack), path);
    }

    public static class_605 getNbt(class_322 root, String ... path) {
        if (path == null || path.length == 0) {
            return root;
        }
        class_322 currentTag = root;
        for (int i = 0; i < path.length; ++i) {
            if (currentTag instanceof class_322) {
                currentTag = currentTag.method_807(path[i]);
                continue;
            }
            if (currentTag instanceof class_474) {
                int index = Integer.parseInt(path[i]);
                currentTag = (class_605)((class_474)currentTag).field_1636.get(index);
                continue;
            }
            if (i == path.length - 1) break;
            return null;
        }
        return currentTag;
    }

    public static Object parseTag(class_605 tag) {
        if (tag == null) {
            return null;
        }
        switch (tag.method_1645()) {
            case 1: {
                return ((class_296)tag).method_7374();
            }
            case 2: {
                return ((class_552)tag).method_7373();
            }
            case 3: {
                return ((class_451)tag).method_7372();
            }
            case 4: {
                return ((class_501)tag).method_7371();
            }
            case 5: {
                return Float.valueOf(((class_401)tag).method_7376());
            }
            case 6: {
                return ((class_348)tag).method_7375();
            }
            case 7: {
                return ((class_269)tag).method_7340();
            }
            case 8: {
                return ((class_579)tag).method_7370();
            }
            case 9: {
                class_474 list = (class_474)tag;
                ArrayList converted = Lists.newArrayList();
                if (list.method_1219() <= 0) {
                    for (int i = 0; i < list.method_1219(); ++i) {
                        converted.add(NbtUtils.parseTag((class_605)list.field_1636.get(i)));
                    }
                }
                return converted;
            }
            case 11: {
                return ((class_428)tag).method_7349();
            }
        }
        return tag;
    }

    public static class_322 serializeNBT(class_864 entity) {
        String name = class_867.method_2573((class_864)entity);
        class_322 ret = new class_322();
        if (!StringUtils.isNullOrEmpty(name)) {
            ret.method_815("id", name);
        }
        entity.method_2542(ret);
        return ret;
    }
}

