/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils;

import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.FileUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;

public class MappingUtils {
    public static final ClassLoader CLASS_LOADER = Thread.currentThread().getContextClassLoader();
    public static final float JAVA_SPEC = Float.parseFloat(System.getProperty("java.specification.version"));
    private static Map<String, String> classMap = null;
    private static String filePath = "/mappings.srg";

    public static void setFilePath(String filePath) {
        MappingUtils.filePath = filePath;
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    public static Map<String, String> getClassMap() {
        if (classMap == null) {
            HashMap<String, String> cm = new HashMap<String, String>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(FileUtils.getResourceAsStream(MappingUtils.class, filePath)));){
                ModUtils.LOG.info("Loading Mappings...", new Object[0]);
                long time = System.nanoTime();
                String line = reader.readLine();
                while (line != null) {
                    String[] parts = line.split(" ");
                    if (parts[0].equals("CL:")) {
                        cm.put(parts[1], parts[2]);
                    }
                    line = reader.readLine();
                }
                ModUtils.LOG.info("Loaded Mappings in " + (System.nanoTime() - time) / 1000000L + "ms", new Object[0]);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            classMap = cm;
        }
        return Maps.newHashMap(classMap);
    }

    public static String getMappedPath(String input) {
        if (classMap.containsKey(input)) {
            return classMap.get(input).replace("/", ".");
        }
        return input;
    }

    public static Set<String> getUnmappedClassesMatching(String start, BiPredicate<String, String> matchCondition) {
        HashSet<String> matches = new HashSet<String>();
        start = start.replace(".", "/");
        for (Map.Entry<String, String> entry : classMap.entrySet()) {
            if (!matchCondition.test(entry.getValue(), start)) continue;
            matches.add(entry.getKey().replace("/", "."));
        }
        return matches;
    }

    public static Set<String> getUnmappedClassesMatching(String start, boolean exact) {
        return MappingUtils.getUnmappedClassesMatching(start, exact ? String::equals : String::startsWith);
    }

    public static Set<String> getUnmappedClassesMatching(String start) {
        return MappingUtils.getUnmappedClassesMatching(start, false);
    }

    public static String getClassName(Class<?> object, boolean simpleName) {
        String result = classMap.get(object.getName().replace(".", "/"));
        result = result == null ? (simpleName ? object.getSimpleName() : object.getName()) : (simpleName ? result.substring(result.lastIndexOf("/") + 1) : result.replace("/", "."));
        return result;
    }

    public static String getCanonicalName(Class<?> object) {
        return MappingUtils.getClassName(object, false);
    }

    public static String getCanonicalName(Object object) {
        return MappingUtils.getCanonicalName(object.getClass());
    }

    public static String getClassName(Class<?> object) {
        return MappingUtils.getClassName(object, true);
    }

    public static String getClassName(Object object) {
        return MappingUtils.getClassName(object.getClass());
    }
}

