/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.config.gui.MainGui;
import fabric.com.gitlab.cdagaming.craftpresence.impl.KeyConverter;
import fabric.com.gitlab.cdagaming.craftpresence.impl.Pair;
import fabric.com.gitlab.cdagaming.craftpresence.impl.Tuple;
import fabric.com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_327;
import net.minecraft.class_362;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.input.Keyboard;

public class KeyUtils {
    private static final List<Integer> clearKeys = Lists.newArrayList();
    private static final List<Integer> invalidKeys = Lists.newArrayList();
    private final Map<String, Tuple<class_327, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>>> KEY_MAPPINGS = Maps.newHashMap();
    public Map<String, Integer> keySyncQueue = Maps.newHashMap();
    private boolean keysRegistered = false;

    public static boolean isValidKeyCode(int sourceKeyCode) {
        return !invalidKeys.contains(sourceKeyCode);
    }

    public static boolean isValidClearCode(int sourceKeyCode) {
        if (clearKeys.isEmpty()) {
            clearKeys.add(ModUtils.MCProtocolID > 340 ? 256 : 1);
        }
        return clearKeys.contains(sourceKeyCode);
    }

    public static String getKeyName(int original) {
        int unknownKeyCode = ModUtils.MCProtocolID <= 340 ? -1 : 0;
        String unknownKeyName = (ModUtils.MCProtocolID <= 340 ? KeyConverter.fromGlfw.get(unknownKeyCode) : KeyConverter.toGlfw.get(unknownKeyCode)).getSecond();
        if (KeyUtils.isValidKeyCode(original)) {
            if (ModUtils.MCProtocolID <= 340 && KeyConverter.toGlfw.containsKey(original)) {
                return KeyConverter.toGlfw.get(original).getSecond();
            }
            if (ModUtils.MCProtocolID > 340 && KeyConverter.fromGlfw.containsKey(original)) {
                return KeyConverter.fromGlfw.get(original).getSecond();
            }
            String altKeyName = Integer.toString(original);
            String keyName = original != unknownKeyCode ? Keyboard.getKeyName((int)original) : unknownKeyName;
            return StringUtils.getOrDefault(keyName, altKeyName);
        }
        return unknownKeyName;
    }

    void register() {
        this.KEY_MAPPINGS.put("configKeyCode", new Tuple<class_327, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Object>(new class_327("key.craftpresence.config_keycode.name", CraftPresence.CONFIG.accessibilitySettings.configKeyCode, "key.craftpresence.category"), new Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>(() -> {
            if (!CraftPresence.GUIS.isFocused && !CraftPresence.GUIS.configGUIOpened) {
                CraftPresence.GUIS.openScreen(new MainGui(CraftPresence.instance.field_3816));
            }
        }, (keyCode, shouldSave) -> {
            CraftPresence.CONFIG.accessibilitySettings.configKeyCode = keyCode;
            if (shouldSave.booleanValue()) {
                CraftPresence.CONFIG.save();
            }
        }, vanillaBind -> vanillaBind != CraftPresence.CONFIG.accessibilitySettings.configKeyCode), null));
    }

    public boolean areKeysRegistered() {
        return this.keysRegistered;
    }

    public Map<String, Tuple<class_327, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>>> getRawKeyMappings() {
        return Maps.newHashMap(this.KEY_MAPPINGS);
    }

    public String getKeyName(String original) {
        String unknownKeyName = (ModUtils.MCProtocolID <= 340 ? KeyConverter.fromGlfw.get(-1) : KeyConverter.toGlfw.get(0)).getSecond();
        if (!StringUtils.isNullOrEmpty(original)) {
            Pair<Boolean, Integer> integerData = StringUtils.getValidInteger(original);
            if (integerData.getFirst().booleanValue()) {
                return KeyUtils.getKeyName(integerData.getSecond());
            }
            return unknownKeyName;
        }
        return unknownKeyName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onTick() {
        block18: {
            if (!this.keysRegistered) {
                if (CraftPresence.instance.field_3823 != null) {
                    for (Map.Entry<String, Tuple<class_327, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>>> entry : this.KEY_MAPPINGS.entrySet()) {
                        class_327 mapping = entry.getValue().getFirst();
                        CraftPresence.instance.field_3823.field_945 = (class_327[])ArrayUtils.add((Object[])CraftPresence.instance.field_3823.field_945, (Object)mapping);
                    }
                    this.keysRegistered = true;
                } else {
                    return;
                }
            }
            if (Keyboard.isCreated() && CraftPresence.CONFIG != null) {
                int unknownKeyCode = ModUtils.MCProtocolID <= 340 ? -1 : 0;
                String unknownKeyName = (ModUtils.MCProtocolID <= 340 ? KeyConverter.fromGlfw.get(unknownKeyCode) : KeyConverter.toGlfw.get(unknownKeyCode)).getSecond();
                try {
                    for (Map.Entry entry : this.KEY_MAPPINGS.entrySet()) {
                        String keyName = (String)entry.getKey();
                        Tuple keyData = (Tuple)entry.getValue();
                        class_327 keyBind = (class_327)keyData.getFirst();
                        Tuple callbackData = (Tuple)keyData.getSecond();
                        int currentBind = keyBind.method_6623();
                        boolean hasBeenRun = false;
                        if (!KeyUtils.getKeyName(currentBind).equals(unknownKeyName) && !KeyUtils.isValidClearCode(currentBind) && Keyboard.isKeyDown((int)currentBind) && !(CraftPresence.instance.field_3816 instanceof class_362)) {
                            try {
                                ((Runnable)callbackData.getFirst()).run();
                            }
                            catch (Throwable ex) {
                                if (keyData.getThird() != null) {
                                    ((Consumer)keyData.getThird()).accept(ex);
                                } else {
                                    ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.keycode", keyBind.method_6621()), new Object[0]);
                                    this.syncKeyData(keyName, ImportMode.Specific, keyBind.method_6622());
                                }
                            }
                            finally {
                                hasBeenRun = true;
                            }
                        }
                        if (hasBeenRun || CraftPresence.CONFIG.hasChanged) continue;
                        if (this.keySyncQueue.containsKey(keyName)) {
                            this.syncKeyData(keyName, ImportMode.Config, this.keySyncQueue.get(keyName));
                            this.keySyncQueue.remove(keyName);
                            continue;
                        }
                        if (!((Predicate)callbackData.getThird()).test(currentBind)) continue;
                        this.syncKeyData(keyName, ImportMode.Vanilla, currentBind);
                    }
                }
                catch (Throwable ex) {
                    if (!CommandUtils.isVerboseMode()) break block18;
                    ex.printStackTrace();
                }
            }
        }
    }

    private void syncKeyData(String keyName, ImportMode mode, int keyCode) {
        Tuple keyData = this.KEY_MAPPINGS.getOrDefault(keyName, null);
        if (mode == ImportMode.Config) {
            ((class_327)keyData.getFirst()).method_6617(keyCode);
        } else if (mode == ImportMode.Vanilla) {
            ((BiConsumer)((Tuple)keyData.getSecond()).getSecond()).accept(keyCode, true);
        } else if (mode == ImportMode.Specific) {
            this.syncKeyData(((class_327)keyData.getFirst()).method_6621(), ImportMode.Config, keyCode);
            this.syncKeyData(keyName, ImportMode.Vanilla, keyCode);
        } else if (CommandUtils.isVerboseMode()) {
            ModUtils.LOG.debugWarn(ModUtils.TRANSLATOR.translate("craftpresence.logger.warning.convert.invalid", keyName, mode.name()), new Object[0]);
        }
    }

    public Map<String, Tuple<class_327, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>>> getKeyMappings(FilterMode mode, List<String> filterData) {
        HashMap filteredMappings = Maps.newHashMap();
        for (Map.Entry<String, Tuple<class_327, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>>> entry : this.KEY_MAPPINGS.entrySet()) {
            String keyName = entry.getKey();
            if (mode != FilterMode.None && mode != FilterMode.Category && mode != FilterMode.Id && (mode != FilterMode.Name || !filterData.contains(keyName))) continue;
            Tuple<class_327, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>> keyData = entry.getValue();
            if (!(mode == FilterMode.None || mode == FilterMode.Category && filterData.contains(keyData.getFirst().method_6620()) || mode == FilterMode.Id && filterData.contains(keyData.getFirst().method_6621())) && mode != FilterMode.Name) continue;
            filteredMappings.put(keyName, keyData);
        }
        return filteredMappings;
    }

    public Map<String, Tuple<class_327, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>>> getKeyMappings() {
        return this.getKeyMappings(FilterMode.None, Lists.newArrayList());
    }

    public static enum ImportMode {
        Config,
        Vanilla,
        Specific;

    }

    public static enum FilterMode {
        Category,
        Name,
        Id,
        None;

    }
}

