/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.config.gui;

import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.config.Config;
import fabric.com.gitlab.cdagaming.craftpresence.config.category.Server;
import fabric.com.gitlab.cdagaming.craftpresence.config.element.ModuleData;
import fabric.com.gitlab.cdagaming.craftpresence.config.element.PresenceData;
import fabric.com.gitlab.cdagaming.craftpresence.config.gui.PresenceSettingsGui;
import fabric.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.impl.SelectorGui;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import net.minecraft.class_388;

public class ServerSettingsGui
extends ExtendedScreen {
    private final Server CONFIG;
    private ExtendedButtonControl proceedButton;
    private ExtendedButtonControl serverMessagesButton;
    private ExtendedTextControl defaultMOTD;
    private ExtendedTextControl defaultName;
    private ExtendedTextControl defaultMessage;

    ServerSettingsGui(class_388 parentScreen) {
        super(parentScreen);
        this.CONFIG = CraftPresence.CONFIG.serverSettings;
    }

    @Override
    public void initializeUi() {
        ModuleData defaultData = this.CONFIG.serverData.get("default");
        String defaultServerMessage = Config.getProperty(defaultData, "textOverride") != null ? defaultData.getTextOverride() : "";
        this.defaultName = this.addControl(new ExtendedTextControl(this.getFontRenderer(), this.getScreenWidth() / 2 + 3, CraftPresence.GUIS.getButtonY(1), 180, 20));
        this.defaultName.setControlMessage(this.CONFIG.fallbackServerName);
        this.defaultMOTD = this.addControl(new ExtendedTextControl(this.getFontRenderer(), this.getScreenWidth() / 2 + 3, CraftPresence.GUIS.getButtonY(2), 180, 20));
        this.defaultMOTD.setControlMessage(this.CONFIG.fallbackServerMotd);
        this.defaultMessage = this.addControl(new ExtendedTextControl(this.getFontRenderer(), this.getScreenWidth() / 2 + 3, CraftPresence.GUIS.getButtonY(3), 180, 20));
        this.defaultMessage.setControlMessage(defaultServerMessage);
        this.serverMessagesButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, CraftPresence.GUIS.getButtonY(4), 180, 20, "gui.config.name.server_messages.server_messages", () -> CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.server", new Object[0]), CraftPresence.SERVER.knownAddresses, null, null, true, true, ScrollableListControl.RenderType.ServerData, (attributeName, currentValue) -> {
            ModuleData defaultServerData = this.CONFIG.serverData.get("default");
            ModuleData currentServerData = this.CONFIG.serverData.get(attributeName);
            String defaultMessage = Config.getProperty(defaultServerData, "textOverride") != null ? defaultServerData.getTextOverride() : "";
            String currentMessage = Config.getProperty(currentServerData, "textOverride") != null ? currentServerData.getTextOverride() : "";
            CraftPresence.CONFIG.hasChanged = true;
            ModuleData newData = new ModuleData();
            if (StringUtils.isNullOrEmpty(currentMessage) || currentMessage.equals(defaultMessage)) {
                newData.setTextOverride(defaultMessage);
            }
            newData.setIconOverride((String)currentValue);
            this.CONFIG.serverData.put((String)attributeName, newData);
        }, (currentValue, parentScreen) -> CraftPresence.GUIS.openScreen(new DynamicEditorGui((class_388)parentScreen, (String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.CONFIG.serverData.get("default");
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage;
        }, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.CONFIG.serverData.get("default");
            screenInstance.currentData = this.CONFIG.serverData.get(attributeName);
            screenInstance.isPreliminaryData = screenInstance.currentData == null;
            screenInstance.mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title.server.edit_specific_server", attributeName);
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = Config.getProperty(screenInstance.currentData, "textOverride") != null ? screenInstance.currentData.getTextOverride() : screenInstance.originalPrimaryMessage;
        }, (screenInstance, attributeName, inputText) -> {
            screenInstance.currentData.setTextOverride((String)inputText);
            CraftPresence.CONFIG.hasChanged = true;
            this.CONFIG.serverData.put((String)attributeName, screenInstance.currentData);
            if (!CraftPresence.SERVER.knownAddresses.contains(attributeName)) {
                CraftPresence.SERVER.knownAddresses.add((String)attributeName);
            }
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            this.CONFIG.serverData.remove(attributeName);
            if (!screenInstance.isPreliminaryData) {
                CraftPresence.SERVER.knownAddresses.remove(attributeName);
            }
        }, (attributeName, screenInstance, isPresenceButton) -> {
            if (isPresenceButton.booleanValue()) {
                PresenceData defaultPresenceData = Config.getProperty(screenInstance.defaultData, "data") != null ? screenInstance.defaultData.getData() : new PresenceData();
                PresenceData currentPresenceData = Config.getProperty(screenInstance.currentData, "data") != null ? screenInstance.currentData.getData() : defaultPresenceData;
                CraftPresence.GUIS.openScreen(new PresenceSettingsGui((class_388)screenInstance, currentPresenceData, output -> screenInstance.currentData.setData((PresenceData)output)));
            } else {
                String defaultIcon = Config.getProperty(screenInstance.defaultData, "iconOverride") != null ? screenInstance.defaultData.getIconOverride() : this.CONFIG.fallbackServerIcon;
                String specificIcon = Config.getProperty(screenInstance.currentData, "iconOverride") != null ? screenInstance.currentData.getIconOverride() : defaultIcon;
                CraftPresence.GUIS.openScreen(new SelectorGui((class_388)screenInstance, ModUtils.TRANSLATOR.translate("gui.config.title.selector.icon", new Object[0]), DiscordAssetUtils.ASSET_LIST.keySet(), specificIcon, (String)attributeName, true, false, ScrollableListControl.RenderType.DiscordAsset, (innerAttributeName, innerCurrentValue) -> screenInstance.currentData.setIconOverride((String)innerCurrentValue), null));
            }
        }, (attributeName, screenInstance) -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.server_messages.server_messages", CraftPresence.CLIENT.generateArgumentMessage("server.", "world.", "player."))), (ExtendedScreen)((Object)((Object)((Object)screenInstance))), true))))), () -> {
            if (!this.serverMessagesButton.isControlEnabled()) {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.hover.access", ModUtils.TRANSLATOR.translate("gui.config.name.server_messages.server_messages", new Object[0]))), this, true);
            } else {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.server_messages.server_messages", CraftPresence.CLIENT.generateArgumentMessage("server.", "world.", "player."))), this, true);
            }
        }, new String[0]));
        this.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, CraftPresence.GUIS.getButtonY(5), 180, 20, "gui.config.name.server_messages.server_icon", () -> CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.icon", new Object[0]), DiscordAssetUtils.ASSET_LIST.keySet(), this.CONFIG.fallbackServerIcon, null, true, false, ScrollableListControl.RenderType.DiscordAsset, (attributeName, currentValue) -> {
            CraftPresence.CONFIG.hasChanged = true;
            CraftPresence.CONFIG.hasClientPropertiesChanged = true;
            this.CONFIG.fallbackServerIcon = currentValue;
        }, null)), () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.server_messages.server_icon", new Object[0])), this, true), new String[0]));
        this.proceedButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getScreenHeight() - 30, 180, 20, "gui.config.message.button.back", () -> {
            if (!this.defaultName.getControlMessage().equals(this.CONFIG.fallbackServerName)) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.hasClientPropertiesChanged = true;
                this.CONFIG.fallbackServerName = this.defaultName.getControlMessage();
            }
            if (!this.defaultMOTD.getControlMessage().equals(this.CONFIG.fallbackServerMotd)) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.hasClientPropertiesChanged = true;
                this.CONFIG.fallbackServerMotd = this.defaultMOTD.getControlMessage();
            }
            if (!this.defaultMessage.getControlMessage().equals(defaultServerMessage)) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.hasClientPropertiesChanged = true;
                ModuleData defaultServerData = this.CONFIG.serverData.getOrDefault("default", new ModuleData());
                defaultServerData.setTextOverride(this.defaultMessage.getControlMessage());
                this.CONFIG.serverData.put("default", defaultServerData);
            }
            CraftPresence.GUIS.openScreen(this.parentScreen);
        }, () -> {
            if (!this.proceedButton.isControlEnabled()) {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.hover.empty.default", new Object[0])), this, true);
            }
        }, new String[0]));
        super.initializeUi();
    }

    @Override
    public void preRender() {
        String mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title", new Object[0]);
        String subTitle = ModUtils.TRANSLATOR.translate("gui.config.title.server_messages", new Object[0]);
        String serverNameText = ModUtils.TRANSLATOR.translate("gui.config.name.server_messages.server_name", new Object[0]);
        String serverMOTDText = ModUtils.TRANSLATOR.translate("gui.config.name.server_messages.server_motd", new Object[0]);
        String defaultMessageText = ModUtils.TRANSLATOR.translate("gui.config.message.default.server", new Object[0]);
        this.renderString(mainTitle, (float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(mainTitle) / 2.0f, 10.0f, 0xFFFFFF);
        this.renderString(subTitle, (float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(subTitle) / 2.0f, 20.0f, 0xFFFFFF);
        this.renderString(serverNameText, (float)this.getScreenWidth() / 2.0f - 130.0f, CraftPresence.GUIS.getButtonY(1, 5), 0xFFFFFF);
        this.renderString(serverMOTDText, (float)this.getScreenWidth() / 2.0f - 130.0f, CraftPresence.GUIS.getButtonY(2, 5), 0xFFFFFF);
        this.renderString(defaultMessageText, (float)this.getScreenWidth() / 2.0f - 130.0f, CraftPresence.GUIS.getButtonY(3, 5), 0xFFFFFF);
        this.proceedButton.setControlEnabled(!StringUtils.isNullOrEmpty(this.defaultMessage.getControlMessage()) || !StringUtils.isNullOrEmpty(this.defaultName.getControlMessage()) || !StringUtils.isNullOrEmpty(this.defaultMOTD.getControlMessage()));
        this.serverMessagesButton.setControlEnabled(CraftPresence.SERVER.enabled);
    }

    @Override
    public void postRender() {
        String serverNameText = ModUtils.TRANSLATOR.translate("gui.config.name.server_messages.server_name", new Object[0]);
        String serverMOTDText = ModUtils.TRANSLATOR.translate("gui.config.name.server_messages.server_motd", new Object[0]);
        String defaultMessageText = ModUtils.TRANSLATOR.translate("gui.config.message.default.server", new Object[0]);
        if (CraftPresence.GUIS.isMouseOver(this.getMouseX(), this.getMouseY(), (float)this.getScreenWidth() / 2.0f - 130.0f, CraftPresence.GUIS.getButtonY(1, 5), this.getStringWidth(serverNameText), this.getFontHeight())) {
            CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.server_messages.server_name", new Object[0])), this, true);
        }
        if (CraftPresence.GUIS.isMouseOver(this.getMouseX(), this.getMouseY(), (float)this.getScreenWidth() / 2.0f - 130.0f, CraftPresence.GUIS.getButtonY(2, 5), this.getStringWidth(serverMOTDText), this.getFontHeight())) {
            CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.server_messages.server_motd", new Object[0])), this, true);
        }
        if (CraftPresence.GUIS.isMouseOver(this.getMouseX(), this.getMouseY(), (float)this.getScreenWidth() / 2.0f - 130.0f, CraftPresence.GUIS.getButtonY(3, 5), this.getStringWidth(defaultMessageText), this.getFontHeight())) {
            CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.server_messages.server_messages", CraftPresence.CLIENT.generateArgumentMessage("server.", "world.", "player."))), this, true);
        }
    }
}

