/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence;

import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import net.minecraft.class_864;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModLogger {
    private final String loggerName;
    private final Logger logInstance;

    ModLogger(String loggerName) {
        this.loggerName = loggerName;
        this.logInstance = LogManager.getLogger((String)loggerName);
    }

    public Logger getLogInstance() {
        return this.logInstance;
    }

    public void error(String logMessage, Object ... logArguments) {
        String message = String.format(logMessage, logArguments);
        if (this.canShowAsChat()) {
            StringUtils.sendMessageToPlayer((class_864)CraftPresence.player, "\u00a76\u00a7l[\u00a7f\u00a7l" + this.loggerName + "\u00a76]\u00a7r\u00a7c " + message);
        } else {
            this.getLogInstance().error(message);
        }
    }

    public void warn(String logMessage, Object ... logArguments) {
        String message = String.format(logMessage, logArguments);
        if (this.canShowAsChat()) {
            StringUtils.sendMessageToPlayer((class_864)CraftPresence.player, "\u00a76\u00a7l[\u00a7f\u00a7l" + this.loggerName + "\u00a76]\u00a7r\u00a7e " + message);
        } else {
            this.getLogInstance().warn(message);
        }
    }

    public void info(String logMessage, Object ... logArguments) {
        String message = String.format(logMessage, logArguments);
        if (this.canShowAsChat()) {
            StringUtils.sendMessageToPlayer((class_864)CraftPresence.player, "\u00a76\u00a7l[\u00a7f\u00a7l" + this.loggerName + "\u00a76]\u00a7r " + message);
        } else {
            this.getLogInstance().info(message);
        }
    }

    public void debugInfo(String logMessage, Object ... logArguments) {
        if (CommandUtils.isDebugMode()) {
            this.info("[DEBUG] " + logMessage, logArguments);
        }
    }

    public void debugWarn(String logMessage, Object ... logArguments) {
        if (CommandUtils.isDebugMode()) {
            this.warn("[DEBUG] " + logMessage, logArguments);
        }
    }

    public void debugError(String logMessage, Object ... logArguments) {
        if (CommandUtils.isDebugMode()) {
            this.error("[DEBUG] " + logMessage, logArguments);
        }
    }

    public boolean canShowAsChat() {
        return CraftPresence.player != null && !CraftPresence.CONFIG.hasChanged && !CraftPresence.SYSTEM.IS_GAME_CLOSING && CraftPresence.CONFIG.accessibilitySettings.showLoggingInChat;
    }
}

