/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.util;

import cpw.mods.fml.repackage.com.nothome.delta.SeekableSource;
import java.io.IOException;
import java.nio.ByteBuffer;

public class FastByteBufferSeekableSource
implements SeekableSource {
    private ByteBuffer bb;
    private ByteBuffer cur;

    public FastByteBufferSeekableSource(byte[] source) {
        this(ByteBuffer.wrap(source));
    }

    public FastByteBufferSeekableSource(ByteBuffer bb) {
        if (bb == null) {
            throw new NullPointerException("bb");
        }
        this.bb = bb;
        bb.rewind();
        try {
            this.seek(0L);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void seek(long pos) throws IOException {
        this.cur = this.bb.slice();
        if (pos > (long)this.cur.limit()) {
            throw new IOException("pos " + pos + " cannot seek " + this.cur.limit());
        }
        this.cur.position((int)pos);
    }

    public int read(ByteBuffer dest) throws IOException {
        if (!this.cur.hasRemaining()) {
            return -1;
        }
        int c = Math.min(this.cur.remaining(), dest.remaining());
        int oldLim = this.cur.limit();
        this.cur.limit(this.cur.position() + c);
        dest.put(this.cur);
        this.cur.limit(oldLim);
        return c;
    }

    public void close() throws IOException {
        this.bb = null;
        this.cur = null;
    }

    public String toString() {
        return "BBSeekable bb=" + this.bb.position() + "-" + this.bb.limit() + " cur=" + this.cur.position() + "-" + this.cur.limit() + "";
    }
}

