/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.container.slot;

import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.cookingforblockheads.api.kitchen.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.registry.food.FoodIngredient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2FPacketSetSlot;

public class SlotCraftMatrix
extends Slot {
    private static final int ITEM_SWITCH_TIME = 20;
    private final EntityPlayer player;
    private FoodIngredient ingredient;
    private boolean enabled = true;
    private List<IInventory> sourceInventories;
    private List<IKitchenItemProvider> itemProviders;
    private boolean isNoFilter;
    private ItemStack[] visibleStacks;
    private int visibleItemTime;
    private int visibleItemIndex;

    public SlotCraftMatrix(EntityPlayer player, IInventory inventory, int index, int x, int y) {
        super(inventory, index, x, y);
        this.player = player;
    }

    public boolean func_75214_a(ItemStack itemStack) {
        return false;
    }

    public boolean func_82869_a(EntityPlayer player) {
        return false;
    }

    public void setIngredient(FoodIngredient ingredient) {
        this.ingredient = ingredient;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean func_111238_b() {
        return this.enabled;
    }

    public void updateVisibleStacks() {
        if (this.ingredient != null) {
            this.visibleStacks = this.ingredient.getItemStacks();
            if (!this.isNoFilter && this.ingredient.getItemStacks().length > 1 && !this.ingredient.isToolItem()) {
                ArrayList<ItemStack> visibleStackList = new ArrayList<ItemStack>();
                block0: for (ItemStack visibleStack : this.visibleStacks) {
                    for (int i = 0; i < this.sourceInventories.size(); ++i) {
                        for (int j = 0; j < this.sourceInventories.get(i).func_70302_i_(); ++j) {
                            ItemStack itemStack = this.sourceInventories.get(i).func_70301_a(j);
                            if (!CookingRegistry.areItemStacksEqualWithWildcard(itemStack, visibleStack)) continue;
                            ItemStack displayStack = visibleStack.func_77946_l();
                            if (displayStack.func_77960_j() == Short.MAX_VALUE) {
                                displayStack.func_77964_b(0);
                            }
                            visibleStackList.add(displayStack);
                            continue block0;
                        }
                    }
                    for (IKitchenItemProvider provider : this.itemProviders) {
                        for (ItemStack itemStack : provider.getProvidedItemStacks()) {
                            if (!CookingRegistry.areItemStacksEqualWithWildcard(itemStack, visibleStack)) continue;
                            ItemStack displayStack = visibleStack.func_77946_l();
                            if (displayStack.func_77960_j() == Short.MAX_VALUE) {
                                displayStack.func_77964_b(0);
                            }
                            visibleStackList.add(displayStack);
                            continue block0;
                        }
                    }
                }
                this.visibleStacks = visibleStackList.toArray(new ItemStack[visibleStackList.size()]);
            } else {
                for (int i = 0; i < this.visibleStacks.length; ++i) {
                    ItemStack displayStack = this.visibleStacks[i].func_77946_l();
                    if (displayStack.func_77960_j() == Short.MAX_VALUE) {
                        displayStack.func_77964_b(0);
                    }
                    this.visibleStacks[i] = displayStack;
                }
            }
            if (this.visibleStacks.length == 1) {
                this.func_75215_d(this.visibleStacks[0]);
                ((EntityPlayerMP)this.player).field_71135_a.func_147359_a((Packet)new S2FPacketSetSlot(this.player.field_71070_bA.field_75152_c, this.field_75222_d, this.visibleStacks[0]));
            }
            this.visibleItemTime = 20;
            this.visibleItemIndex = 0;
        } else {
            this.func_75215_d(null);
            ((EntityPlayerMP)this.player).field_71135_a.func_147359_a((Packet)new S2FPacketSetSlot(this.player.field_71070_bA.field_75152_c, this.field_75222_d, null));
            this.visibleStacks = null;
        }
        this.update();
    }

    public void update() {
        if (this.visibleStacks != null && this.visibleStacks.length > 1) {
            ++this.visibleItemTime;
            if (this.visibleItemTime >= 20) {
                ++this.visibleItemIndex;
                if (this.visibleItemIndex >= this.visibleStacks.length) {
                    this.visibleItemIndex = 0;
                }
                this.func_75215_d(this.visibleStacks[this.visibleItemIndex]);
                ((EntityPlayerMP)this.player).field_71135_a.func_147359_a((Packet)new S2FPacketSetSlot(this.player.field_71070_bA.field_75152_c, this.field_75222_d, this.visibleStacks[this.visibleItemIndex]));
                this.visibleItemTime = 0;
            }
        }
    }

    public void setSourceInventories(List<IInventory> sourceInventories) {
        this.sourceInventories = sourceInventories;
    }

    public void setItemProviders(List<IKitchenItemProvider> itemProviders) {
        this.itemProviders = itemProviders;
    }

    public void setNoFilter(boolean isNoFilter) {
        this.isNoFilter = isNoFilter;
    }
}

