/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.tis3d.serial;

import li.cil.tis3d.api.serial.SerialInterface;
import li.cil.tis3d.api.serial.SerialInterfaceProvider;
import li.cil.tis3d.api.serial.SerialProtocolDocumentationReference;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public abstract class TileInterfaceProvider
implements SerialInterfaceProvider {
    protected final Class<?> tileClass;
    protected final String name;
    protected final String link;

    public TileInterfaceProvider(Class<?> tileClass, String name, String link) {
        this.tileClass = tileClass;
        this.name = name;
        this.link = link;
    }

    public boolean worksWith(World world, int x, int y, int z, EnumFacing side) {
        if (this.tileClass == null) {
            return false;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        return tile != null && this.tileClass.isInstance(tile);
    }

    public SerialProtocolDocumentationReference getDocumentationReference() {
        return new SerialProtocolDocumentationReference("tooltip.computronics.manual.tis3d.port." + this.name, "protocols/computronics/" + this.link);
    }

    protected abstract boolean isStillValid(World var1, int var2, int var3, int var4, EnumFacing var5, SerialInterface var6, TileEntity var7);

    public boolean isValid(World world, int x, int y, int z, EnumFacing side, SerialInterface serialInterface) {
        if (this.tileClass == null) {
            return false;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        return tile != null && this.isStillValid(world, x, y, z, side, serialInterface, tile);
    }
}

