/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.util.chat;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.WeakHashMap;
import net.minecraftforge.event.ServerChatEvent;
import pl.asie.computronics.api.chat.ChatAPI;
import pl.asie.computronics.api.chat.IChatListener;
import pl.asie.computronics.api.chat.IChatListenerRegistry;

public class ChatHandler
implements IChatListenerRegistry {
    private final WeakHashMap<IChatListener, Object> listeners = new WeakHashMap();
    private final WeakHashMap<IChatListener, Object> invalidated = new WeakHashMap();
    private static final Object EMPTY = new Object();

    public ChatHandler() {
        ChatAPI.registry = this;
    }

    @SubscribeEvent
    public void chatEvent(ServerChatEvent event) {
        for (IChatListener l : this.listeners.keySet()) {
            if (!l.isValid()) {
                this.invalidated.put(l, EMPTY);
                continue;
            }
            l.receiveChatMessage(event);
        }
        for (IChatListener l : this.invalidated.keySet()) {
            this.listeners.remove(l);
        }
        this.invalidated.clear();
    }

    @Override
    public void registerChatListener(IChatListener listener) {
        this.listeners.put(listener, EMPTY);
    }

    @Override
    public void unregisterChatListener(IChatListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean isListenerRegistered(IChatListener listener) {
        return this.listeners.containsKey(listener);
    }
}

