/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.tis3d.module;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import li.cil.tis3d.api.FontRendererAPI;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.util.RenderUtil;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import pl.asie.computronics.integration.tis3d.IntegrationTIS3D;
import pl.asie.computronics.integration.tis3d.module.ComputronicsModule;
import pl.asie.computronics.util.boom.SelfDestruct;

public class ModuleBoom
extends ComputronicsModule {
    private short steps = (short)-1;
    private static final ResourceLocation ICON = new ResourceLocation("computronics:textures/blocks/tis3d/module_boom.png");

    public ModuleBoom(Casing casing, Face face) {
        super(casing, face);
    }

    public void step() {
        super.step();
        if (this.steps == 0) {
            IntegrationTIS3D.boomHandler.queueBoom(this.getCasing());
        } else if (this.steps > 0) {
            this.steps = (short)(this.steps - 1);
            this.sendDataToClient();
        }
        for (Port port : Port.VALUES) {
            Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
            if (!receivingPipe.isReading()) {
                receivingPipe.beginRead();
            }
            if (!receivingPipe.canTransfer()) continue;
            short newstep = receivingPipe.read();
            if (newstep < 0) {
                return;
            }
            if (this.steps < 0 || newstep < this.steps) {
                this.steps = newstep;
                this.sendDataToClient();
            }
            receivingPipe.beginRead();
        }
    }

    public void onDisabled() {
        this.steps = (short)-1;
        this.sendDataToClient();
    }

    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.steps = nbt.func_74764_b("steps") ? nbt.func_74765_d("steps") : (short)-1;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        if (this.steps >= 0) {
            nbt.func_74777_a("steps", this.steps);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void render(boolean enabled, float partialTicks) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        int alpha = 68;
        int maxAlpha = enabled && this.steps < 0 ? 136 : 255;
        int speed = this.steps < 0 ? 100 : 20;
        alpha = enabled ? 68 + (int)((double)(maxAlpha - alpha) * ((Math.sin((double)((float)(this.getCasing().getCasingWorld().func_82737_E() + (long)(((Object)((Object)this)).hashCode() % speed)) + partialTicks) / (double)speed * 2.0 * Math.PI) + 1.0) / 2.0)) : 68;
        RenderUtil.bindTexture((ResourceLocation)ICON);
        GL11.glColor4ub((byte)-1, (byte)0, (byte)0, (byte)((byte)(alpha & 0xFF)));
        RenderUtil.drawQuad();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!enabled) {
            return;
        }
        if (this.steps >= 0) {
            String s = String.format("%05d", this.steps);
            int scale = FontRendererAPI.getCharHeight();
            GL11.glTranslatef((float)((float)FontRendererAPI.getCharWidth() / 15.0f), (float)0.4375f, (float)0.0f);
            GL11.glScalef((float)((float)scale / 128.0f), (float)((float)scale / 128.0f), (float)1.0f);
            FontRendererAPI.drawString((String)s);
        }
        GL11.glDisable((int)3042);
    }

    public static class BoomHandler {
        private final List<Casing> boomQueue = new ArrayList<Casing>();

        @SubscribeEvent(priority=EventPriority.HIGH)
        @Optional.Method(modid="tis3d")
        public void onServerTick(TickEvent.ServerTickEvent e) {
            if (e.phase != TickEvent.Phase.START || this.boomQueue.isEmpty()) {
                return;
            }
            for (Casing casing : this.boomQueue) {
                if (casing == null || casing.getCasingWorld() == null) continue;
                SelfDestruct.goBoom(casing.getCasingWorld(), casing.getPositionX(), casing.getPositionY(), casing.getPositionZ(), true);
            }
            this.boomQueue.clear();
        }

        @Optional.Method(modid="tis3d")
        public void queueBoom(Casing casing) {
            if (!this.boomQueue.contains(casing)) {
                this.boomQueue.add(casing);
            }
        }
    }
}

