/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.audio.tts;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.exceptions.SynthesisException;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.audio.tts.TextToSpeech;
import pl.asie.lib.audio.DFPWM;

public class SynthesizeTask
implements Callable<TextToSpeech.Result> {
    private final WeakReference<TextToSpeech.ICanSpeak> device;
    private final String text;

    public SynthesizeTask(TextToSpeech.ICanSpeak device, String text) {
        this.device = new WeakReference<TextToSpeech.ICanSpeak>(device);
        this.text = text;
    }

    @Override
    @Nullable
    public TextToSpeech.Result call() throws Exception {
        if (Computronics.tts.marytts == null) {
            return null;
        }
        try {
            int read;
            AudioInputStream audio = Computronics.tts.marytts.generateAudio(this.text);
            AudioFormat convertFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 32768.0f, 8, 1, 1, 32768.0f, false);
            AudioInputStream inFile = AudioSystem.getAudioInputStream(convertFormat, audio);
            byte[] readBuffer = new byte[1024];
            byte[] outBuffer = new byte[readBuffer.length / 8];
            DFPWM converter = new DFPWM();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            do {
                int amt;
                for (read = 0; read < readBuffer.length && (amt = inFile.read(readBuffer, read, readBuffer.length - read)) != -1; read += amt) {
                }
                converter.compress(outBuffer, readBuffer, 0, 0, (read &= 0xFFFFFFF8) / 8);
                out.write(outBuffer, 0, read / 8);
            } while (read == readBuffer.length);
            outBuffer = new byte[4096];
            converter.compress(outBuffer, new byte[32768], 0, 0, 4096);
            out.write(outBuffer);
            return new TextToSpeech.Result(this.device, out.toByteArray());
        }
        catch (SynthesisException e) {
            TextToSpeech.log.error("Text To Speech synthesis failed");
            e.printStackTrace();
        }
        catch (IOException e) {
            TextToSpeech.log.error("Text To Speech synthesis failed");
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

