/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.audio;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.api.audio.AudioPacketClientHandler;
import pl.asie.lib.audio.StreamingAudioPlayer;
import pl.asie.lib.network.Packet;

@SideOnly(value=Side.CLIENT)
public class AudioPacketClientHandlerDFPWM
extends AudioPacketClientHandler {
    @Override
    protected void readData(Packet packet, int packetId, int codecId) throws IOException {
        int sampleRate = packet.readInt();
        short packetSize = packet.readShort();
        byte[] data = packet.readByteArrayData((int)packetSize);
        byte[] audio = new byte[packetSize * 8];
        StreamingAudioPlayer codec = Computronics.instance.audio.getPlayer(codecId);
        codec.decompress(audio, data, 0, 0, (int)packetSize);
        for (int i = 0; i < packetSize * 8; ++i) {
            audio[i] = (byte)(audio[i] & 0xFF ^ 0x80);
        }
        codec.setSampleRate(sampleRate);
        codec.push(audio);
    }

    @Override
    protected void playData(int packetId, int codecId, int x, int y, int z, int distance, byte volume, boolean canMove) {
        StreamingAudioPlayer codec = Computronics.instance.audio.getPlayer(codecId);
        codec.setHearing((float)distance, (float)volume / 127.0f);
        codec.play(canMove ? "computronics:dfpwm-" + codecId : null, x, y, z);
    }
}

