/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.tile;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.tile.TileEntityPeripheralBase;
import pl.asie.computronics.util.OCUtils;
import pl.asie.lib.api.tile.IBundledRedstoneProvider;
import pl.asie.lib.util.Base64;

public class TileCipherBlock
extends TileEntityPeripheralBase
implements IBundledRedstoneProvider,
ISidedInventory {
    private byte[] key = new byte[32];
    private byte[] iv = new byte[16];
    private SecretKeySpec skey;
    private Cipher cipher;
    private boolean isLocked = false;
    private int bundledXORData;
    public int redNetSingleOutput = 0;
    public int[] redNetMultiOutput = new int[16];

    public TileCipherBlock() {
        super("cipher");
        this.createInventory(6);
        this.registerBundledRedstone(this);
        try {
            this.cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public boolean canUpdate() {
        return Config.MUST_UPDATE_TILE_ENTITIES;
    }

    public void updateKey() {
        int i;
        byte[] realKey = new byte[16];
        for (i = 0; i < 6; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null || stack.func_77973_b() == null) {
                this.key[i * 5] = 0;
                this.key[i * 5 + 1] = 0;
            } else {
                this.key[i * 5] = (byte)(Item.func_150891_b((Item)stack.func_77973_b()) & 0xFF);
                this.key[i * 5 + 1] = (byte)(Item.func_150891_b((Item)stack.func_77973_b()) >> 8);
            }
            if (stack == null) {
                this.key[i * 5 + 2] = 0;
                this.key[i * 5 + 3] = 0;
                this.iv[i * 2] = 0;
            } else {
                this.key[i * 5 + 2] = (byte)(stack.func_77960_j() & 3 | stack.field_77994_a << 2);
                this.key[i * 5 + 3] = (byte)(stack.func_77960_j() >> 2);
                this.iv[i * 2] = (byte)(stack.func_77960_j() ^ stack.func_77960_j() >> 8);
            }
            if (stack == null || stack.func_77978_p() == null) {
                this.key[i * 5 + 4] = 0;
                this.iv[i * 2 + 1] = 0;
                continue;
            }
            this.key[i * 5 + 4] = (byte)stack.func_77978_p().hashCode();
            this.iv[i * 2 + 1] = (byte)(stack.func_77978_p().hashCode() >> 8);
        }
        for (i = 0; i < 16; ++i) {
            realKey[i] = (byte)(this.key[i] ^ this.key[i + 16]);
        }
        this.skey = new SecretKeySpec(realKey, "AES");
    }

    public String encrypt(String data) throws Exception {
        return this.encrypt(data.getBytes("UTF8"));
    }

    public String encrypt(byte[] data) throws Exception {
        if (this.cipher == null) {
            return "";
        }
        if (this.skey == null) {
            this.updateKey();
        }
        this.cipher.init(1, (Key)this.skey, new IvParameterSpec(this.iv));
        return Base64.encodeBytes((byte[])this.cipher.doFinal(data));
    }

    public String decrypt(String data) throws Exception {
        if (this.cipher == null) {
            return "";
        }
        if (this.skey == null) {
            this.updateKey();
        }
        this.cipher.init(2, (Key)this.skey, new IvParameterSpec(this.iv));
        return new String(this.cipher.doFinal(Base64.decode((String)data)), "UTF8");
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    protected OCUtils.Device deviceInfo() {
        return new OCUtils.Device("processor", "Data encryption device", "Siekierka Innovations", "Cryptotron 5-X", new String[0]);
    }

    @Callback(doc="function(message:string):string; Encrypts the specified message", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] encrypt(Context context, Arguments args) throws Exception {
        if (args.count() >= 1) {
            if (args.isByteArray(0)) {
                return new Object[]{this.encrypt(args.checkByteArray(0))};
            }
            if (args.isString(0)) {
                return new Object[]{this.encrypt(args.checkString(0))};
            }
        }
        return null;
    }

    @Callback(doc="function(message:string):string; Decrypts the specified message", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] decrypt(Context context, Arguments args) throws Exception {
        if (args.count() >= 1 && args.isString(0)) {
            return new Object[]{this.decrypt(args.checkString(0))};
        }
        return null;
    }

    @Callback(doc="function():boolean; Returns whether the block is currently locked", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] isLocked(Context context, Arguments args) throws Exception {
        return new Object[]{this.isLocked};
    }

    @Callback(doc="function(locked:boolean); Sets whether the block is currently locked")
    @Optional.Method(modid="OpenComputers")
    public Object[] setLocked(Context context, Arguments args) throws Exception {
        if (args.count() == 1 && args.isBoolean(0)) {
            this.isLocked = args.checkBoolean(0);
        }
        return null;
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"encrypt", "decrypt", "isLocked", "setLocked"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        try {
            if (arguments.length == 1 && arguments[0] instanceof String) {
                String message = (String)arguments[0];
                switch (method) {
                    case 0: {
                        return new Object[]{this.encrypt(message)};
                    }
                    case 1: {
                        return new Object[]{this.decrypt(message)};
                    }
                }
            } else {
                if (arguments.length == 1 && arguments[0] instanceof Boolean && method == 3) {
                    this.isLocked = (Boolean)arguments[0];
                    return null;
                }
                if (method == 2) {
                    return new Object[]{this.isLocked};
                }
            }
        }
        catch (Exception e) {
            throw new LuaException(e.getMessage());
        }
        return null;
    }

    private int getBundledXORKey() {
        int key = 0;
        for (int i = 0; i < 6; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null || stack.func_77973_b() == null) continue;
            int stackId = Item.func_150891_b((Item)stack.func_77973_b());
            if (stackId < 4096) {
                stackId <<= 4;
            }
            key ^= stackId;
            key ^= stack.func_77960_j();
            key ^= stack.field_77994_a * (193 * i);
        }
        return key;
    }

    @Optional.Method(modid="MineFactoryReloaded")
    private int getRedNetXORKey() {
        int key = 0;
        int amountOfItems = 0;
        for (int i = 0; i < 6; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null || stack.func_77973_b() == null) continue;
            ++amountOfItems;
            int keyPart = Item.func_150891_b((Item)stack.func_77973_b());
            if (keyPart < 4096) {
                keyPart <<= 4;
            }
            keyPart ^= stack.func_77960_j();
            key ^= (keyPart ^= stack.field_77994_a * (193 * i)) << 3;
        }
        return key ^= (amountOfItems & 1) << 31;
    }

    @Optional.Method(modid="MineFactoryReloaded")
    public void updateRedNet(int in) {
        this.redNetSingleOutput = in ^ this.getRedNetXORKey();
    }

    @Optional.Method(modid="MineFactoryReloaded")
    public void updateRedNet(int[] in) {
        this.redNetMultiOutput = in;
        int key = this.getRedNetXORKey();
        int i = 0;
        while (i < this.redNetMultiOutput.length) {
            int n = i++;
            this.redNetMultiOutput[n] = this.redNetMultiOutput[n] ^ key;
        }
    }

    private byte[] getBundledOutput() {
        int output = this.getBundledXORKey() ^ this.bundledXORData;
        byte[] out = new byte[16];
        for (int i = 0; i < 16; ++i) {
            out[i] = (output & 1) > 0 ? -1 : 0;
            output >>= 1;
        }
        return out;
    }

    public void updateOutputWires() {
        this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
    }

    public void onSlotUpdate(int slot) {
        this.updateKey();
        this.updateOutputWires();
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("cb_l") && Config.CIPHER_CAN_LOCK) {
            this.isLocked = tag.func_74767_n("cb_l");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.isLocked) {
            tag.func_74757_a("cb_l", true);
        }
    }

    @Override
    public void removeFromNBTForTransfer(NBTTagCompound data) {
        super.removeFromNBTForTransfer(data);
        data.func_82580_o("cb_l");
    }

    public boolean canBundledConnectTo(int arg0, int arg1) {
        int s = Computronics.cipher.relToAbs(5, this.field_145847_g);
        return arg0 == s || arg0 == (s ^ 1);
    }

    public byte[] getBundledOutput(int side, int arg1) {
        this.field_145847_g = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (side == Computronics.cipher.relToAbs(5, this.field_145847_g)) {
            return this.getBundledOutput();
        }
        return null;
    }

    public void onBundledInputChange(int arg0, int arg1, byte[] data) {
        if (data != null && arg0 == Computronics.cipher.relToAbs(4, this.field_145847_g)) {
            this.bundledXORData = 0;
            for (int i = 0; i < 16; ++i) {
                this.bundledXORData |= data[i] != 0 ? 1 << i : 0;
            }
            this.updateOutputWires();
        }
    }

    public ItemStack func_70301_a(int slot) {
        if (this.isLocked) {
            return null;
        }
        return super.func_70301_a(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (!this.isLocked) {
            super.func_70299_a(slot, stack);
        }
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return !this.isLocked && slot == side;
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return !this.isLocked && slot == side;
    }

    public int[] func_94128_d(int side) {
        if (this.isLocked) {
            return new int[0];
        }
        return new int[]{side};
    }
}

