/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.oc.manual.IItemWithDocumentation;
import pl.asie.computronics.tape.PortableDriveManager;
import pl.asie.computronics.tape.PortableTapeDrive;
import pl.asie.computronics.tile.TapeDriveState;
import pl.asie.computronics.util.StringUtil;

public class ItemPortableTapeDrive
extends Item
implements IItemWithDocumentation {
    private IIcon[] stateIcons = new IIcon[TapeDriveState.State.VALUES.length];

    public ItemPortableTapeDrive() {
        this.func_77637_a(Computronics.tab);
        this.func_77627_a(false);
        this.func_77655_b("computronics.portableTapeDrive");
        this.func_111206_d("computronics:portable_tape_drive_modern");
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister r) {
        super.func_94581_a(r);
        for (int i = 0; i < this.stateIcons.length; ++i) {
            this.stateIcons[i] = r.func_94245_a("computronics:portable_tape_drive_" + TapeDriveState.State.VALUES[i].name().toLowerCase(Locale.ENGLISH));
        }
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        byte state;
        NBTTagCompound tag;
        if (pass == 1 && stack.func_77942_o() && (tag = stack.func_77978_p()).func_74764_b("state") && tag.func_74764_b("inv") && tag.func_74764_b("tid") && ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("inv")) != null && PortableDriveManager.INSTANCE.exists(tag.func_74779_i("tid"), true) && (state = tag.func_74771_c("state")) >= 0 && state < this.stateIcons.length) {
            return this.stateIcons[state];
        }
        return super.getIcon(stack, pass);
    }

    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List info, boolean advanced) {
        NBTTagCompound tag;
        if (stack.func_77942_o() && (tag = stack.func_77978_p()).func_74764_b("state") && tag.func_74764_b("tid") && PortableDriveManager.INSTANCE.exists(tag.func_74779_i("tid"), true)) {
            ItemStack tape;
            ItemStack itemStack = tape = tag.func_74764_b("inv") ? ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("inv")) : null;
            if (tape != null) {
                String label = Computronics.itemTape.getLabel(tape);
                if (label.length() > 0) {
                    info.add(StringUtil.localizeAndFormat("tooltip.computronics.tape.labeltapeinserted", label + EnumChatFormatting.RESET + EnumChatFormatting.GRAY));
                } else {
                    info.add(StringUtil.localize("tooltip.computronics.tape.tapeinserted"));
                }
                byte state = tag.func_74771_c("state");
                if (state >= 0 && state < TapeDriveState.State.VALUES.length) {
                    info.add(StringUtil.localizeAndFormat("tooltip.computronics.tape.state", StringUtil.localize("tooltip.computronics.tape.state." + TapeDriveState.State.VALUES[state].name().toLowerCase(Locale.ENGLISH))));
                }
            } else {
                info.add(StringUtil.localize("tooltip.computronics.tape.notapeinserted"));
            }
        }
        super.func_77624_a(stack, player, info, advanced);
    }

    public boolean onEntityItemUpdate(EntityItem entity) {
        PortableTapeDrive drive = PortableDriveManager.INSTANCE.getOrCreate(entity.func_92059_d(), entity.field_70170_p.field_72995_K);
        drive.resetTime();
        drive.updateCarrier((Entity)entity, entity.func_92059_d());
        drive.update();
        return super.onEntityItemUpdate(entity);
    }

    public void func_77663_a(ItemStack stack, World world, Entity carrier, int slot, boolean isSelected) {
        super.func_77663_a(stack, world, carrier, slot, isSelected);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        PortableTapeDrive drive = PortableDriveManager.INSTANCE.getOrCreate(stack, world.field_72995_K);
        drive.updateCarrier((Entity)player, stack);
        if (world.field_72995_K) {
            return super.func_77659_a(stack, world, player);
        }
        if (player.func_70093_af()) {
            player.openGui((Object)Computronics.instance, Computronics.guiPortableTapeDrive.getGuiID(), world, 0, 0, 0);
        } else {
            drive.switchState(drive.getEnumState() != TapeDriveState.State.STOPPED ? TapeDriveState.State.STOPPED : TapeDriveState.State.PLAYING);
        }
        return super.func_77659_a(stack, world, player);
    }

    @Override
    public String getDocumentationName(ItemStack stack) {
        return "portable_tape_drive";
    }
}

