/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.railcraft.block;

import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import li.cil.oc.api.network.Environment;
import mods.railcraft.client.util.textures.TextureAtlasSheet;
import mods.railcraft.common.blocks.signals.BlockSignalBase;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.integration.railcraft.tile.TileDigitalReceiverBox;
import pl.asie.computronics.oc.block.IComputronicsEnvironmentBlock;
import pl.asie.computronics.oc.manual.IBlockWithPrefix;
import pl.asie.computronics.reference.Mods;

@Optional.InterfaceList(value={@Optional.Interface(iface="pl.asie.computronics.oc.block.IComputronicsEnvironmentBlock", modid="OpenComputers")})
public abstract class BlockDigitalBoxBase
extends BlockSignalBase
implements IComputronicsEnvironmentBlock,
IBlockWithPrefix {
    public IIcon[] texturesBox;
    public IIcon texturesBoxTop;
    private String documentationName;
    private final String prefix = "railcraft/";

    public BlockDigitalBoxBase(String documentationName) {
        super(RenderingRegistry.getNextAvailableRenderId());
        this.documentationName = documentationName;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        switch (side) {
            case 0: {
                return this.texturesBox[2];
            }
            case 1: {
                return this.texturesBoxTop;
            }
        }
        return this.texturesBox[0];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.texturesBox = TextureAtlasSheet.unstitchIcons((IIconRegister)iconRegister, (String)"railcraft:signal.box", (int)6);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        try {
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile instanceof TileDigitalReceiverBox) {
                TileDigitalReceiverBox structure = (TileDigitalReceiverBox)tile;
                if (!(!structure.getSignalType().needsSupport() || world.isSideSolid(x, y - 1, z, ForgeDirection.UP) || Mods.isLoaded("OpenComputers") && world.func_147438_o(x, y - 1, z) instanceof Environment)) {
                    world.func_147480_a(x, y, z, true);
                } else {
                    structure.onNeighborBlockChange(block);
                }
            }
        }
        catch (StackOverflowError error) {
            Computronics.log.error("Error in BlockDigitalReceiverBox.onNeighborBlockChange()");
            throw error;
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return this.createTileEntity(world, meta);
    }

    public boolean func_149744_f() {
        return false;
    }

    public boolean canConnectRedstone(IBlockAccess world, int i, int j, int k, int dir) {
        return false;
    }

    public int func_149709_b(IBlockAccess world, int i, int j, int k, int side) {
        return 0;
    }

    @Override
    public String getDocumentationName(World world, int x, int y, int z) {
        return this.documentationName;
    }

    @Override
    public String getDocumentationName(ItemStack stack) {
        return this.documentationName;
    }

    @Override
    public String getPrefix(World world, int x, int y, int z) {
        return this.prefix;
    }

    @Override
    public String getPrefix(ItemStack stack) {
        return this.prefix;
    }
}

