/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.railcraft.driver;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import li.cil.oc.api.prefab.ManagedEnvironment;
import mods.railcraft.common.blocks.detector.EnumDetector;
import mods.railcraft.common.blocks.detector.TileDetector;
import mods.railcraft.common.blocks.detector.types.DetectorRouting;
import mods.railcraft.common.items.ItemRoutingTable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pl.asie.computronics.api.multiperipheral.IMultiPeripheral;
import pl.asie.computronics.integration.CCMultiPeripheral;
import pl.asie.computronics.integration.ManagedEnvironmentOCTile;
import pl.asie.computronics.integration.util.RoutingTableUtil;

public class DriverRoutingDetector {
    private static Object[] getRoutingTable(TileDetector tile) {
        if (((DetectorRouting)tile.getDetector()).getInventory().func_70301_a(0) != null && ((DetectorRouting)tile.getDetector()).getInventory().func_70301_a(0).func_77973_b() instanceof ItemRoutingTable) {
            if (!((DetectorRouting)tile.getDetector()).isSecure()) {
                LinkedList pages = ItemRoutingTable.getPages((ItemStack)((DetectorRouting)tile.getDetector()).getInventory().func_70301_a(0));
                if (pages == null) {
                    return new Object[]{false, "no valid routing table found"};
                }
                LinkedHashMap<Integer, String> pageMap = new LinkedHashMap<Integer, String>();
                int i = 1;
                for (LinkedList currentPage : pages) {
                    for (String currentLine : currentPage) {
                        pageMap.put(i++, currentLine);
                    }
                    pageMap.put(i++, "{newpage}");
                }
                if (((String)pageMap.get(i - 1)).equals("{newpage}")) {
                    pageMap.remove(i - 1);
                }
                return new Object[]{pageMap};
            }
            return new Object[]{false, "routing detector is locked"};
        }
        return new Object[]{false, "no routing table found"};
    }

    private static Object[] setRoutingTable(TileDetector tile, Object[] arguments) {
        Map pageMap = (Map)arguments[0];
        if (((DetectorRouting)tile.getDetector()).getInventory().func_70301_a(0) != null && ((DetectorRouting)tile.getDetector()).getInventory().func_70301_a(0).func_77973_b() instanceof ItemRoutingTable) {
            if (!((DetectorRouting)tile.getDetector()).isSecure()) {
                LinkedList pages = new LinkedList();
                pages.add(new LinkedList());
                int pageIndex = 0;
                for (Object line : pageMap.values()) {
                    if (!(line instanceof String)) continue;
                    if (((String)line).toLowerCase().equals("{newline}")) {
                        pages.add(new LinkedList());
                        ++pageIndex;
                        continue;
                    }
                    ((LinkedList)pages.get(pageIndex)).add((String)line);
                }
                ItemRoutingTable.setPages((ItemStack)((DetectorRouting)tile.getDetector()).getInventory().func_70301_a(0), pages);
                return new Object[]{true};
            }
            return new Object[]{false, "routing detector is locked"};
        }
        return new Object[]{false, "no routing table found"};
    }

    public static Object[] getRoutingTableTitle(TileDetector tile) {
        if (((DetectorRouting)tile.getDetector()).getInventory().func_70301_a(0) != null && ((DetectorRouting)tile.getDetector()).getInventory().func_70301_a(0).func_77973_b() instanceof ItemRoutingTable) {
            if (!((DetectorRouting)tile.getDetector()).isSecure()) {
                return new Object[]{RoutingTableUtil.getRoutingTableTitle(((DetectorRouting)tile.getDetector()).getInventory().func_70301_a(0))};
            }
            return new Object[]{false, "routing detector is locked"};
        }
        return new Object[]{false, "no routing table found"};
    }

    public static Object[] setRoutingTableTitle(TileDetector tile, Object[] arguments) {
        if (((DetectorRouting)tile.getDetector()).getInventory().func_70301_a(0) != null && ((DetectorRouting)tile.getDetector()).getInventory().func_70301_a(0).func_77973_b() instanceof ItemRoutingTable) {
            if (!((DetectorRouting)tile.getDetector()).isSecure()) {
                return new Object[]{RoutingTableUtil.setRoutingTableTitle(((DetectorRouting)tile.getDetector()).getInventory().func_70301_a(0), (String)arguments[0])};
            }
            return new Object[]{false, "routing detector is locked"};
        }
        return new Object[]{false, "no routing table found"};
    }

    public static class CCDriver
    extends CCMultiPeripheral<TileDetector> {
        public CCDriver() {
        }

        public CCDriver(TileDetector detector, World world, int x, int y, int z) {
            super(detector, "routing_detector", world, x, y, z);
        }

        @Override
        public IMultiPeripheral getPeripheral(World world, int x, int y, int z, int side) {
            TileEntity te = world.func_147438_o(x, y, z);
            if (te != null && te instanceof TileDetector && ((TileDetector)te).getDetector().getType() == EnumDetector.ROUTING) {
                return new CCDriver((TileDetector)te, world, x, y, z);
            }
            return null;
        }

        public String[] getMethodNames() {
            return new String[]{"getRoutingTable", "setRoutingTable", "getRoutingTableTitle", "setRoutingTableTitle"};
        }

        public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
            switch (method) {
                case 0: {
                    return DriverRoutingDetector.getRoutingTable((TileDetector)this.tile);
                }
                case 1: {
                    if (arguments.length < 1 || !(arguments[0] instanceof Map)) {
                        throw new LuaException("first argument needs to be a table");
                    }
                    return DriverRoutingDetector.setRoutingTable((TileDetector)this.tile, arguments);
                }
                case 2: {
                    return DriverRoutingDetector.getRoutingTableTitle((TileDetector)this.tile);
                }
                case 3: {
                    if (arguments.length < 1 || !(arguments[0] instanceof String)) {
                        throw new LuaException("first argument needs to be a string");
                    }
                    return DriverRoutingDetector.setRoutingTableTitle((TileDetector)this.tile, arguments);
                }
            }
            return null;
        }
    }

    public static class OCDriver
    extends DriverSidedTileEntity {
        public Class<?> getTileEntityClass() {
            return TileDetector.class;
        }

        public boolean worksWith(World world, int x, int y, int z, ForgeDirection side) {
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            return tileEntity != null && tileEntity instanceof TileDetector && ((TileDetector)tileEntity).getDetector().getType() == EnumDetector.ROUTING;
        }

        public ManagedEnvironment createEnvironment(World world, int x, int y, int z, ForgeDirection side) {
            return new InternalManagedEnvironment((TileDetector)world.func_147438_o(x, y, z));
        }

        public static class InternalManagedEnvironment
        extends ManagedEnvironmentOCTile<TileDetector> {
            public InternalManagedEnvironment(TileDetector detector) {
                super(detector, "routing_detector");
            }

            @Callback(doc="function():table; Returns the full routing table inside the detector, or false and an error message if there is no table or it cannot be accessed")
            public Object[] getRoutingTable(Context c, Arguments a) {
                return DriverRoutingDetector.getRoutingTable((TileDetector)this.tile);
            }

            @Callback(doc="function(routingTable:table):boolean; Sets the routing table inside the detector; argument needs to be a table with number indices and string values; returns 'true' on success, 'false' and an error message otherwise.")
            public Object[] setRoutingTable(Context c, Arguments a) {
                a.checkTable(0);
                return DriverRoutingDetector.setRoutingTable((TileDetector)this.tile, a.toArray());
            }

            @Callback(doc="function():string; Returns the name of the routing table inside the detector")
            public Object[] getRoutingTableTitle(Context c, Arguments a) {
                return DriverRoutingDetector.getRoutingTableTitle((TileDetector)this.tile);
            }

            @Callback(doc="function(name:string):boolean; Sets the name of the routing table inside the detector; returns true on success")
            public Object[] setRoutingTableTitle(Context c, Arguments a) {
                a.checkString(0);
                return DriverRoutingDetector.setRoutingTableTitle((TileDetector)this.tile, a.toArray());
            }
        }
    }
}

