/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.tile;

import com.google.common.base.Throwables;
import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.api.audio.AudioPacket;
import pl.asie.computronics.api.audio.AudioPacketDFPWM;
import pl.asie.computronics.api.audio.IAudioReceiver;
import pl.asie.computronics.api.audio.IAudioSource;
import pl.asie.computronics.audio.AudioUtils;
import pl.asie.computronics.audio.tts.TextToSpeech;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.tile.TileEntityPeripheralBase;
import pl.asie.computronics.util.OCUtils;
import pl.asie.lib.util.ColorUtils;
import pl.asie.lib.util.internal.IColorable;

public class TileSpeechBox
extends TileEntityPeripheralBase
implements IAudioSource,
TextToSpeech.ICanSpeak {
    private final IAudioReceiver internalSpeaker = new IAudioReceiver(){

        @Override
        public boolean connectsAudio(ForgeDirection side) {
            return true;
        }

        @Override
        public World getSoundWorld() {
            return TileSpeechBox.this.field_145850_b;
        }

        @Override
        public Vec3 getSoundPos() {
            return Vec3.func_72443_a((double)((double)TileSpeechBox.this.field_145851_c + 0.5), (double)((double)TileSpeechBox.this.field_145848_d + 0.5), (double)((double)TileSpeechBox.this.field_145849_e + 0.5));
        }

        @Override
        public int getSoundDistance() {
            return Config.TAPEDRIVE_DISTANCE;
        }

        @Override
        public void receivePacket(AudioPacket packet, ForgeDirection direction) {
            packet.addReceiver(this);
        }

        @Override
        public String getID() {
            return AudioUtils.positionId(TileSpeechBox.this.field_145851_c, TileSpeechBox.this.field_145848_d, TileSpeechBox.this.field_145849_e);
        }
    };
    private long lastCodecTime;
    private int codecId = -1;
    protected int packetSize = 1024;
    protected int soundVolume = 127;
    private boolean locked = false;
    private ByteArrayInputStream storage;

    public TileSpeechBox() {
        super("speech_box");
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        AudioPacket pkt = null;
        long time = System.nanoTime();
        if (time - 250000000L > this.lastCodecTime) {
            this.lastCodecTime += 250000000L;
            pkt = this.createMusicPacket(this, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (pkt != null) {
            int receivers = 0;
            for (int i = 0; i < 6; ++i) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)i);
                TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
                if (!(tile instanceof IAudioReceiver) || tile instanceof IColorable && ((IColorable)tile).canBeColored() && !ColorUtils.isSameOrDefault((IColorable)this, (IColorable)((IColorable)tile))) continue;
                ((IAudioReceiver)tile).receivePacket(pkt, dir.getOpposite());
                ++receivers;
            }
            if (receivers == 0) {
                this.internalSpeaker.receivePacket(pkt, ForgeDirection.UNKNOWN);
            }
            pkt.sendPacket();
        }
    }

    @Override
    public void startTalking(byte[] data) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.storage = new ByteArrayInputStream(data);
        this.codecId = Computronics.instance.audio.newPlayer();
        Computronics.instance.audio.getPlayer(this.codecId);
        this.lastCodecTime = System.nanoTime();
    }

    private void stopTalking() {
        if (this.func_145830_o() && this.field_145850_b.field_72995_K) {
            return;
        }
        AudioUtils.removePlayer(Computronics.instance.managerId, this.codecId);
        this.locked = false;
        this.storage = null;
    }

    private Object[] sendNewText(String text) throws IOException {
        if (Computronics.tts == null) {
            return new Object[]{false, "text-to-speech system not available"};
        }
        this.locked = true;
        Computronics.tts.say(this, text);
        return new Object[]{true};
    }

    private AudioPacket createMusicPacket(IAudioSource source, World worldObj, int x, int y, int z) {
        if (this.storage == null) {
            return null;
        }
        byte[] pktData = new byte[this.packetSize];
        int amount = this.storage.read(pktData, 0, pktData.length);
        if (amount > 0) {
            return new AudioPacketDFPWM(source, (byte)this.soundVolume, this.packetSize * 8 * 4, amount == this.packetSize ? pktData : Arrays.copyOf(pktData, amount));
        }
        this.stopTalking();
        return null;
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.soundVolume = tag.func_74764_b("vo") ? (int)tag.func_74771_c("vo") : 127;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (this.soundVolume != 127) {
            tag.func_74774_a("vo", (byte)this.soundVolume);
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.stopTalking();
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.stopTalking();
    }

    public void setVolume(float volume) {
        if (volume < 0.0f) {
            volume = 0.0f;
        }
        if (volume > 1.0f) {
            volume = 1.0f;
        }
        this.soundVolume = (int)Math.floor(volume * 127.0f);
    }

    @Callback(doc="function(text:string):boolean; Say the specified message. Returns true on success, false and an error message otherwise.")
    @Optional.Method(modid="OpenComputers")
    public Object[] say(Context context, Arguments args) {
        if (this.locked || this.storage != null) {
            return new Object[]{false, "already processing"};
        }
        String text = args.checkString(0);
        if (text.length() > Config.TTS_MAX_LENGTH) {
            return new Object[]{false, "text too long"};
        }
        try {
            return this.sendNewText(text);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("could not send string");
        }
        catch (Exception e) {
            e.printStackTrace();
            Throwables.propagate((Throwable)e);
            return new Object[]{false};
        }
    }

    @Callback(doc="function():boolean; Stops the currently spoken phrase. Returns true on success, false and an error message otherwise.")
    @Optional.Method(modid="OpenComputers")
    public Object[] stop(Context context, Arguments args) {
        if (this.locked || this.storage != null) {
            this.stopTalking();
            return new Object[]{true};
        }
        return new Object[]{false, "not talking"};
    }

    @Callback(doc="function():boolean; Returns true if the device is currently processing text.", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] isProcessing(Context context, Arguments args) {
        return new Object[]{this.locked || this.storage != null};
    }

    @Callback(doc="function(speed:number); Sets the volume of the speech box. Needs to be beween 0 and 1")
    @Optional.Method(modid="OpenComputers")
    public Object[] setVolume(Context context, Arguments args) {
        this.setVolume((float)args.checkDouble(0));
        return null;
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"say", "stop", "isProcessing", "setVolume"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                if (arguments.length < 1 || !(arguments[0] instanceof String)) {
                    throw new LuaException("first argument needs to be a string");
                }
                if (this.locked || this.storage != null) {
                    return new Object[]{false, "already processing"};
                }
                String text = (String)arguments[0];
                if (text.length() > Config.TTS_MAX_LENGTH) {
                    return new Object[]{false, "text too long"};
                }
                try {
                    return this.sendNewText(text);
                }
                catch (IOException e) {
                    throw new LuaException("could not send string");
                }
            }
            case 1: {
                if (this.locked || this.storage != null) {
                    this.stopTalking();
                    return new Object[]{true};
                }
                return new Object[]{false, "not talking"};
            }
            case 2: {
                return new Object[]{this.locked || this.storage != null};
            }
            case 3: {
                if (arguments.length < 1 || !(arguments[0] instanceof Number)) {
                    throw new LuaException("first argument needs to be a number");
                }
                this.setVolume(((Number)arguments[0]).floatValue());
                return null;
            }
        }
        return null;
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    protected OCUtils.Device deviceInfo() {
        return new OCUtils.Device("multimedia", "Text-To-Speech Interface", "DFKI GmbH", "Mary", new String[0]);
    }

    @Override
    public int getSourceId() {
        return this.codecId;
    }

    @Override
    public boolean connectsAudio(ForgeDirection side) {
        return Computronics.speechBox.getFrontSide(this.func_145832_p()) != side.ordinal();
    }
}

