/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.waila;

import java.util.ArrayList;
import pl.asie.computronics.block.BlockColorfulLamp;
import pl.asie.computronics.block.BlockPeripheral;
import pl.asie.computronics.block.BlockTapeReader;
import pl.asie.computronics.integration.railcraft.block.BlockDigitalControllerBox;
import pl.asie.computronics.integration.railcraft.block.BlockDigitalReceiverBox;
import pl.asie.computronics.integration.railcraft.block.BlockLocomotiveRelay;
import pl.asie.computronics.integration.waila.providers.IComputronicsWailaProvider;
import pl.asie.computronics.integration.waila.providers.WailaColorfulLamp;
import pl.asie.computronics.integration.waila.providers.WailaLocomotiveRelay;
import pl.asie.computronics.integration.waila.providers.WailaPeripheral;
import pl.asie.computronics.integration.waila.providers.WailaTapeDrive;
import pl.asie.computronics.reference.Mods;

public class WailaProviders {
    public static final ArrayList<WailaProviders> VALUES = new ArrayList();
    private IComputronicsWailaProvider provider;
    private Class<?> block;

    static void initialize() {
        WailaProviders.newProvider(new WailaPeripheral(), BlockPeripheral.class);
        if (Mods.isLoaded("Railcraft")) {
            WailaProviders.newProvider(new WailaPeripheral(), BlockDigitalReceiverBox.class);
            WailaProviders.newProvider(new WailaPeripheral(), BlockDigitalControllerBox.class);
            WailaProviders.newProvider(new WailaLocomotiveRelay(), BlockLocomotiveRelay.class);
        }
        WailaProviders.newProvider(new WailaTapeDrive(), BlockTapeReader.class);
        WailaProviders.newProvider(new WailaColorfulLamp(), BlockColorfulLamp.class);
    }

    private static void newProvider(IComputronicsWailaProvider provider, Class<?> block) {
        new WailaProviders(provider, block);
    }

    private WailaProviders(IComputronicsWailaProvider provider, Class<?> block) {
        this.provider = provider;
        this.block = block;
        VALUES.add(this);
    }

    public IComputronicsWailaProvider getProvider() {
        return this.provider;
    }

    public boolean isInstance(Object obj) {
        return obj != null && this.block.isInstance(obj);
    }
}

