/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.asm;

import codechicken.core.CCUpdateChecker;
import codechicken.core.ClientUtils;
import codechicken.core.featurehack.LiquidTextures;
import codechicken.core.internal.CCCEventHandler;
import codechicken.core.launch.CodeChickenCorePlugin;
import codechicken.lib.config.ConfigFile;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.common.versioning.VersionRange;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;

public class CodeChickenCoreModContainer
extends DummyModContainer {
    public static ConfigFile config;

    public static void loadConfig() {
        if (config == null) {
            config = new ConfigFile(new File(CodeChickenCorePlugin.minecraftDir, "config/CodeChickenCore.cfg")).setComment("CodeChickenCore configuration file.");
        }
    }

    public CodeChickenCoreModContainer() {
        super(CodeChickenCoreModContainer.getModMetadata());
    }

    private static ModMetadata getModMetadata() {
        ModMetadata modMetadata = new ModMetadata();
        modMetadata.name = "CodeChicken Core";
        modMetadata.modId = "CodeChickenCore";
        modMetadata.version = "1.1.0";
        return modMetadata;
    }

    public List<ArtifactVersion> getDependants() {
        LinkedList<ArtifactVersion> deps = new LinkedList<ArtifactVersion>();
        if (!this.getVersion().contains("$")) {
            deps.add(VersionParser.parseVersionReference((String)"Forge@[10.13.3,)"));
            deps.add(VersionParser.parseVersionReference((String)"NotEnoughItems@[1.0.5,)"));
            deps.add(VersionParser.parseVersionReference((String)"EnderStorage@[1.4.7,)"));
            deps.add(VersionParser.parseVersionReference((String)"ChickenChunks@[1.3.4,)"));
            deps.add(VersionParser.parseVersionReference((String)"Translocator@[1.1.2,)"));
            deps.add(VersionParser.parseVersionReference((String)"WR-CBE|Core@[1.4.1,)"));
        }
        return deps;
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        if (event.getSide().isClient()) {
            LiquidTextures.init();
        }
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        if (event.getSide().isClient()) {
            if (config.getTag("checkUpdates").getBooleanValue(true)) {
                CCUpdateChecker.updateCheck(this.getModId());
            }
            ClientUtils.enhanceSupportersList("CodeChickenCore");
            FMLCommonHandler.instance().bus().register((Object)new CCCEventHandler());
            MinecraftForge.EVENT_BUS.register((Object)new CCCEventHandler());
        }
    }

    public VersionRange acceptableMinecraftVersionRange() {
        return VersionParser.parseRange((String)"[1.7.10]");
    }
}

