/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.launch;

import codechicken.core.asm.CodeChickenCoreModContainer;
import codechicken.core.asm.DelegatedTransformer;
import codechicken.core.asm.MCPDeobfuscationTransformer;
import codechicken.core.asm.TweakTransformer;
import codechicken.core.launch.DepLoader;
import codechicken.lib.config.ConfigTag;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.relauncher.CoreModManager;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.IFMLCallHook;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.awt.Desktop;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.text.StringCharacterIterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@IFMLLoadingPlugin.TransformerExclusions(value={"codechicken.core.asm", "codechicken.obfuscator"})
@IFMLLoadingPlugin.MCVersion(value="1.7.10")
public class CodeChickenCorePlugin
implements IFMLLoadingPlugin,
IFMLCallHook {
    public static final String mcVersion = "[1.7.10]";
    @Deprecated
    public static final String version = "1.2.1";
    public static File minecraftDir;
    public static String currentMcVersion;
    public static Logger logger;

    public CodeChickenCorePlugin() {
        if (minecraftDir != null) {
            return;
        }
        minecraftDir = (File)FMLInjectionData.data()[6];
        currentMcVersion = (String)FMLInjectionData.data()[4];
        DepLoader.load();
        this.injectDeobfPlugin();
    }

    private void injectDeobfPlugin() {
        try {
            Class<?> wrapperClass = Class.forName("cpw.mods.fml.relauncher.CoreModManager$FMLPluginWrapper");
            Constructor<?> wrapperConstructor = wrapperClass.getConstructor(String.class, IFMLLoadingPlugin.class, File.class, Integer.TYPE, String[].class);
            Field f_loadPlugins = CoreModManager.class.getDeclaredField("loadPlugins");
            wrapperConstructor.setAccessible(true);
            f_loadPlugins.setAccessible(true);
            ((List)f_loadPlugins.get(null)).add(2, wrapperConstructor.newInstance("CCCDeobfPlugin", new MCPDeobfuscationTransformer.LoadPlugin(), null, 0, new String[0]));
        }
        catch (Exception e) {
            logger.error("Failed to inject MCPDeobfuscation Transformer", (Throwable)e);
        }
    }

    public static void versionCheck(String reqVersion, String mod) {
        String mcVersion = (String)FMLInjectionData.data()[4];
        if (!VersionParser.parseRange((String)reqVersion).containsVersion((ArtifactVersion)new DefaultArtifactVersion(mcVersion))) {
            String err = "This version of " + mod + " does not support minecraft version " + mcVersion;
            logger.error(err);
            JEditorPane ep = new JEditorPane("text/html", "<html>" + err + "<br>Remove it from your coremods folder and check <a href=\"http://www.minecraftforum.net/topic/909223-\">here</a> for updates</html>");
            ep.setEditable(false);
            ep.setOpaque(false);
            ep.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent event) {
                    try {
                        if (event.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                            Desktop.getDesktop().browse(event.getURL().toURI());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            JOptionPane.showMessageDialog(null, ep, "Fatal error", 0);
            System.exit(1);
        }
    }

    public static long parseSize(String text) {
        double d = Double.parseDouble(text.replaceAll("[GMK]B?$", ""));
        long l = Math.round(d * 1024.0 * 1024.0 * 1024.0);
        switch (text.replaceAll("\\d?", "").toUpperCase().charAt(0)) {
            default: {
                l /= 1024L;
            }
            case 'K': {
                l /= 1024L;
            }
            case 'M': {
                l /= 1024L;
            }
            case 'G': 
        }
        return l;
    }

    public static String humanReadableByteCountBin(long bytes) {
        long absB;
        long l = absB = bytes == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(bytes);
        if (absB < 1024L) {
            return bytes + " B";
        }
        long value = absB;
        StringCharacterIterator ci = new StringCharacterIterator("KMGTPE");
        for (int i = 40; i >= 0 && absB > 0xFFFCCCCCCCCCCCCL >> i; i -= 10) {
            value >>= 10;
            ci.next();
        }
        return String.format("%.1f %cB", (double)(value *= (long)Long.signum(bytes)) / 1024.0, Character.valueOf(ci.current()));
    }

    public static void systemCheck(ConfigTag checkRAM) {
        long minBytes = CodeChickenCorePlugin.parseSize(checkRAM.getTag("minRAM").setComment("Amount of RAM minimum this modpack needs to load").getValue("3GB"));
        if (Runtime.getRuntime().maxMemory() < minBytes) {
            String err = "You should have at least " + CodeChickenCorePlugin.humanReadableByteCountBin(minBytes) + " of RAM but you have only allocated " + CodeChickenCorePlugin.humanReadableByteCountBin(Runtime.getRuntime().maxMemory()) + ".";
            logger.error(err);
            JEditorPane ep = new JEditorPane("text/html", "<html>" + err + "<br>" + checkRAM.getTag("modPack").setComment("Name of the modpack").getValue("Unidentified ModPack") + " seriously won't run without enough RAM. " + checkRAM.getTag("wiki").setComment("Webpage describing RAM settings").getValue("See <a href=\"https://downloadmoreram.com\">DownloadMoreRam.com</a> for details.") + "<br>Recommended values are between " + checkRAM.getTag("recRAM").setComment("Lower bound of recommended RAM").getValue("4GB") + " and " + checkRAM.getTag("recRAMUpper").setComment("Upper bound of recommended RAM").getValue("6GB") + ". Check your launcher's JVM arguments.</html>");
            ep.setEditable(false);
            ep.setOpaque(false);
            ep.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent event) {
                    try {
                        if (event.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                            Desktop.getDesktop().browse(event.getURL().toURI());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            if (!GraphicsEnvironment.isHeadless()) {
                JOptionPane.showMessageDialog(null, ep, "lol nope", 0);
            }
            FMLCommonHandler.instance().exitJava(-98, true);
        }
    }

    public String[] getASMTransformerClass() {
        CodeChickenCorePlugin.versionCheck(mcVersion, "CodeChickenCore");
        return new String[]{"codechicken.lib.asm.ClassHeirachyManager", "codechicken.core.asm.TweakTransformer", "codechicken.core.asm.DelegatedTransformer", "codechicken.core.asm.DefaultImplementationTransformer", "codechicken.lib.asm.RedirectorTransformer"};
    }

    public String getAccessTransformerClass() {
        return "codechicken.core.asm.CodeChickenAccessTransformer";
    }

    public String getModContainerClass() {
        return "codechicken.core.asm.CodeChickenCoreModContainer";
    }

    public String getSetupClass() {
        return this.getClass().getName();
    }

    public void injectData(Map<String, Object> data) {
    }

    public Void call() {
        CodeChickenCoreModContainer.loadConfig();
        ConfigTag checkRAM = CodeChickenCoreModContainer.config.getTag("checks").setComment("Configuration options for checking various requirements for a modpack.").useBraces();
        if (checkRAM.getTag("checkRAM").setComment("If set to true, check RAM available for Minecraft before continuing to load").getBooleanValue(false)) {
            CodeChickenCorePlugin.systemCheck(checkRAM);
        }
        TweakTransformer.load();
        this.scanCodeChickenMods();
        return null;
    }

    private void scanCodeChickenMods() {
        File modsDir = new File(minecraftDir, "mods");
        for (File file : modsDir.listFiles()) {
            this.scanMod(file);
        }
        File versionModsDir = new File(minecraftDir, "mods/" + currentMcVersion);
        if (versionModsDir.exists()) {
            for (File file : versionModsDir.listFiles()) {
                this.scanMod(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanMod(File file) {
        if (!file.getName().endsWith(".jar") && !file.getName().endsWith(".zip")) {
            return;
        }
        try (JarFile jar = new JarFile(file);){
            Manifest manifest = jar.getManifest();
            if (manifest == null) {
                return;
            }
            Attributes attr = manifest.getMainAttributes();
            if (attr == null) {
                return;
            }
            String transformer = attr.getValue("CCTransformer");
            if (transformer != null) {
                DelegatedTransformer.addTransformer(transformer, jar, file);
            }
        }
        catch (Exception e) {
            logger.error("CodeChickenCore: Failed to read jar file: " + file.getName(), (Throwable)e);
        }
    }

    static {
        logger = LogManager.getLogger((String)"CodeChickenCore");
    }
}

