/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.render;

import cofh.repack.codechicken.lib.render.CCRenderState;
import cofh.repack.codechicken.lib.render.TextureUtils;
import cofh.repack.codechicken.lib.vec.Cuboid6;
import cofh.repack.codechicken.lib.vec.Rectangle4i;
import cofh.repack.codechicken.lib.vec.Vector3;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    static Vector3[] vectors = new Vector3[8];
    static RenderItem uniformRenderItem = new RenderItem(){

        public boolean shouldBob() {
            return false;
        }
    };
    static EntityItem entityItem;

    public static void renderFluidQuad(Vector3 vector3, Vector3 vector32, Vector3 vector33, Vector3 vector34, IIcon iIcon, double d) {
        RenderUtils.renderFluidQuad(vector32, vectors[0].set(vector34).subtract(vector3), vectors[1].set(vector3).subtract(vector32), iIcon, d);
    }

    public static void renderFluidQuad(Vector3 vector3, Vector3 vector32, Vector3 vector33, IIcon iIcon, double d) {
        double d2;
        Tessellator tessellator = Tessellator.field_78398_a;
        double d3 = iIcon.func_94209_e();
        double d4 = iIcon.func_94212_f() - iIcon.func_94209_e();
        double d5 = iIcon.func_94210_h();
        double d6 = iIcon.func_94210_h() - iIcon.func_94206_g();
        double d7 = vector32.mag();
        double d8 = vector33.mag();
        for (double d9 = 0.0; d9 < d7; d9 += d2) {
            double d10;
            d2 = d7 - d9;
            if (d2 > d) {
                d2 = d;
            }
            for (double d11 = 0.0; d11 < d8; d11 += d10) {
                d10 = d8 - d11;
                if (d10 > d) {
                    d10 = d;
                }
                Vector3 vector34 = vectors[2].set(vector32).multiply(d9 / d7);
                Vector3 vector35 = vectors[3].set(vector32).multiply((d9 + d2) / d7);
                Vector3 vector36 = vectors[4].set(vector33).multiply(d11 / d8);
                Vector3 vector37 = vectors[5].set(vector33).multiply((d11 + d10) / d8);
                tessellator.func_78374_a(vector3.x + vector34.x + vector37.x, vector3.y + vector34.y + vector37.y, vector3.z + vector34.z + vector37.z, d3, d5 - d10 / d * d6);
                tessellator.func_78374_a(vector3.x + vector34.x + vector36.x, vector3.y + vector34.y + vector36.y, vector3.z + vector34.z + vector36.z, d3, d5);
                tessellator.func_78374_a(vector3.x + vector35.x + vector36.x, vector3.y + vector35.y + vector36.y, vector3.z + vector35.z + vector36.z, d3 + d2 / d * d4, d5);
                tessellator.func_78374_a(vector3.x + vector35.x + vector37.x, vector3.y + vector35.y + vector37.y, vector3.z + vector35.z + vector37.z, d3 + d2 / d * d4, d5 - d10 / d * d6);
            }
        }
    }

    public static void translateToWorldCoords(Entity entity, float f) {
        double d = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)f;
        double d2 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)f;
        double d3 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)f;
        GL11.glTranslated((double)(-d), (double)(-d2), (double)(-d3));
    }

    public static void drawCuboidOutline(Cuboid6 cuboid6) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78371_b(3);
        tessellator.func_78377_a(cuboid6.min.x, cuboid6.min.y, cuboid6.min.z);
        tessellator.func_78377_a(cuboid6.max.x, cuboid6.min.y, cuboid6.min.z);
        tessellator.func_78377_a(cuboid6.max.x, cuboid6.min.y, cuboid6.max.z);
        tessellator.func_78377_a(cuboid6.min.x, cuboid6.min.y, cuboid6.max.z);
        tessellator.func_78377_a(cuboid6.min.x, cuboid6.min.y, cuboid6.min.z);
        tessellator.func_78381_a();
        tessellator.func_78371_b(3);
        tessellator.func_78377_a(cuboid6.min.x, cuboid6.max.y, cuboid6.min.z);
        tessellator.func_78377_a(cuboid6.max.x, cuboid6.max.y, cuboid6.min.z);
        tessellator.func_78377_a(cuboid6.max.x, cuboid6.max.y, cuboid6.max.z);
        tessellator.func_78377_a(cuboid6.min.x, cuboid6.max.y, cuboid6.max.z);
        tessellator.func_78377_a(cuboid6.min.x, cuboid6.max.y, cuboid6.min.z);
        tessellator.func_78381_a();
        tessellator.func_78371_b(1);
        tessellator.func_78377_a(cuboid6.min.x, cuboid6.min.y, cuboid6.min.z);
        tessellator.func_78377_a(cuboid6.min.x, cuboid6.max.y, cuboid6.min.z);
        tessellator.func_78377_a(cuboid6.max.x, cuboid6.min.y, cuboid6.min.z);
        tessellator.func_78377_a(cuboid6.max.x, cuboid6.max.y, cuboid6.min.z);
        tessellator.func_78377_a(cuboid6.max.x, cuboid6.min.y, cuboid6.max.z);
        tessellator.func_78377_a(cuboid6.max.x, cuboid6.max.y, cuboid6.max.z);
        tessellator.func_78377_a(cuboid6.min.x, cuboid6.min.y, cuboid6.max.z);
        tessellator.func_78377_a(cuboid6.min.x, cuboid6.max.y, cuboid6.max.z);
        tessellator.func_78381_a();
    }

    public static void renderFluidCuboid(Cuboid6 cuboid6, IIcon iIcon, double d) {
        RenderUtils.renderFluidQuad(new Vector3(cuboid6.min.x, cuboid6.min.y, cuboid6.min.z), new Vector3(cuboid6.max.x, cuboid6.min.y, cuboid6.min.z), new Vector3(cuboid6.max.x, cuboid6.min.y, cuboid6.max.z), new Vector3(cuboid6.min.x, cuboid6.min.y, cuboid6.max.z), iIcon, d);
        RenderUtils.renderFluidQuad(new Vector3(cuboid6.min.x, cuboid6.max.y, cuboid6.min.z), new Vector3(cuboid6.min.x, cuboid6.max.y, cuboid6.max.z), new Vector3(cuboid6.max.x, cuboid6.max.y, cuboid6.max.z), new Vector3(cuboid6.max.x, cuboid6.max.y, cuboid6.min.z), iIcon, d);
        RenderUtils.renderFluidQuad(new Vector3(cuboid6.min.x, cuboid6.max.y, cuboid6.min.z), new Vector3(cuboid6.min.x, cuboid6.min.y, cuboid6.min.z), new Vector3(cuboid6.min.x, cuboid6.min.y, cuboid6.max.z), new Vector3(cuboid6.min.x, cuboid6.max.y, cuboid6.max.z), iIcon, d);
        RenderUtils.renderFluidQuad(new Vector3(cuboid6.max.x, cuboid6.max.y, cuboid6.max.z), new Vector3(cuboid6.max.x, cuboid6.min.y, cuboid6.max.z), new Vector3(cuboid6.max.x, cuboid6.min.y, cuboid6.min.z), new Vector3(cuboid6.max.x, cuboid6.max.y, cuboid6.min.z), iIcon, d);
        RenderUtils.renderFluidQuad(new Vector3(cuboid6.max.x, cuboid6.max.y, cuboid6.min.z), new Vector3(cuboid6.max.x, cuboid6.min.y, cuboid6.min.z), new Vector3(cuboid6.min.x, cuboid6.min.y, cuboid6.min.z), new Vector3(cuboid6.min.x, cuboid6.max.y, cuboid6.min.z), iIcon, d);
        RenderUtils.renderFluidQuad(new Vector3(cuboid6.min.x, cuboid6.max.y, cuboid6.max.z), new Vector3(cuboid6.min.x, cuboid6.min.y, cuboid6.max.z), new Vector3(cuboid6.max.x, cuboid6.min.y, cuboid6.max.z), new Vector3(cuboid6.max.x, cuboid6.max.y, cuboid6.max.z), iIcon, d);
    }

    public static void renderBlockOverlaySide(int n, int n2, int n3, int n4, double d, double d2, double d3, double d4) {
        double[] dArray = new double[]{(double)n - 0.009, (double)n + 1.009, (double)n2 - 0.009, (double)n2 + 1.009, (double)n3 - 0.009, (double)n3 + 1.009};
        Tessellator tessellator = Tessellator.field_78398_a;
        switch (n4) {
            case 0: {
                tessellator.func_78374_a(dArray[0], dArray[2], dArray[4], d, d3);
                tessellator.func_78374_a(dArray[1], dArray[2], dArray[4], d2, d3);
                tessellator.func_78374_a(dArray[1], dArray[2], dArray[5], d2, d4);
                tessellator.func_78374_a(dArray[0], dArray[2], dArray[5], d, d4);
                break;
            }
            case 1: {
                tessellator.func_78374_a(dArray[1], dArray[3], dArray[4], d2, d3);
                tessellator.func_78374_a(dArray[0], dArray[3], dArray[4], d, d3);
                tessellator.func_78374_a(dArray[0], dArray[3], dArray[5], d, d4);
                tessellator.func_78374_a(dArray[1], dArray[3], dArray[5], d2, d4);
                break;
            }
            case 2: {
                tessellator.func_78374_a(dArray[0], dArray[3], dArray[4], d2, d3);
                tessellator.func_78374_a(dArray[1], dArray[3], dArray[4], d, d3);
                tessellator.func_78374_a(dArray[1], dArray[2], dArray[4], d, d4);
                tessellator.func_78374_a(dArray[0], dArray[2], dArray[4], d2, d4);
                break;
            }
            case 3: {
                tessellator.func_78374_a(dArray[1], dArray[3], dArray[5], d2, d3);
                tessellator.func_78374_a(dArray[0], dArray[3], dArray[5], d, d3);
                tessellator.func_78374_a(dArray[0], dArray[2], dArray[5], d, d4);
                tessellator.func_78374_a(dArray[1], dArray[2], dArray[5], d2, d4);
                break;
            }
            case 4: {
                tessellator.func_78374_a(dArray[0], dArray[3], dArray[5], d2, d3);
                tessellator.func_78374_a(dArray[0], dArray[3], dArray[4], d, d3);
                tessellator.func_78374_a(dArray[0], dArray[2], dArray[4], d, d4);
                tessellator.func_78374_a(dArray[0], dArray[2], dArray[5], d2, d4);
                break;
            }
            case 5: {
                tessellator.func_78374_a(dArray[1], dArray[3], dArray[4], d2, d3);
                tessellator.func_78374_a(dArray[1], dArray[3], dArray[5], d, d3);
                tessellator.func_78374_a(dArray[1], dArray[2], dArray[5], d, d4);
                tessellator.func_78374_a(dArray[1], dArray[2], dArray[4], d2, d4);
            }
        }
    }

    public static boolean shouldRenderFluid(FluidStack fluidStack) {
        return fluidStack.amount > 0 && fluidStack.getFluid() != null;
    }

    public static IIcon prepareFluidRender(FluidStack fluidStack, int n) {
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Fluid fluid = fluidStack.getFluid();
        CCRenderState.setColour(fluid.getColor(fluidStack) << 8 | n);
        TextureUtils.bindAtlas(fluid.getSpriteNumber());
        return TextureUtils.safeIcon(fluid.getIcon(fluidStack));
    }

    public static void postFluidRender() {
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
    }

    public static double fluidDensityToAlpha(double d) {
        return Math.pow(d, 0.4);
    }

    public static void renderFluidCuboid(FluidStack fluidStack, Cuboid6 cuboid6, double d, double d2) {
        if (!RenderUtils.shouldRenderFluid(fluidStack)) {
            return;
        }
        int n = 255;
        if (fluidStack.getFluid().isGaseous()) {
            n = (int)(RenderUtils.fluidDensityToAlpha(d) * 255.0);
        } else {
            cuboid6.max.y = cuboid6.min.y + (cuboid6.max.y - cuboid6.min.y) * d;
        }
        IIcon iIcon = RenderUtils.prepareFluidRender(fluidStack, n);
        CCRenderState.startDrawing();
        RenderUtils.renderFluidCuboid(cuboid6, iIcon, d2);
        CCRenderState.draw();
        RenderUtils.postFluidRender();
    }

    public static void renderFluidGauge(FluidStack fluidStack, Rectangle4i rectangle4i, double d, double d2) {
        if (!RenderUtils.shouldRenderFluid(fluidStack)) {
            return;
        }
        int n = 255;
        if (fluidStack.getFluid().isGaseous()) {
            n = (int)(RenderUtils.fluidDensityToAlpha(d) * 255.0);
        } else {
            int n2 = (int)((double)rectangle4i.h * d);
            rectangle4i.y += rectangle4i.h - n2;
            rectangle4i.h = n2;
        }
        IIcon iIcon = RenderUtils.prepareFluidRender(fluidStack, n);
        CCRenderState.startDrawing();
        RenderUtils.renderFluidQuad(new Vector3(rectangle4i.x, rectangle4i.y + rectangle4i.h, 0.0), new Vector3(rectangle4i.w, 0.0, 0.0), new Vector3(0.0, -rectangle4i.h, 0.0), iIcon, d2);
        CCRenderState.draw();
        RenderUtils.postFluidRender();
    }

    public static void renderItemUniform(ItemStack itemStack) {
        RenderUtils.renderItemUniform(itemStack, 0.0);
    }

    public static void renderItemUniform(ItemStack itemStack, double d) {
        IItemRenderer iItemRenderer = MinecraftForgeClient.getItemRenderer((ItemStack)itemStack, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.ENTITY);
        boolean bl = iItemRenderer != null && iItemRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.ENTITY, itemStack, IItemRenderer.ItemRendererHelper.BLOCK_3D);
        boolean bl2 = false;
        if (itemStack.func_77973_b() instanceof ItemBlock && RenderBlocks.func_147739_a((int)Block.func_149634_a((Item)itemStack.func_77973_b()).func_149645_b())) {
            int n = Block.func_149634_a((Item)itemStack.func_77973_b()).func_149645_b();
            bl2 = n != 1 && n != 19 && n != 12 && n != 2;
        } else if (bl) {
            bl2 = true;
        }
        double d2 = 2.0;
        double d3 = 1.0 / d2;
        if (bl2) {
            GL11.glScaled((double)d2, (double)d2, (double)d2);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        entityItem.func_92058_a(itemStack);
        uniformRenderItem.func_76986_a(entityItem, 0.0, bl2 ? 0.09 : 0.06, 0.0, 0.0f, (float)(d * 9.0 / Math.PI));
        if (bl2) {
            GL11.glScaled((double)d3, (double)d3, (double)d3);
        }
    }

    static {
        for (int i = 0; i < vectors.length; ++i) {
            RenderUtils.vectors[i] = new Vector3();
        }
        uniformRenderItem.func_76976_a(RenderManager.field_78727_a);
        entityItem = new EntityItem(null);
        RenderUtils.entityItem.field_70290_d = 0.0f;
    }
}

