/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.compat.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.cricketcraft.chisel.api.carving.CarvingUtils;
import com.cricketcraft.chisel.api.carving.ICarvingGroup;
import com.cricketcraft.chisel.api.carving.ICarvingVariation;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;
import team.chisel.carving.Carving;
import team.chisel.client.gui.GuiChisel;

public class RecipeHandlerChisel
extends TemplateRecipeHandler {
    private static final int SLOTS_PER_PAGE = 45;

    public String getRecipeName() {
        return "Chisel";
    }

    public String getGuiTexture() {
        return "Chisel:textures/chiselNEI.png";
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiChisel.class;
    }

    public void drawBackground(int recipeIndex) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)166, (int)130);
        Point focus = ((CachedChiselRecipe)((Object)this.arecipes.get((int)recipeIndex))).focus;
        if (focus != null) {
            GuiDraw.drawTexturedModalRect((int)focus.x, (int)focus.y, (int)166, (int)0, (int)18, (int)18);
        }
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(75, 22, 15, 13), "chisel2.chisel", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("chisel2.chisel")) {
            for (String name : Carving.chisel.getSortedGroupNames()) {
                ICarvingGroup g = Carving.chisel.getGroup(name);
                if (g.getVariations().isEmpty()) continue;
                this.addCached(RecipeHandlerChisel.getVariationStacks(g));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (String name : Carving.chisel.getSortedGroupNames()) {
            ICarvingGroup g = Carving.chisel.getGroup(name);
            List<ItemStack> variations = RecipeHandlerChisel.getVariationStacks(g);
            for (ItemStack stack : variations) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)stack, (ItemStack)result)) continue;
                this.addCached(variations, null, result);
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (String name : Carving.chisel.getSortedGroupNames()) {
            ICarvingGroup g = Carving.chisel.getGroup(name);
            List<ItemStack> variations = RecipeHandlerChisel.getVariationStacks(g);
            for (ItemStack stack : variations) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)stack, (ItemStack)ingredient)) continue;
                this.addCached(variations, ingredient, null);
            }
        }
    }

    private void addCached(List<ItemStack> variations, ItemStack base, ItemStack focus) {
        if (variations.size() > 45) {
            ArrayList<ArrayList<ItemStack>> parts = new ArrayList<ArrayList<ItemStack>>();
            int size = variations.size();
            for (int i = 0; i < size; i += 45) {
                parts.add(new ArrayList<ItemStack>(variations.subList(i, Math.min(size, i + 45))));
            }
            for (List list : parts) {
                this.arecipes.add(new CachedChiselRecipe(list, base, focus));
            }
        } else {
            this.arecipes.add(new CachedChiselRecipe(variations, base, focus));
        }
    }

    private void addCached(List<ItemStack> variations) {
        this.addCached(variations, null, null);
    }

    private static List<ItemStack> getVariationStacks(ICarvingGroup g) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ICarvingVariation v : g.getVariations()) {
            stacks.add(CarvingUtils.getStack(v));
        }
        String oreName = g.getOreName();
        if (oreName != null) {
            block1: for (ItemStack ore : OreDictionary.getOres((String)oreName)) {
                for (ItemStack stack : stacks) {
                    if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)stack, (ItemStack)ore)) continue;
                    continue block1;
                }
                stacks.add(ore.func_77946_l());
            }
        }
        return stacks;
    }

    public class CachedChiselRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private List<PositionedStack> input;
        private List<PositionedStack> outputs;
        public Point focus;

        public CachedChiselRecipe(List<ItemStack> variations, ItemStack base, ItemStack focus) {
            super((TemplateRecipeHandler)RecipeHandlerChisel.this);
            this.input = new ArrayList<PositionedStack>();
            this.outputs = new ArrayList<PositionedStack>();
            PositionedStack pStack = new PositionedStack(base != null ? base : variations, 74, 4);
            pStack.setMaxSize(1);
            this.input.add(pStack);
            int row = 0;
            int col = 0;
            for (ItemStack v : variations) {
                this.outputs.add(new PositionedStack((Object)v, 3 + 18 * col, 37 + 18 * row));
                if (focus != null && NEIServerUtils.areStacksSameTypeCrafting((ItemStack)focus, (ItemStack)v)) {
                    this.focus = new Point(2 + 18 * col, 36 + 18 * row);
                }
                if (++col <= 8) continue;
                col = 0;
                ++row;
            }
        }

        public CachedChiselRecipe(List<ItemStack> variations) {
            this(variations, null, null);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(RecipeHandlerChisel.this.cycleticks / 20, this.input);
        }

        public List<PositionedStack> getOtherStacks() {
            return this.outputs;
        }

        public PositionedStack getResult() {
            return null;
        }
    }
}

