/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.renderer.BlockHandlerBase;
import com.carpentersblocks.renderer.helper.RenderHelperFlowerPot;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.flowerpot.FlowerPotHandler;
import com.carpentersblocks.util.flowerpot.FlowerPotProperties;
import com.carpentersblocks.util.handler.DesignHandler;
import com.carpentersblocks.util.registry.IconRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

@SideOnly(value=Side.CLIENT)
public class BlockHandlerCarpentersFlowerPot
extends BlockHandlerBase {
    @Override
    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    @Override
    protected IIcon getUniqueIcon(ItemStack itemStack, int side, IIcon icon) {
        Block block = BlockProperties.toBlock(itemStack);
        if (block instanceof BlockCoverable) {
            return IconRegistry.icon_uncovered_solid;
        }
        if (block.equals(Blocks.field_150359_w)) {
            return IconRegistry.icon_flower_pot_glass;
        }
        return icon;
    }

    @Override
    protected void renderCarpentersBlock(int x, int y, int z) {
        this.renderBlocks.field_147837_f = true;
        ItemStack itemStack = this.getCoverForRendering(new TEBase[0]);
        if (this.TE.hasDesign()) {
            this.suppressOverlay = true;
            this.suppressChiselDesign = true;
            this.suppressDyeColor = true;
        }
        this.renderPot(itemStack, x, y, z);
        this.suppressOverlay = true;
        this.suppressChiselDesign = true;
        this.suppressDyeColor = true;
        if (this.TE.hasAttribute((byte)23)) {
            this.renderSoil(this.TE.getAttribute((byte)23), x, y, z);
        }
        if (this.TE.hasAttribute((byte)22)) {
            this.renderPlant(this.TE.getAttribute((byte)22), x, y, z);
        }
        this.suppressOverlay = false;
        this.suppressChiselDesign = false;
        this.suppressDyeColor = false;
        this.renderBlocks.field_147837_f = false;
    }

    public boolean renderPot(ItemStack itemStack, int x, int y, int z) {
        if (this.TE.hasDesign()) {
            IIcon designIcon = IconRegistry.icon_design_flower_pot.get(DesignHandler.listFlowerPot.indexOf(this.TE.getDesign()));
            this.setIconOverride(6, designIcon);
        }
        this.renderBlocks.func_147782_a(0.375, 0.0, 0.375, 0.625, 0.0625, 0.625);
        this.renderBlock(itemStack, x, y, z);
        this.renderBlocks.func_147782_a(0.375, 0.0, 0.3125, 0.625, 0.375, 0.375);
        this.renderBlock(itemStack, x, y, z);
        this.renderBlocks.func_147782_a(0.375, 0.0, 0.625, 0.625, 0.375, 0.6875);
        this.renderBlock(itemStack, x, y, z);
        this.renderBlocks.func_147782_a(0.3125, 0.0, 0.3125, 0.375, 0.375, 0.6875);
        this.renderBlock(itemStack, x, y, z);
        this.renderBlocks.func_147782_a(0.625, 0.0, 0.3125, 0.6875, 0.375, 0.6875);
        this.renderBlock(itemStack, x, y, z);
        this.clearIconOverride(6);
        return true;
    }

    public boolean renderSoil(ItemStack itemStack, int x, int y, int z) {
        this.renderBlocks.func_147782_a(0.375, 0.0625, 0.375, 0.625, 0.25, 0.625);
        this.renderBlock(itemStack, x, y, z);
        return true;
    }

    public boolean renderPlant(ItemStack itemStack, int x, int y, int z) {
        Block block = FlowerPotProperties.toBlock(itemStack);
        if (block.func_149701_w() != this.renderPass) {
            return false;
        }
        if (block instanceof BlockCrops) {
            itemStack.func_77964_b(7);
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78372_c(0.0f, 0.25f, 0.0f);
        RenderHelperFlowerPot.setPlantColor(this, itemStack, x, y, z);
        IIcon icon = block.func_149691_a(2, itemStack.func_77960_j());
        switch (FlowerPotHandler.getPlantProfile(itemStack)) {
            case DOUBLEPLANT: {
                RenderHelperFlowerPot.renderBlockDoublePlant(this.TE, this.renderBlocks, itemStack, x, y, z, false);
                break;
            }
            case THIN_DOUBLEPLANT: {
                RenderHelperFlowerPot.renderBlockDoublePlant(this.TE, this.renderBlocks, itemStack, x, y, z, true);
                break;
            }
            case REDUCED_SCALE_YP: {
                RenderHelperFlowerPot.renderPlantCrossedSquares(this.renderBlocks, block, icon, x, y, z, 0.75f, false);
                break;
            }
            case REDUCED_SCALE_YN: {
                RenderHelperFlowerPot.renderPlantCrossedSquares(this.renderBlocks, block, icon, x, y, z, 0.75f, true);
                break;
            }
            case TRUE_SCALE: {
                RenderHelperFlowerPot.renderPlantCrossedSquares(this.renderBlocks, block, icon, x, y, z, 1.0f, false);
                break;
            }
            case THIN_YP: {
                RenderHelperFlowerPot.renderPlantThinCrossedSquares(this.renderBlocks, block, icon, x, y, z, false);
                break;
            }
            case THIN_YN: {
                RenderHelperFlowerPot.renderPlantThinCrossedSquares(this.renderBlocks, block, icon, x, y, z, true);
                break;
            }
            case CACTUS: {
                RenderHelperFlowerPot.drawPlantCactus(this.lightingHelper, this.renderBlocks, itemStack, x, y, z);
                break;
            }
            case LEAVES: {
                this.drawStackedBlocks(itemStack, x, y, z);
            }
        }
        tessellator.func_78372_c(0.0f, -0.25f, 0.0f);
        return true;
    }

    private void drawStackedBlocks(ItemStack itemStack, int x, int y, int z) {
        this.TE.setMetadata(itemStack.func_77960_j());
        this.renderBlocks.func_147782_a(0.375, 0.0, 0.375, 0.625, 0.25, 0.625);
        this.renderBlock(itemStack, x, y, z);
        this.renderBlocks.func_147782_a(0.375, 0.25, 0.375, 0.625, 0.5, 0.625);
        this.renderBlock(itemStack, x, y, z);
        this.renderBlocks.func_147782_a(0.375, 0.5, 0.375, 0.625, 0.75, 0.625);
        this.renderBlock(itemStack, x, y, z);
        this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.TE.restoreMetadata();
    }
}

