/*
 * Decompiled with CFR 0.152.
 */
package net.fuzzycraft.botanichorizons.addons.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.fuzzycraft.botanichorizons.addons.BHBlocks;
import net.fuzzycraft.botanichorizons.addons.Multiblocks;
import net.fuzzycraft.botanichorizons.addons.tileentity.TileAdvancedManaPool;
import net.fuzzycraft.botanichorizons.util.ChargeState;
import net.fuzzycraft.botanichorizons.util.InventoryHelper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipeManaInfusion;
import vazkii.botania.client.core.handler.HUDHandler;

public class TileAdvancedCraftingPool
extends TileAdvancedManaPool {
    public TileAdvancedCraftingPool() {
        super(Multiblocks.poolInfusion);
    }

    @Override
    @Nullable
    public RecipeManaInfusion findMatchingRecipe(ItemStack stack) {
        for (RecipeManaInfusion recipe : BotaniaAPI.manaInfusionRecipes) {
            if (recipe.isAlchemy() || recipe.isConjuration() || !InventoryHelper.isIngredient(stack, recipe.getInput())) continue;
            return recipe;
        }
        return null;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack((Block)BHBlocks.autoPoolInfusion);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUD(Minecraft mc, ScaledResolution res) {
        ChargeState state = ChargeState.genState(this.isOnline, this.storedMana, 1000);
        String tooltip = state.getLocalisedHudString((Block)BHBlocks.autoPoolInfusion);
        HUDHandler.drawSimpleManaHUD((int)state.color, (int)this.storedMana, (int)50000, (String)tooltip, (ScaledResolution)res);
    }
}

