/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.rituals;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class RitualEffectGrowth
extends RitualEffect {
    private static final int aquasalusDrain = 10;
    private static final int terraeDrain = 20;
    private static final int orbisTerraeDrain = 20;
    private static final int virtusDrain = 10;

    @Override
    public void performEffect(IMasterRitualStone ritualStone) {
        String owner = ritualStone.getOwner();
        int currentEssence = SoulNetworkHandler.getCurrentEssence(owner);
        World world = ritualStone.getWorld();
        int x = ritualStone.getXCoord();
        int y = ritualStone.getYCoord();
        int z = ritualStone.getZCoord();
        if (currentEssence < this.getCostPerRefresh() * 9) {
            SoulNetworkHandler.causeNauseaToPlayer(owner);
        } else {
            boolean hasTerrae = this.canDrainReagent(ritualStone, ReagentRegistry.terraeReagent, 20, false);
            boolean hasOrbisTerrae = this.canDrainReagent(ritualStone, ReagentRegistry.orbisTerraeReagent, 20, false);
            boolean hasVirtus = this.canDrainReagent(ritualStone, ReagentRegistry.virtusReagent, 10, false);
            int speed = this.getSpeedForReagents(hasTerrae, hasOrbisTerrae);
            if (world.func_82737_E() % (long)speed != 0L) {
                return;
            }
            if (this.canDrainReagent(ritualStone, ReagentRegistry.aquasalusReagent, 10, false)) {
                int hydrationRange = hasVirtus ? 4 : 1;
                for (int i = -hydrationRange; i <= hydrationRange; ++i) {
                    for (int j = -hydrationRange; j <= hydrationRange; ++j) {
                        for (int k = -hydrationRange; k <= hydrationRange; ++k) {
                            if (!this.canDrainReagent(ritualStone, ReagentRegistry.aquasalusReagent, 10, false) || !SpellHelper.hydrateSoil(world, x + i, y + k, z + j)) continue;
                            this.canDrainReagent(ritualStone, ReagentRegistry.aquasalusReagent, 10, true);
                        }
                    }
                }
            }
            int flag = 0;
            int range = hasVirtus ? 4 : 1;
            for (int i = -range; i <= range; ++i) {
                for (int j = -range; j <= range; ++j) {
                    for (int k = -range; k <= range; ++k) {
                        Block block = world.func_147439_a(x + i, y + k, z + j);
                        if (!(block instanceof IPlantable) && !(block instanceof IGrowable)) continue;
                        SpellHelper.sendIndexedParticleToAllAround(world, x, y, z, 20, world.field_73011_w.field_76574_g, 3, x, y, z);
                        block.func_149674_a(world, x + i, y + k, z + j, world.field_73012_v);
                        ++flag;
                    }
                }
            }
            if (flag > 0) {
                if (hasTerrae) {
                    this.canDrainReagent(ritualStone, ReagentRegistry.terraeReagent, 20, true);
                }
                if (hasOrbisTerrae) {
                    this.canDrainReagent(ritualStone, ReagentRegistry.orbisTerraeReagent, 20, true);
                }
                if (hasVirtus) {
                    this.canDrainReagent(ritualStone, ReagentRegistry.virtusReagent, 10, true);
                }
                SoulNetworkHandler.syphonFromNetwork(owner, this.getCostPerRefresh() * flag);
            }
        }
    }

    @Override
    public int getCostPerRefresh() {
        return AlchemicalWizardry.ritualCostGreenGrove[1];
    }

    @Override
    public List<RitualComponent> getRitualComponentList() {
        ArrayList<RitualComponent> growthRitual = new ArrayList<RitualComponent>();
        growthRitual.add(new RitualComponent(1, 0, 0, 1));
        growthRitual.add(new RitualComponent(-1, 0, 0, 1));
        growthRitual.add(new RitualComponent(0, 0, 1, 1));
        growthRitual.add(new RitualComponent(0, 0, -1, 1));
        growthRitual.add(new RitualComponent(-1, 0, 1, 3));
        growthRitual.add(new RitualComponent(1, 0, 1, 3));
        growthRitual.add(new RitualComponent(-1, 0, -1, 3));
        growthRitual.add(new RitualComponent(1, 0, -1, 3));
        return growthRitual;
    }

    public int getSpeedForReagents(boolean hasTerrae, boolean hasOrbisTerrae) {
        if (hasOrbisTerrae) {
            if (hasTerrae) {
                return 10;
            }
            return 15;
        }
        if (hasTerrae) {
            return 20;
        }
        return 30;
    }
}

